/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class EnumCreator
implements Creator<EnumType> {
    private static final Logger LOG = Logger.getLogger((String)EnumCreator.class.getName());

    @Override
    public EnumType create(ClassInfo classInfo) {
        LOG.debug((Object)("Creating enum from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(ReferenceType.ENUM, classInfo, annotations);
        Optional<String> maybeDescription = DescriptionHelper.getDescriptionForType(annotations);
        EnumType enumType = new EnumType(classInfo.name().toString(), name, maybeDescription.orElse(null));
        List fields = classInfo.fields();
        for (FieldInfo field : fields) {
            if (field.type().kind().equals((Object)Type.Kind.ARRAY)) continue;
            enumType.addValue(field.name());
        }
        return enumType;
    }
}

