/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import java.lang.reflect.InvocationTargetException;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;

public interface LookupService {
    public static final Logger LOG = Logger.getLogger((String)LookupService.class.getName());

    public static LookupService load() {
        LookupService lookupService;
        try {
            ServiceLoader<LookupService> sl = ServiceLoader.load(LookupService.class);
            lookupService = sl.iterator().next();
        }
        catch (Exception ex) {
            lookupService = new DefaultLookupService();
        }
        LOG.debug((Object)("Using " + lookupService.getName() + " lookup service"));
        return lookupService;
    }

    public String getName();

    public Class<?> getClass(Class<?> var1);

    public Object getInstance(Class<?> var1);

    public static class DefaultLookupService
    implements LookupService {
        @Override
        public String getName() {
            return "Reflection (default)";
        }

        @Override
        public Class<?> getClass(Class<?> declaringClass) {
            return declaringClass;
        }

        @Override
        public Object getInstance(Class<?> declaringClass) {
            try {
                return declaringClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("Could not get Instance using the default lookup service", ex);
            }
        }
    }
}

