/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.TransformInfo;
import io.smallrye.graphql.transformation.NumberTransformer;
import io.smallrye.graphql.transformation.Transformer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class FormattedNumberTransformer
implements Transformer {
    private final NumberFormat numberFormat;
    private final NumberTransformer numberTransformer;

    protected FormattedNumberTransformer(Field field) {
        this.numberTransformer = new NumberTransformer(field);
        this.numberFormat = this.getNumberFormat(field.getTransformInfo());
    }

    private NumberFormat getNumberFormat(TransformInfo formatter) {
        String format = formatter.getFormat();
        String locale = formatter.getLocale();
        if (format == null && locale == null) {
            return NumberFormat.getInstance();
        }
        if (format == null) {
            return NumberFormat.getInstance(Locale.forLanguageTag(locale));
        }
        if (locale == null) {
            return new DecimalFormat(format);
        }
        return new DecimalFormat(format, DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale)));
    }

    @Override
    public Object in(Object o) throws ParseException {
        return this.numberTransformer.in(this.numberFormat.parse(o.toString()).toString());
    }

    @Override
    public Object out(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.numberFormat.format(number);
        }
        throw new RuntimeException(String.format("[%s] is no valid number-type", object.getClass()));
    }
}

