/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.transformation.Transformer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class NumberTransformer
implements Transformer {
    private final Field field;

    protected NumberTransformer(Field field) {
        this.field = field;
    }

    @Override
    public Object in(Object o) throws ParseException {
        return this.parseNumber(o.toString(), this.field.getReference().getClassName());
    }

    public Number parseNumber(String input, String typeClassName) throws ParseException {
        if (typeClassName.equals(Integer.TYPE.getName())) {
            return Integer.parseInt(input);
        }
        if (typeClassName.equals(Integer.class.getName())) {
            return Integer.valueOf(input);
        }
        if (typeClassName.equals(Short.TYPE.getName())) {
            return Short.parseShort(input);
        }
        if (typeClassName.equals(Short.class.getName())) {
            return Short.valueOf(input);
        }
        if (typeClassName.equals(Byte.TYPE.getName())) {
            return Byte.parseByte(input);
        }
        if (typeClassName.equals(Byte.class.getName())) {
            return Byte.valueOf(input);
        }
        if (typeClassName.equals(Float.TYPE.getName())) {
            return Float.valueOf(Float.parseFloat(input));
        }
        if (typeClassName.equals(Float.class.getName())) {
            return Float.valueOf(input);
        }
        if (typeClassName.equals(Double.TYPE.getName())) {
            return Double.parseDouble(input);
        }
        if (typeClassName.equals(Double.class.getName())) {
            return Double.valueOf(input);
        }
        if (typeClassName.equals(BigInteger.class.getName())) {
            return new BigInteger(input);
        }
        if (typeClassName.equals(Long.TYPE.getName())) {
            return Long.parseLong(input);
        }
        if (typeClassName.equals(Long.class.getName())) {
            return Long.valueOf(input);
        }
        if (typeClassName.equals(BigDecimal.class.getName())) {
            return new BigDecimal(input);
        }
        throw new RuntimeException(String.format("[%s] is no valid number-type", typeClassName));
    }

    @Override
    public Object out(Object object) {
        return object;
    }
}

