/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.TransformInfo;
import io.smallrye.graphql.transformation.DateTransformer;
import io.smallrye.graphql.transformation.FormattedNumberTransformer;
import io.smallrye.graphql.transformation.LegacyDateTransformer;
import io.smallrye.graphql.transformation.NumberTransformer;
import io.smallrye.graphql.transformation.PassThroughTransformer;
import io.smallrye.graphql.transformation.UriTransformer;
import io.smallrye.graphql.transformation.UrlTransformer;
import io.smallrye.graphql.transformation.UuidTransformer;

public interface Transformer {
    public static final PassThroughTransformer PASS_THROUGH_TRANSFORMER = new PassThroughTransformer();
    public static final UuidTransformer UUID_TRANSFORMER = new UuidTransformer();
    public static final UrlTransformer URL_TRANSFORMER = new UrlTransformer();
    public static final UriTransformer URI_TRANSFORMER = new UriTransformer();

    public static Transformer transformer(Field field) {
        if (field.hasTransformInfo()) {
            TransformInfo format = field.getTransformInfo();
            if (format.getType().equals((Object)TransformInfo.Type.NUMBER)) {
                if (format.getFormat() != null || format.getLocale() != null) {
                    return new FormattedNumberTransformer(field);
                }
                return new NumberTransformer(field);
            }
            if (format.getType().equals((Object)TransformInfo.Type.DATE)) {
                return Transformer.dateTransformer(field);
            }
        } else {
            if (Classes.isUUID(field.getReference().getClassName())) {
                return UUID_TRANSFORMER;
            }
            if (Classes.isURL(field.getReference().getClassName())) {
                return URL_TRANSFORMER;
            }
            if (Classes.isURI(field.getReference().getClassName())) {
                return URI_TRANSFORMER;
            }
            if (Classes.isDateLikeType(field.getReference().getClassName())) {
                return Transformer.dateTransformer(field);
            }
            if (Classes.isNumberLikeType(field.getReference().getClassName())) {
                return new NumberTransformer(field);
            }
        }
        return PASS_THROUGH_TRANSFORMER;
    }

    public static Transformer dateTransformer(Field field) {
        if (LegacyDateTransformer.SUPPORTED_TYPES.contains(field.getReference().getClassName())) {
            return new LegacyDateTransformer(field);
        }
        return new DateTransformer(field);
    }

    public static boolean shouldTransform(Field field) {
        return field.hasTransformInfo() || Classes.isUUID(field.getReference().getClassName()) || Classes.isURL(field.getReference().getClassName()) || Classes.isURI(field.getReference().getClassName()) || Classes.isDateLikeType(field.getReference().getClassName()) || Classes.isNumberLikeType(field.getReference().getClassName());
    }

    public Object in(Object var1) throws Exception;

    public Object out(Object var1);
}

