/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.request.timing.config.RequestTimingConfigParser;
import com.ibm.ws.request.timing.config.Timing;
import com.ibm.ws.request.timing.config.TimingConfigGroup;
import com.ibm.ws.request.timing.internal.config.HungRequestTimingConfig;
import com.ibm.ws.request.timing.internal.config.SlowRequestTimingConfig;
import com.ibm.ws.request.timing.notification.HungRequestNotification;
import com.ibm.ws.request.timing.probeExtensionImpl.HungRequestProbeExtension;
import com.ibm.ws.request.timing.probeExtensionImpl.SlowRequestProbeExtension;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

public class RequestTimingService
implements ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(RequestTimingService.class);
    private volatile Map<String, Object> currentConfig;
    private volatile ConfigurationAdmin configAdmin = null;
    private volatile SlowRequestProbeExtension slowRequestProbeExt = null;
    private volatile HungRequestProbeExtension hungRequestProbeExt = null;
    private String bundleLocation;
    private static volatile ScheduledExecutorService scheduledExecSrvc = null;
    private static volatile ExecutorService executorSrvc = null;
    private static volatile LibertyProcess libertyProcess = null;
    private static volatile List<HungRequestNotification> hungRequestNotifications = Collections.unmodifiableList(new ArrayList());
    private static volatile List<RequestTimingConfigParser> configParsers = Collections.unmodifiableList(new ArrayList());

    @Activate
    protected synchronized void activate(BundleContext ctx, Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.currentConfig = configuration;
        this.bundleLocation = ctx.getBundle().getLocation();
        this.configureService(false);
    }

    @Modified
    protected synchronized void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Modified " + this), (Object[])new Object[0]);
        }
        this.currentConfig = configuration;
        this.configureService(true);
    }

    @Deactivate
    protected synchronized void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        this.bundleLocation = null;
        this.slowRequestProbeExt.stop();
        this.hungRequestProbeExt.stop();
        hungRequestNotifications = Collections.unmodifiableList(new ArrayList());
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    protected void setScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = scheduledExecSrvc;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = null;
    }

    protected void setExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = executorSrvc;
    }

    protected void unsetExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = null;
    }

    protected void setLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = libertyProcess;
    }

    protected void unsetLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = null;
    }

    protected void setSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = probeExt;
    }

    protected void unsetSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = null;
    }

    protected void setHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = probeExt;
    }

    protected void unsetHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = null;
    }

    public synchronized void setHungRequestNotification(HungRequestNotification hungRequestNotification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Setting the hung request notification into list", (Object[])new Object[]{hungRequestNotification.getClass()});
        }
        ArrayList<HungRequestNotification> notifications = new ArrayList<HungRequestNotification>(hungRequestNotifications);
        notifications.add(hungRequestNotification);
        hungRequestNotifications = Collections.unmodifiableList(notifications);
    }

    public synchronized void unsetHungRequestNotification(HungRequestNotification hungRequestNotification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Removing hung request notification from list", (Object[])new Object[]{hungRequestNotification.getClass()});
        }
        ArrayList<HungRequestNotification> notifications = new ArrayList<HungRequestNotification>(hungRequestNotifications);
        notifications.remove(hungRequestNotification);
        hungRequestNotifications = Collections.unmodifiableList(notifications);
    }

    protected synchronized void setConfigParser(RequestTimingConfigParser configParser) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Setting the config parser into list", (Object[])new Object[]{configParser.getClass()});
        }
        ArrayList<RequestTimingConfigParser> parsers = new ArrayList<RequestTimingConfigParser>(configParsers);
        parsers.add(configParser);
        configParsers = Collections.unmodifiableList(parsers);
        if (this.currentConfig != null) {
            this.configureService(true);
        }
    }

    protected synchronized void unsetConfigParser(RequestTimingConfigParser configParser) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Removing config parser from list", (Object[])new Object[]{configParser.getClass()});
        }
        ArrayList<RequestTimingConfigParser> parsers = new ArrayList<RequestTimingConfigParser>(configParsers);
        parsers.remove(configParser);
        configParsers = Collections.unmodifiableList(parsers);
        if (this.currentConfig != null) {
            this.configureService(true);
        }
    }

    private void configureService(boolean modified) {
        Map<String, Object> configuration = this.currentConfig;
        long slowRequestThreshold = 10000L;
        long hungRequestThreshold = 600000L;
        int sampleRate = 1;
        int contextInfoRequirement = 0;
        boolean interruptHungRequest = false;
        HashMap<String, List<Timing>> slowRequestTiming = new HashMap<String, List<Timing>>();
        HashMap<String, List<Timing>> hungRequestTiming = new HashMap<String, List<Timing>>();
        if (configuration.containsKey("sampleRate") && (sampleRate = Integer.parseInt(configuration.get("sampleRate").toString())) < 1) {
            sampleRate = 1;
        }
        if (configuration.containsKey("includeContextInfo")) {
            boolean includeContextInfo = Boolean.parseBoolean(configuration.get("includeContextInfo").toString());
            contextInfoRequirement = includeContextInfo ? 0 : 2;
        }
        if (configuration.containsKey("slowRequestThreshold")) {
            slowRequestThreshold = Long.parseLong(configuration.get("slowRequestThreshold").toString());
        }
        if (configuration.containsKey("hungRequestThreshold")) {
            hungRequestThreshold = Long.parseLong(configuration.get("hungRequestThreshold").toString());
        }
        if (configuration.containsKey("interruptHungRequests")) {
            interruptHungRequest = Boolean.parseBoolean(configuration.get("interruptHungRequests").toString());
        }
        this.addToTimingSet(new Timing("all", Timing.ALL_CONTEXT_INFO, slowRequestThreshold, false), slowRequestTiming);
        this.addToTimingSet(new Timing("all", Timing.ALL_CONTEXT_INFO, hungRequestThreshold, interruptHungRequest), hungRequestTiming);
        for (RequestTimingConfigParser parser : configParsers) {
            String subtype = parser.getElementName();
            String[] timingPids = (String[])configuration.get(subtype);
            if (timingPids == null) continue;
            ArrayList<Dictionary<String, Object>> configElementList = new ArrayList<Dictionary<String, Object>>();
            for (String timingPid : timingPids) {
                try {
                    Dictionary configElement;
                    Configuration config = this.configAdmin.getConfiguration(timingPid, this.bundleLocation);
                    Dictionary dictionary = configElement = config != null ? config.getProperties() : null;
                    if (configElement == null) {
                        Tr.error((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_ERROR1", (Object[])new Object[]{timingPid});
                        continue;
                    }
                    configElementList.add(configElement);
                }
                catch (Exception e) {
                    Object[] objs = new Object[]{this, timingPid};
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"280", (Object[])objs);
                }
            }
            TimingConfigGroup groupConfig = parser.parseConfiguration(configElementList, slowRequestThreshold, hungRequestThreshold, interruptHungRequest);
            ArrayList<String> conflictPids = new ArrayList<String>();
            for (Timing t : groupConfig.getSlowRequestTimings()) {
                this.checkForContextInfoConflict(conflictPids, contextInfoRequirement, t);
                this.addToTimingSet(t, slowRequestTiming);
            }
            for (Timing t : groupConfig.getHungRequestTimings()) {
                this.checkForContextInfoConflict(conflictPids, contextInfoRequirement, t);
                this.addToTimingSet(t, hungRequestTiming);
            }
        }
        SlowRequestTimingConfig slowReqTimingConfig = new SlowRequestTimingConfig(sampleRate, contextInfoRequirement, this.makeReadOnlyMap(slowRequestTiming));
        HungRequestTimingConfig hungReqTimingConfig = new HungRequestTimingConfig(contextInfoRequirement, this.makeReadOnlyMap(hungRequestTiming), interruptHungRequest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request timing configuration", (Object[])new Object[]{slowReqTimingConfig, hungReqTimingConfig});
        }
        if (modified) {
            this.slowRequestProbeExt.updateConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.updateConfig(hungReqTimingConfig);
        } else {
            this.slowRequestProbeExt.setConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.setConfig(hungReqTimingConfig);
        }
    }

    private void checkForContextInfoConflict(List<String> conflictPids, int contextInfoRequirement, Timing t) {
        if (!t.isDefaultTiming() && contextInfoRequirement != 0) {
            String pid = t.getTimingPid();
            if (!conflictPids.contains(pid)) {
                Tr.warning((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_WARNING_CTX_INFO_PATTERN", (Object[])new Object[]{pid});
            }
            if (pid != null) {
                conflictPids.add(pid);
            }
        }
    }

    private Map<String, List<Timing>> makeReadOnlyMap(Map<String, List<Timing>> timingsMap) {
        HashMap<String, List<Timing>> tempMap = new HashMap<String, List<Timing>>(timingsMap.size());
        for (String type : timingsMap.keySet()) {
            tempMap.put(type, Collections.unmodifiableList(timingsMap.get(type)));
        }
        return Collections.unmodifiableMap(tempMap);
    }

    private void addToTimingSet(Timing timing, Map<String, List<Timing>> requestTimingMap) {
        String type = timing.getType();
        if (requestTimingMap.containsKey(type)) {
            List<Timing> timingForType = requestTimingMap.get(type);
            timingForType.add(timing);
        } else {
            ArrayList<Timing> timingForType = new ArrayList<Timing>();
            timingForType.add(timing);
            requestTimingMap.put(type, timingForType);
        }
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecSrvc;
    }

    public static ExecutorService getExecutorService() {
        return executorSrvc;
    }

    public static LibertyProcess getLibertyProcess() {
        return libertyProcess;
    }

    public static List<HungRequestNotification> getHungRequestNotifications() {
        return hungRequestNotifications;
    }

    public static void processAllHungRequestNotifications(String requestId, long threadId) {
        List<HungRequestNotification> hungRequestNotificationList = RequestTimingService.getHungRequestNotifications();
        for (int i = 0; i < hungRequestNotificationList.size(); ++i) {
            HungRequestNotification hungRequestNotification = hungRequestNotificationList.get(i);
            hungRequestNotification.hungRequestDetected(requestId, threadId);
        }
    }

    public void serverStopping() {
        this.slowRequestProbeExt.stop();
        this.hungRequestProbeExt.stop();
    }
}

