/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.serverxml;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.config.xml.ConfigVariables;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.Application;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.microprofile.config.internal.common.ConfigException;
import io.openliberty.microprofile.config.internal.serverxml.InvalidFrameworkStateException;
import io.openliberty.microprofile.config.internal.serverxml.ServiceNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OSGiConfigUtils {
    private static final TraceComponent tc = Tr.register(OSGiConfigUtils.class, (String)"APPCONFIG", (String)"io.openliberty.microprofile.config.internal.serverxml");
    private static final String CFG_SERVICE_FACTORY_PID = "service.factoryPid";
    private static final String CFG_APP_PROPERTIES = "com.ibm.ws.appconfig.appProperties";
    private static final String CFG_CONFIG_PARENT_PID = "config.parentPID";
    private static final String CFG_APP_PROPERTIES_PROPERTY = "com.ibm.ws.appconfig.appProperties.property";
    static final long serialVersionUID = 5263598369044662526L;

    static String getApplicationName(BundleContext bundleContext) {
        String applicationName = null;
        if (FrameworkState.isValid()) {
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd == null) {
                applicationName = OSGiConfigUtils.getCDIAppName(bundleContext);
            } else {
                applicationName = cmd.getJ2EEName().getApplication();
                if (applicationName == null) {
                    throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"no.application.name.CWMCG0201E", (Object[])new Object[0]));
                }
            }
        }
        return applicationName;
    }

    static BundleContext getBundleContext(Class<?> clazz) {
        Bundle bundle;
        BundleContext context = null;
        if (FrameworkState.isValid() && (bundle = FrameworkUtil.getBundle(clazz)) != null) {
            context = bundle.getBundleContext();
        }
        return context;
    }

    static ConfigurationAdmin getConfigurationAdmin(BundleContext bundleContext) throws InvalidFrameworkStateException {
        return OSGiConfigUtils.getService(bundleContext, ConfigurationAdmin.class);
    }

    static CDIService getCDIService(BundleContext bundleContext) throws InvalidFrameworkStateException {
        return OSGiConfigUtils.getService(bundleContext, CDIService.class);
    }

    static ConfigVariables getConfigVariables(BundleContext bundleContext) throws InvalidFrameworkStateException {
        return OSGiConfigUtils.getService(bundleContext, ConfigVariables.class);
    }

    private static <T> T getService(BundleContext bundleContext, Class<T> serviceClass) throws InvalidFrameworkStateException {
        if (!FrameworkState.isValid()) {
            throw new InvalidFrameworkStateException();
        }
        ServiceReference ref = bundleContext.getServiceReference(serviceClass);
        Object service = null;
        if (ref != null) {
            service = bundleContext.getService(ref);
        }
        if (service == null) {
            if (!FrameworkState.isValid()) {
                throw new InvalidFrameworkStateException();
            }
            throw new ServiceNotFoundException(serviceClass);
        }
        return (T)service;
    }

    /*
     * WARNING - void declaration
     */
    private static ServiceReference<Application> getApplicationServiceRef(BundleContext bundleContext, String applicationName) {
        ServiceReference appRef = null;
        if (FrameworkState.isValid()) {
            Collection appRefs;
            try {
                appRefs = bundleContext.getServiceReferences(Application.class, FilterUtils.createPropertyFilter((String)"name", (String)applicationName));
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                void e;
                FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"io.openliberty.microprofile.config.internal.serverxml.OSGiConfigUtils", (String)"188", null, (Object[])new Object[]{bundleContext, applicationName});
                throw new ConfigException((Throwable)e);
            }
            if (appRefs != null && appRefs.size() > 0) {
                if (appRefs.size() > 1) {
                    throw new ConfigException(Tr.formatMessage((TraceComponent)tc, (String)"duplicate.application.name.CWMCG0202E", (Object[])new Object[]{applicationName}));
                }
                appRef = (ServiceReference)appRefs.iterator().next();
            }
        }
        return appRef;
    }

    static String getApplicationPID(BundleContext bundleContext, String applicationName) {
        ServiceReference<Application> appRef;
        String applicationPID = null;
        if (FrameworkState.isValid() && (appRef = OSGiConfigUtils.getApplicationServiceRef(bundleContext, applicationName)) != null) {
            applicationPID = (String)appRef.getProperty("service.pid");
            String sourcePid = (String)appRef.getProperty("ibm.extends.source.pid");
            if (sourcePid != null) {
                applicationPID = sourcePid;
            }
        }
        return applicationPID;
    }

    @FFDCIgnore(value={InvalidFrameworkStateException.class, ServiceNotFoundException.class})
    private static String getCDIAppName(BundleContext bundleContext) {
        String appName = null;
        if (FrameworkState.isValid()) {
            try {
                CDIService cdiService = OSGiConfigUtils.getCDIService(bundleContext);
                appName = cdiService.getCurrentApplicationContextID();
            }
            catch (InvalidFrameworkStateException invalidFrameworkStateException) {
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return appName;
    }

    private static String getApplicationPropertiesConfigFilter(String applicationPid) {
        String applicationConfigFilter = null;
        StringBuilder applicationFilter = new StringBuilder(200);
        applicationFilter.append("(&");
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_SERVICE_FACTORY_PID, (String)CFG_APP_PROPERTIES));
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_CONFIG_PARENT_PID, (String)applicationPid));
        applicationFilter.append(')');
        applicationConfigFilter = applicationFilter.toString();
        return applicationConfigFilter;
    }

    private static String getApplicationPropertiesPropertyConfigFilter(String applicationPropertyPid) {
        String applicationConfigFilter = null;
        StringBuilder applicationFilter = new StringBuilder(200);
        applicationFilter.append("(&");
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_SERVICE_FACTORY_PID, (String)CFG_APP_PROPERTIES_PROPERTY));
        applicationFilter.append(FilterUtils.createPropertyFilter((String)CFG_CONFIG_PARENT_PID, (String)applicationPropertyPid));
        applicationFilter.append(')');
        applicationConfigFilter = applicationFilter.toString();
        return applicationConfigFilter;
    }

    /*
     * WARNING - void declaration
     */
    static SortedSet<Configuration> getConfigurations(ConfigurationAdmin admin, String applicationPID) {
        TreeSet<Configuration> configSet = new TreeSet<Configuration>((o1, o2) -> o1.getPid().compareTo(o2.getPid()));
        if (FrameworkState.isValid()) {
            try {
                String appPropertiesPropertyFilter;
                Configuration[] appPropertiesPropertyOsgiConfigs;
                String applicationPropertiesPid = null;
                String appPropertiesFilter = OSGiConfigUtils.getApplicationPropertiesConfigFilter(applicationPID);
                Configuration[] appPropertiesOsgiConfigs = admin.listConfigurations(appPropertiesFilter);
                if (appPropertiesOsgiConfigs != null) {
                    for (Configuration cfg : appPropertiesOsgiConfigs) {
                        applicationPropertiesPid = cfg.getPid();
                    }
                }
                if (applicationPropertiesPid != null && (appPropertiesPropertyOsgiConfigs = admin.listConfigurations(appPropertiesPropertyFilter = OSGiConfigUtils.getApplicationPropertiesPropertyConfigFilter(applicationPropertiesPid))) != null) {
                    for (Configuration cfg : appPropertiesPropertyOsgiConfigs) {
                        configSet.add(cfg);
                    }
                }
            }
            catch (IOException | InvalidSyntaxException applicationPropertiesPid) {
                void e;
                FFDCFilter.processException((Throwable)applicationPropertiesPid, (String)"io.openliberty.microprofile.config.internal.serverxml.OSGiConfigUtils", (String)"328", null, (Object[])new Object[]{admin, applicationPID});
                throw new ConfigException((Throwable)e);
            }
        }
        return configSet;
    }

    static Map<String, String> getVariablesFromServerXML(ConfigVariables configVariables) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        if (FrameworkState.isValid()) {
            theMap.putAll(configVariables.getUserDefinedVariables());
        }
        return theMap;
    }

    static Map<String, String> getDefaultVariablesFromServerXML(ConfigVariables configVariables) {
        HashMap<String, String> theMap = new HashMap<String, String>();
        if (FrameworkState.isValid()) {
            theMap.putAll(configVariables.getUserDefinedVariableDefaults());
        }
        return theMap;
    }
}

