/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javamail.internal.injection;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.MailSession;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.MailSessionDefinition;
import javax.mail.Session;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MailSessionDefinitionInjectionBinding
extends InjectionBinding<MailSessionDefinition> {
    private static final TraceComponent tc = Tr.register(MailSessionDefinitionInjectionBinding.class, (String)"Mail", (String)"com.ibm.ws.javamail.resources.MailMessages");
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_USER = "user";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_STORE_PROTOCOL = "storeProtocol";
    private static final String KEY_STORE_PROTOCOL_CLASS_NAME = "storeProtocolClassName";
    private static final String KEY_TRANSPORT_PROTOCOL = "transportProtocol";
    private static final String KEY_TRANSPORT_PROTOCOL_CLASS_NAME = "transportProtocolClassName";
    private static final String KEY_HOST = "host";
    private static final String KEY_FROM = "from";
    private String description;
    private boolean XMLDescription;
    private String user;
    private boolean XMLUser;
    private SerializableProtectedString password;
    private boolean XMLPassword;
    private Map<String, String> properties;
    private final Set<String> XMLProperties = new HashSet<String>();
    private String storeProtocol;
    private boolean XMLStoreProtocol;
    private String storeProtocolClassName;
    private boolean XMLStoreProtocolClassName;
    private String transportProtocol;
    private boolean XMLTransportProtocol;
    private String transportProtocolClassName;
    private boolean XMLTransportProtocolClassName;
    private String host;
    private boolean XMLHost;
    private String from;
    private boolean XMLFrom;
    static final long serialVersionUID = 3284641547574871250L;

    public MailSessionDefinitionInjectionBinding(String jndiName, ComponentNameSpaceConfiguration nameSpaceConfig) {
        super(null, nameSpaceConfig);
        this.setJndiName(jndiName);
    }

    @ManualTrace
    public void merge(@Sensitive MailSessionDefinition annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("merge: name=" + this.getJndiName() + ", " + InjectionBinding.toStringSecure((Annotation)annotation)), (Object[])new Object[0]);
        }
        if (member != null) {
            throw new IllegalArgumentException(member.toString());
        }
        this.description = (String)this.mergeAnnotationValue(this.description, this.XMLDescription, annotation.description(), KEY_DESCRIPTION, "");
        this.user = (String)this.mergeAnnotationValue(this.user, this.XMLUser, annotation.user(), KEY_USER, "");
        if (this.password != null) {
            this.password = (SerializableProtectedString)this.mergeAnnotationValue(this.password.getChars(), this.XMLPassword, annotation.password().toCharArray(), KEY_PASSWORD, "");
        }
        this.host = (String)this.mergeAnnotationValue(this.host, this.XMLHost, annotation.host(), KEY_HOST, "");
        this.from = (String)this.mergeAnnotationValue(this.from, this.XMLFrom, annotation.from(), KEY_FROM, "");
        this.properties = this.mergeAnnotationProperties(this.properties, this.XMLProperties, annotation.properties());
        this.storeProtocol = (String)this.mergeAnnotationValue(this.storeProtocol, this.XMLStoreProtocol, annotation.storeProtocol(), KEY_STORE_PROTOCOL, "");
        this.storeProtocolClassName = (String)this.mergeAnnotationValue(this.storeProtocolClassName, this.XMLStoreProtocolClassName, annotation.storeProtocol(), KEY_STORE_PROTOCOL_CLASS_NAME, "");
        this.transportProtocol = (String)this.mergeAnnotationValue(this.transportProtocol, this.XMLTransportProtocol, annotation.transportProtocol(), KEY_TRANSPORT_PROTOCOL, "");
        this.transportProtocolClassName = (String)this.mergeAnnotationValue(this.transportProtocolClassName, this.XMLTransportProtocolClassName, annotation.storeProtocol(), KEY_TRANSPORT_PROTOCOL_CLASS_NAME, "");
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge");
        }
    }

    @ManualTrace
    void resolve() throws InjectionException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resolve", (Object[])new Object[0]);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.properties != null) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                props.put(key, entry.getValue());
            }
        }
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_DESCRIPTION, (Object)this.description);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_FROM, (Object)this.from);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_HOST, (Object)this.host);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_PASSWORD, (Object)this.password);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_STORE_PROTOCOL, (Object)this.storeProtocol);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_STORE_PROTOCOL_CLASS_NAME, (Object)this.storeProtocolClassName);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_TRANSPORT_PROTOCOL, (Object)this.transportProtocol);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_TRANSPORT_PROTOCOL_CLASS_NAME, (Object)this.transportProtocolClassName);
        MailSessionDefinitionInjectionBinding.addOrRemoveProperty(props, (Object)KEY_USER, (Object)this.user);
        this.setObjects(null, this.createDefinitionReference(null, Session.class.getName(), props));
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resolve");
        }
    }

    @ManualTrace
    void mergeXML(MailSession mailSession) throws InjectionConfigurationException {
        String transportProtocolClassNameValue;
        String transportProtocolValue;
        String storeProtocolClassNameValue;
        String storeProtocolValue;
        String passwordValue;
        String userValue;
        String hostValue;
        String fromValue;
        List descriptionList;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("mergeXML: name=" + this.getJndiName() + ", " + mailSession.toString()), (Object[])new Object[0]);
        }
        if ((descriptionList = mailSession.getDescriptions()) != null) {
            Iterator iter = descriptionList.iterator();
            StringBuilder descSB = new StringBuilder();
            while (iter.hasNext()) {
                descSB.append(((Description)iter.next()).getValue());
                descSB.append(" ");
            }
            this.description = (String)this.mergeXMLValue(this.description, descSB.toString().trim(), KEY_DESCRIPTION, KEY_DESCRIPTION, null);
            this.XMLDescription = true;
        }
        if ((fromValue = mailSession.getFrom()) != null) {
            this.from = (String)this.mergeXMLValue(this.from, fromValue, KEY_FROM, KEY_FROM, null);
            this.XMLFrom = true;
        }
        if ((hostValue = mailSession.getHost()) != null) {
            this.host = (String)this.mergeXMLValue(this.host, hostValue, KEY_HOST, KEY_HOST, null);
            this.XMLHost = true;
        }
        if ((userValue = mailSession.getUser()) != null) {
            this.user = (String)this.mergeXMLValue(this.user, userValue, KEY_USER, KEY_USER, null);
            this.XMLUser = true;
        }
        if ((passwordValue = mailSession.getPassword()) != null && this.password != null) {
            this.password = (SerializableProtectedString)this.mergeXMLValue(this.password.getChars(), passwordValue, KEY_PASSWORD, KEY_PASSWORD, null);
            this.XMLPassword = true;
        }
        if ((storeProtocolValue = mailSession.getStoreProtocol()) != null) {
            this.storeProtocol = (String)this.mergeXMLValue(this.storeProtocol, storeProtocolValue, "store-protocol", KEY_STORE_PROTOCOL, null);
            this.XMLStoreProtocol = true;
        }
        if ((storeProtocolClassNameValue = mailSession.getStoreProtocolClassName()) != null) {
            this.storeProtocolClassName = (String)this.mergeXMLValue(this.storeProtocolClassName, storeProtocolClassNameValue, "store-protocol-class-name", KEY_STORE_PROTOCOL_CLASS_NAME, null);
            this.XMLStoreProtocolClassName = true;
        }
        if ((transportProtocolValue = mailSession.getTransportProtocol()) != null) {
            this.transportProtocol = (String)this.mergeXMLValue(this.transportProtocol, transportProtocolValue, "transport-protocol", KEY_TRANSPORT_PROTOCOL, null);
            this.XMLTransportProtocol = true;
        }
        if ((transportProtocolClassNameValue = mailSession.getTransportProtocolClassName()) != null) {
            this.transportProtocolClassName = (String)this.mergeXMLValue(this.transportProtocolClassName, transportProtocolClassNameValue, "transport-protocol-class-name", KEY_TRANSPORT_PROTOCOL_CLASS_NAME, null);
            this.XMLTransportProtocolClassName = true;
        }
        List props = mailSession.getProperties();
        this.properties = this.mergeXMLProperties(this.properties, this.XMLProperties, props);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mergeXML");
        }
    }

    public void mergeSaved(InjectionBinding<MailSessionDefinition> injectionBinding) throws InjectionException {
        MailSessionDefinitionInjectionBinding mailSessionBinding = (MailSessionDefinitionInjectionBinding)injectionBinding;
        this.mergeSavedValue(this.description, mailSessionBinding.description, KEY_DESCRIPTION);
        this.mergeSavedValue(this.user, mailSessionBinding.user, KEY_USER);
        if (this.password != null) {
            this.mergeSavedValue(this.password, mailSessionBinding.password, KEY_PASSWORD);
        }
        this.mergeSavedValue(this.storeProtocol, mailSessionBinding.storeProtocol, "store-protocol");
        this.mergeSavedValue(this.storeProtocolClassName, mailSessionBinding.storeProtocolClassName, "store-protocol-class-name");
        this.mergeSavedValue(this.transportProtocol, mailSessionBinding.transportProtocol, "transport-protocol");
        this.mergeSavedValue(this.transportProtocolClassName, mailSessionBinding.transportProtocolClassName, "transport-protocol-class-name");
        this.mergeSavedValue(this.host, mailSessionBinding.host, KEY_HOST);
        this.mergeSavedValue(this.from, mailSessionBinding.from, KEY_FROM);
        this.mergeSavedValue(this.properties, mailSessionBinding.properties, "properties");
    }

    public Class<?> getAnnotationType() {
        return MailSessionDefinition.class;
    }
}

