/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ClassNotFoundException;
import com.ibm.ws.objectManager.ConcurrentLinkedList;
import com.ibm.ws.objectManager.ConcurrentSubList;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.InvalidTransactionException;
import com.ibm.ws.objectManager.LinkedList;
import com.ibm.ws.objectManager.ManagedObjectInputStream;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectSignatureNotFoundException;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionLock;
import com.ibm.ws.objectManager.TreeMap;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

public abstract class ManagedObject
implements Serializable,
Cloneable {
    private static final Class cclass = ManagedObject.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerObjects");
    private static final long serialVersionUID = 1212101998694878938L;
    public static final int stateError = 0;
    public static final int stateConstructed = 1;
    public static final int stateAdded = 2;
    public static final int stateLocked = 3;
    public static final int stateReplaced = 4;
    public static final int stateToBeDeleted = 5;
    public static final int stateMustBeDeleted = 6;
    public static final int stateDeleted = 7;
    public static final int stateReady = 8;
    static final String[] stateNames = new String[]{"Error", "Constructed", "Added", "Locked", "Replaced", "ToBeDeleted", "MustBeDeleted", "Deleted", "Ready"};
    static final int[] nextStateForAdd = new int[]{0, 2, 0, 0, 0, 0, 0, 0, 0};
    static final int[] nextStateForLock = new int[]{0, 1, 2, 3, 4, 5, 6, 0, 3};
    static final int[] nextStateForUnlock = new int[]{0, 1, 2, 8, 0, 5, 6, 7, 8};
    static final int[] nextStateForReplace = new int[]{0, 0, 2, 4, 4, 0, 0, 0, 0};
    static final int[] nextStateForOptimisticReplace = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    static final int[] nextStateForDelete = new int[]{0, 0, 6, 5, 5, 5, 5, 0, 5};
    static final int[] nextStateForCommit = new int[]{0, 0, 8, 8, 8, 7, 7, 0, 0};
    static final int[] nextStateForOptimisticReplaceCommit = new int[]{0, 0, 2, 3, 4, 5, 6, 7, 8};
    static final int[] nextStateForBackout = new int[]{0, 0, 7, 8, 8, 8, 7, 0, 0};
    static final int[] nextStateForOptimisticReplaceBackout = new int[]{0, 0, 2, 3, 4, 5, 6, 7, 8};
    protected transient int state;
    private transient int previousState;
    private transient Object stateLock = new Object();
    protected transient Token owningToken;
    private transient TransactionLock transactionLock = new TransactionLock(null);
    private transient int numberOfLocksTaken = 0;
    private transient int threadsWaitingForLock = 0;
    protected transient ManagedObject beforeImmage = null;
    protected transient boolean backingOut = false;
    private transient long forcedUpdateSequence = 0L;
    private transient ObjectManagerByteArrayOutputStream latestSerializedBytes;
    transient int latestSerializedSize = 0;
    transient int latestSerializedSizeDelta = 0;
    private transient ForcedUpdateSequenceLock forcedUpdateSequenceLock = new ForcedUpdateSequenceLock();
    private transient long updateSequence = 0L;
    protected transient int objectStoreCacheIndex;
    private static final Hashtable _genericConstructors = new Hashtable(10);
    private static final byte simpleSerialVersion = 0;

    public ManagedObject() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
        }
        this.state = 1;
        this.previousState = -1;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "<init>", "state=" + this.state + "(int) " + stateNames[this.state] + "(String)");
        }
    }

    protected static final ManagedObject restoreFromSerializedBytes(byte[] serializedBytes, ObjectManagerState objectManagerState) throws ObjectManagerException {
        int objectSignature;
        String methodName = "restoreFromSerializedBytes";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, methodName, new Object[]{serializedBytes, objectManagerState});
        }
        ManagedObject managedObjectToReturn = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serializedBytes);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            objectSignature = dataInputStream.readInt();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "restoreFromSerializedBytes", exception, "1:310:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, methodName, exception);
            }
            throw new PermanentIOException(cclass, exception);
        }
        switch (objectSignature) {
            case 0: {
                managedObjectToReturn = ManagedObject.restoreSerializedDefault(byteArrayInputStream, objectManagerState);
                break;
            }
            case 9: {
                managedObjectToReturn = new ConcurrentSubList.Link();
                ((ConcurrentSubList.Link)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 8: {
                managedObjectToReturn = new ConcurrentSubList();
                ((ConcurrentSubList)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 6: {
                managedObjectToReturn = new LinkedList.Link();
                ((LinkedList.Link)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 5: {
                managedObjectToReturn = new LinkedList();
                ((LinkedList)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 10: {
                managedObjectToReturn = new TreeMap();
                ((TreeMap)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 11: {
                managedObjectToReturn = new TreeMap.Entry();
                ((TreeMap.Entry)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 7: {
                managedObjectToReturn = new ConcurrentLinkedList();
                ((ConcurrentLinkedList)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 4: {
                managedObjectToReturn = new ObjectManagerState();
                ((ObjectManagerState)managedObjectToReturn).readObject(dataInputStream, objectManagerState);
                break;
            }
            case 12: {
                String className;
                try {
                    className = dataInputStream.readUTF();
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(cclass, methodName, exception, "1:390:1.34");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(cclass, methodName, exception);
                    }
                    throw new PermanentIOException(cclass, exception);
                }
                try {
                    Constructor constructor = (Constructor)_genericConstructors.get(className);
                    if (constructor == null) {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Class<?> classToInstantiate = Class.forName(className);
                                Constructor<?> retval = classToInstantiate.getDeclaredConstructor(new Class[0]);
                                retval.setAccessible(true);
                                _genericConstructors.put(className, retval);
                                return retval;
                            }
                        });
                    }
                    managedObjectToReturn = (ManagedObject)constructor.newInstance(new Object[0]);
                }
                catch (PrivilegedActionException exception) {
                    Throwable cause = exception.getCause();
                    if (cause instanceof java.lang.ClassNotFoundException) {
                        ObjectManager.ffdc.processException(cclass, methodName, cause, "1:424:1.34");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit(cclass, methodName, cause);
                        }
                        throw new ClassNotFoundException(cclass, (java.lang.ClassNotFoundException)cause);
                    }
                    if (cause instanceof Exception) {
                        ObjectManager.ffdc.processException(cclass, methodName, cause, "1:430:1.34");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit(cclass, methodName, cause);
                        }
                        throw new UnexpectedExceptionException((Object)cclass, (Exception)cause);
                    }
                    ObjectManager.ffdc.processException(cclass, methodName, cause, "1:436:1.34");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(cclass, methodName, cause);
                    }
                    throw (Error)cause;
                }
                catch (Exception exception) {
                    ObjectManager.ffdc.processException(cclass, methodName, exception, "1:444:1.34");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(cclass, methodName, (Object)"via UnexpectedExceptionException");
                    }
                    throw new UnexpectedExceptionException((Object)cclass, exception);
                }
                try {
                    ((SimplifiedSerialization)((Object)managedObjectToReturn)).readObject(dataInputStream, objectManagerState);
                    break;
                }
                catch (IOException exception) {
                    ObjectManager.ffdc.processException(cclass, methodName, exception, "1:459:1.34");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit(cclass, methodName, (Object)"via PermanentIOException");
                    }
                    throw new PermanentIOException(cclass, exception);
                }
            }
            default: {
                ObjectSignatureNotFoundException objectSignatureNotFoundException = new ObjectSignatureNotFoundException(cclass, objectSignature);
                ObjectManager.ffdc.processException(cclass, methodName, objectSignatureNotFoundException, "1:471:1.34");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.bytes(cclass, serializedBytes, 0, Math.min(serializedBytes.length, 1000));
                    trace.exit(cclass, methodName, objectSignatureNotFoundException);
                }
                throw objectSignatureNotFoundException;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, methodName, new Object[]{managedObjectToReturn});
        }
        return managedObjectToReturn;
    }

    protected static final ManagedObject restoreSerializedDefault(ByteArrayInputStream byteArrayInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        String methodName = "restoreSerializedDefault";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(cclass, "restoreSerializedDefault", new Object[]{byteArrayInputStream, objectManagerState});
        }
        ManagedObject managedObjectToReturn = null;
        try {
            ManagedObjectInputStream objectInputStream = new ManagedObjectInputStream(byteArrayInputStream, objectManagerState);
            managedObjectToReturn = (ManagedObject)objectInputStream.readObject();
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(cclass, "restoreSerializedDefault", exception, "1:524:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "restoreSerializedDefault", exception);
            }
            throw new PermanentIOException(cclass, exception);
        }
        catch (java.lang.ClassNotFoundException exception) {
            ObjectManager.ffdc.processException(cclass, "restoreSerializedDefault", exception, "1:535:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(cclass, "restoreSerializedDefault", exception);
            }
            throw new ClassNotFoundException(cclass, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "restoreSerializedDefault", managedObjectToReturn);
        }
        return managedObjectToReturn;
    }

    public final Token getToken() {
        return this.owningToken;
    }

    protected final long getTransactionUnlockSequence() {
        return this.owningToken.objectStore.getObjectManagerState().getGlobalTransactionUnlockSequence();
    }

    protected ObjectManagerByteArrayOutputStream getSerializedBytes() throws ObjectManagerException {
        ObjectManagerByteArrayOutputStream byteArrayOutputStream;
        long estimatedLength;
        String methodName = "getSerializedBytes";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getSerializedBytes");
        }
        try {
            if (this instanceof SimplifiedSerialization) {
                estimatedLength = this.estimatedLength();
                byteArrayOutputStream = this.owningToken.objectStore.getObjectManagerState().getbyteArrayOutputStreamFromPool((int)estimatedLength);
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int signature = this.getSignature();
                dataOutputStream.writeInt(signature);
                if (signature == 12) {
                    dataOutputStream.writeUTF(this.getClass().getName());
                }
                ((SimplifiedSerialization)((Object)this)).writeObject(dataOutputStream);
            } else {
                estimatedLength = 1024L;
                byteArrayOutputStream = this.owningToken.objectStore.getObjectManagerState().getbyteArrayOutputStreamFromPool((int)estimatedLength);
                byteArrayOutputStream.writeInt(0);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.close();
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "getSerializedBytes", exception, "1:619:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getSerializedBytes", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.reserveSpaceInStore(byteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getSerializedBytes", new Object[]{byteArrayOutputStream, new Long(this.updateSequence), new Integer(byteArrayOutputStream.size()), new Long(estimatedLength)});
        }
        return byteArrayOutputStream;
    }

    void reserveSpaceInStore(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        int currentSerializedSize = byteArrayOutputStream.getCount() + this.owningToken.objectStore.getAddSpaceOverhead();
        if (currentSerializedSize > this.latestSerializedSize) {
            this.latestSerializedSizeDelta = currentSerializedSize - this.latestSerializedSize;
            this.owningToken.objectStore.reserve(this.latestSerializedSizeDelta, true);
            this.latestSerializedSize = currentSerializedSize;
        } else {
            this.latestSerializedSizeDelta = 0;
        }
    }

    protected long getSerializedBytesLength() throws ObjectManagerException {
        String methodName = "getSerializedBytesLength";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getSerializedBytesLength");
        }
        class DummyOutputStream
        extends OutputStream {
            DummyOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
            }
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new DummyOutputStream());
        try {
            if (this instanceof SimplifiedSerialization) {
                int signature = this.getSignature();
                dataOutputStream.writeInt(signature);
                if (signature == 12) {
                    dataOutputStream.writeUTF(this.getClass().getName());
                }
                ((SimplifiedSerialization)((Object)this)).writeObject(dataOutputStream);
            } else {
                dataOutputStream.writeInt(0);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(dataOutputStream);
                objectOutputStream.writeObject(this);
                objectOutputStream.close();
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "getSerializedBytesLength", exception, "1:707:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getSerializedBytesLength", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(cclass, "getSerializedBytesLength", new Object[]{dataOutputStream, new Long(dataOutputStream.size())});
        }
        return dataOutputStream.size();
    }

    protected long getUpdateSequence() {
        return this.updateSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ObjectManagerByteArrayOutputStream freeLatestSerializedBytes() throws ObjectManagerException {
        ObjectManagerByteArrayOutputStream serializedBytesToReturn;
        String methodName = "freeLatestSerializedBytes";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "freeLatestSerializedBytes");
        }
        ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
        synchronized (forcedUpdateSequenceLock) {
            serializedBytesToReturn = this.latestSerializedBytes;
            this.latestSerializedBytes = null;
            if (this.updateSequence == this.forcedUpdateSequence) {
                if (serializedBytesToReturn != null) {
                    serializedBytesToReturn.setReleaseSize(this.latestSerializedSize);
                }
                this.latestSerializedSize = 0;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "freeLatestSerializedBytes", new Object[]{serializedBytesToReturn});
        }
        return serializedBytesToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock(TransactionLock newTransactionLock) throws ObjectManagerException {
        String methodName = "lock";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lock", newTransactionLock);
        }
        while (this.transactionLock != newTransactionLock) {
            ManagedObject managedObject = this;
            synchronized (managedObject) {
                if (!this.transactionLock.isLocked()) {
                    this.setState(nextStateForLock);
                    this.transactionLock = newTransactionLock;
                    try {
                        this.beforeImmage = (ManagedObject)this.clone();
                    }
                    catch (CloneNotSupportedException exception) {
                        ObjectManager.ffdc.processException(this, cclass, "lock", exception, "1:807:1.34");
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "lock", exception);
                        }
                        throw new UnexpectedExceptionException((Object)this, exception);
                    }
                }
                if (this.transactionLock != newTransactionLock) {
                    ++this.threadsWaitingForLock;
                    try {
                        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                            trace.debug((Object)this, cclass, "lock", new Object[]{"About to wait()", this.transactionLock.getLockingTransaction(), new Integer(this.threadsWaitingForLock)});
                        }
                        this.wait();
                    }
                    catch (InterruptedException exception) {
                        ObjectManager.ffdc.processException(this, cclass, "lock", exception, "1:829:1.34");
                        --this.threadsWaitingForLock;
                        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                            trace.exit((Object)this, cclass, "lock", exception);
                        }
                        throw new UnexpectedExceptionException((Object)this, exception);
                    }
                    --this.threadsWaitingForLock;
                }
            }
        }
        ++this.numberOfLocksTaken;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "lock");
        }
    }

    private final synchronized void unlock() throws ObjectManagerException {
        String methodName = "unlock";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "unlock", new Object[]{this.transactionLock});
        }
        this.setState(nextStateForUnlock);
        this.transactionLock = new TransactionLock(null);
        this.numberOfLocksTaken = 0;
        this.notify();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "unlock");
        }
    }

    public boolean lockedBy(Transaction transaction) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lockedBy", new Object[]{transaction});
        }
        InternalTransaction internalTransaction = null;
        if (transaction != null) {
            internalTransaction = transaction.internalTransaction;
        }
        if (this.transactionLock.getLockingTransaction() == internalTransaction) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "lockedBy", "returns true");
            }
            return true;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "lockedBy", "returns false");
        }
        return false;
    }

    protected boolean lockedBy(InternalTransaction internalTransaction) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "lockedBy", internalTransaction);
        }
        if (this.transactionLock.getLockingTransaction() == internalTransaction) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "lockedBy", "returns true");
            }
            return true;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "lockedBy", "returns false");
        }
        return false;
    }

    protected boolean isLocked() {
        return this.transactionLock.isLocked();
    }

    protected boolean wasLocked(long unlockPoint) {
        return this.transactionLock.wasLocked(unlockPoint);
    }

    protected TransactionLock getTransactionLock() {
        return this.transactionLock;
    }

    public final Transaction getLockingTransaction() {
        Transaction lockingTransaction = null;
        InternalTransaction internalTransaction = this.transactionLock.getLockingTransaction();
        if (internalTransaction != null) {
            lockingTransaction = internalTransaction.getExternalTransaction();
        }
        return lockingTransaction;
    }

    public void preAdd(Transaction transaction) throws ObjectManagerException {
        String methodName = "preAdd";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preAdd", new Object[]{transaction});
        }
        this.testState(nextStateForAdd);
        this.lock(transaction.internalTransaction.getTransactionLock());
        ++this.updateSequence;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preAdd");
        }
    }

    public void postAdd(Transaction transaction, boolean logged) throws ObjectManagerException {
        String methodName = "postAdd";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postAdd", new Object[]{transaction, new Boolean(logged)});
        }
        if (logged) {
            this.setState(nextStateForAdd);
        } else {
            if (this.numberOfLocksTaken == 1) {
                this.unlock();
            }
            this.owningToken.objectStore.reserve(-this.latestSerializedSizeDelta, false);
            this.latestSerializedSize -= this.latestSerializedSizeDelta;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postAdd");
        }
    }

    public void preReplace(Transaction transaction) throws ObjectManagerException {
        String methodName = "preReplace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preReplace", new Object[]{transaction});
        }
        if (this.transactionLock.getLockingTransaction() != transaction.internalTransaction) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "preReplace", new Object[]{transaction, this.transactionLock});
            }
            throw new InvalidTransactionException(this, transaction.internalTransaction, this.transactionLock);
        }
        this.testState(nextStateForReplace);
        ++this.updateSequence;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preReplace");
        }
    }

    public void postReplace(Transaction transaction, boolean logged) throws ObjectManagerException {
        String methodName = "postReplace";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postReplace", new Object[]{transaction, new Boolean(logged)});
        }
        if (logged) {
            this.setState(nextStateForReplace);
        } else {
            this.owningToken.objectStore.reserve(-this.latestSerializedSizeDelta, false);
            this.latestSerializedSize -= this.latestSerializedSizeDelta;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postReplace");
        }
    }

    public void preOptimisticReplace(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preOptimisticReplace", new Object[]{transaction});
        }
        this.testState(nextStateForOptimisticReplace);
        ++this.updateSequence;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preOptimisticReplace");
        }
    }

    public void postOptimisticReplace(Transaction transaction, boolean logged) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postOptimisticReplace", new Object[]{transaction, new Boolean(logged)});
        }
        if (logged) {
            this.setState(nextStateForOptimisticReplace);
        } else {
            this.owningToken.objectStore.reserve(-this.latestSerializedSizeDelta, false);
            this.latestSerializedSize -= this.latestSerializedSizeDelta;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postOptimisticReplace");
        }
    }

    public void optimisticReplaceLogged(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "optimisticReplaceLogged", "transaction=" + transaction + "(Transaction)");
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "optimisticReplaceLogged");
        }
    }

    public void preDelete(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preDelete", new Object[]{transaction});
        }
        this.testState(nextStateForDelete);
        this.lock(transaction.internalTransaction.getTransactionLock());
        ++this.updateSequence;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preDelete");
        }
    }

    public void postDelete(Transaction transaction, boolean logged) throws ObjectManagerException {
        String methodName = "postDelete";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postDelete", new Object[]{transaction, new Boolean(logged)});
        }
        if (logged) {
            this.setState(nextStateForDelete);
        } else {
            if (this.numberOfLocksTaken == 1) {
                this.unlock();
            }
            this.owningToken.objectStore.reserve(-this.latestSerializedSizeDelta, false);
            this.latestSerializedSize -= this.latestSerializedSizeDelta;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postDelete");
        }
    }

    public void prePrepare(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "prePrepare", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "prePrepare");
        }
    }

    public void preCommit(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preCommit", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Transaction transaction, ObjectManagerByteArrayOutputStream serializedBytes, long savedSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "commit", new Object[]{transaction, serializedBytes, new Long(savedSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
        }
        int entryState = this.state;
        this.setState(nextStateForCommit);
        switch (entryState) {
            case 2: 
            case 4: {
                ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
                synchronized (forcedUpdateSequenceLock) {
                    if (savedSequenceNumber > this.forcedUpdateSequence) {
                        this.forcedUpdateSequence = savedSequenceNumber;
                        this.latestSerializedBytes = serializedBytes;
                        this.owningToken.objectStore.add(this, requiresCurrentCheckpoint);
                    }
                    break;
                }
            }
            case 5: 
            case 6: {
                int tempLatestSerializedSize;
                ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
                synchronized (forcedUpdateSequenceLock) {
                    if (savedSequenceNumber > this.forcedUpdateSequence) {
                        this.forcedUpdateSequence = savedSequenceNumber;
                        if (this.latestSerializedBytes != null) {
                            this.owningToken.objectStore.getObjectManagerState().returnByteArrayOutputStreamToPool(this.latestSerializedBytes);
                            this.latestSerializedBytes = null;
                        }
                    }
                    this.owningToken.objectStore.remove(this.owningToken, requiresCurrentCheckpoint);
                    tempLatestSerializedSize = this.latestSerializedSize;
                    this.latestSerializedSize = 0;
                }
                this.owningToken.objectStore.reserve(-tempLatestSerializedSize, false);
            }
        }
        this.beforeImmage = null;
        this.numberOfLocksTaken = 0;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimisticReplaceCommit(Transaction transaction, ObjectManagerByteArrayOutputStream serializedBytes, long savedSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "optimisticReplaceCommit", new Object[]{transaction, serializedBytes, new Long(savedSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
        }
        this.setState(nextStateForOptimisticReplaceCommit);
        ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
        synchronized (forcedUpdateSequenceLock) {
            if (savedSequenceNumber > this.forcedUpdateSequence) {
                this.forcedUpdateSequence = savedSequenceNumber;
                if (this.state != 7) {
                    this.latestSerializedBytes = serializedBytes;
                    this.owningToken.objectStore.add(this, requiresCurrentCheckpoint);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "optimisticReplaceCommit");
        }
    }

    public void postCommit(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postCommit", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postCommit");
        }
    }

    public void preBackout(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "preBackout", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "preBackout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void backout(Transaction transaction, long savedSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        String methodName = "backout";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "backout", new Object[]{transaction, new Boolean(requiresCurrentCheckpoint)});
        }
        int entryState = this.state;
        this.setState(nextStateForBackout);
        switch (entryState) {
            case 2: 
            case 6: {
                int tempLatestSerializedSize;
                ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
                synchronized (forcedUpdateSequenceLock) {
                    if (savedSequenceNumber > this.forcedUpdateSequence) {
                        this.forcedUpdateSequence = savedSequenceNumber;
                        if (this.latestSerializedBytes != null) {
                            this.owningToken.objectStore.getObjectManagerState().returnByteArrayOutputStreamToPool(this.latestSerializedBytes);
                            this.latestSerializedBytes = null;
                        }
                    }
                    this.owningToken.objectStore.remove(this.owningToken, requiresCurrentCheckpoint);
                    tempLatestSerializedSize = this.latestSerializedSize;
                    this.latestSerializedSize = 0;
                }
                this.owningToken.objectStore.reserve(-tempLatestSerializedSize, false);
                break;
            }
            case 4: {
                this.backingOut = true;
                this.becomeCloneOf(this.beforeImmage);
                this.backingOut = false;
            }
        }
        this.beforeImmage = null;
        this.numberOfLocksTaken = 0;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "backout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimisticReplaceBackout(Transaction transaction, ObjectManagerByteArrayOutputStream serializedBytes, long savedSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "optimisticReplaceBackout", new Object[]{transaction, serializedBytes, new Long(savedSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
        }
        this.setState(nextStateForOptimisticReplaceBackout);
        ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
        synchronized (forcedUpdateSequenceLock) {
            if (savedSequenceNumber > this.forcedUpdateSequence) {
                this.forcedUpdateSequence = savedSequenceNumber;
                if (this.state != 7) {
                    this.latestSerializedBytes = serializedBytes;
                    this.owningToken.objectStore.add(this, requiresCurrentCheckpoint);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "optimisticReplaceBackout");
        }
    }

    public void postBackout(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "postBackout", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "postBackout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpoint(InternalTransaction internalTransaction, ObjectManagerByteArrayOutputStream serializedBytes, long savedSequenceNumber) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "checkpoint", new Object[]{internalTransaction, serializedBytes, new Long(savedSequenceNumber)});
        }
        if (this.lockedBy(internalTransaction)) {
            switch (this.state) {
                case 2: {
                    ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
                    synchronized (forcedUpdateSequenceLock) {
                        if (savedSequenceNumber > this.forcedUpdateSequence) {
                            this.forcedUpdateSequence = savedSequenceNumber;
                            this.latestSerializedBytes = serializedBytes;
                            this.owningToken.objectStore.add(this, true);
                        }
                        break;
                    }
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
                    synchronized (forcedUpdateSequenceLock) {
                        if (savedSequenceNumber > this.forcedUpdateSequence && serializedBytes != null) {
                            this.forcedUpdateSequence = savedSequenceNumber;
                            this.latestSerializedBytes = serializedBytes;
                            this.owningToken.objectStore.add(this, true);
                        }
                        break;
                    }
                }
            }
        } else {
            ForcedUpdateSequenceLock forcedUpdateSequenceLock = this.forcedUpdateSequenceLock;
            synchronized (forcedUpdateSequenceLock) {
                if (savedSequenceNumber > this.forcedUpdateSequence) {
                    this.forcedUpdateSequence = savedSequenceNumber;
                    if (this.state != 7) {
                        this.latestSerializedBytes = serializedBytes;
                        this.owningToken.objectStore.add(this, true);
                    }
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "checkpoint");
        }
    }

    public void recoveryCompleted(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "recoveryCompleted", new Object[]{transaction});
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "recoveryCompleted");
        }
    }

    public void becomeCloneOf(ManagedObject other) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", new Object[]{other});
        }
        Class<?> thisClass = this.getClass();
        Class<?> otherClass = other.getClass();
        while (!thisClass.getName().equals("com.ibm.ws.objectManager.ManagedObject")) {
            AccessibleObject[] fields = thisClass.getDeclaredFields();
            try {
                AccessibleObject.setAccessible(fields, true);
            }
            catch (SecurityException exception) {
                ObjectManager.ffdc.processException(this, cclass, "becomeCloneOf", exception, "1:1887:1.34");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "becomeCloneOf", "via UnexpectedExceptionException");
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
            try {
                for (int i = 0; i < fields.length; ++i) {
                    int modifier = ((Field)fields[i]).getModifiers();
                    if (Modifier.isFinal(modifier) || Modifier.isStatic(modifier)) continue;
                    ((Field)fields[i]).set(this, ((Field)fields[i]).get(other));
                }
            }
            catch (IllegalAccessException exception) {
                ObjectManager.ffdc.processException(this, cclass, "becomeCloneOf", exception, "1:1913:1.34");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "becomeCloneOf", "via UnexpectedExceptionException");
                }
                throw new UnexpectedExceptionException((Object)this, exception);
            }
            thisClass = thisClass.getSuperclass();
            otherClass = otherClass.getSuperclass();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    public int getState() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getState");
        }
        int stateToReturn = this.state;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getState", "returns statetoReturn=" + stateToReturn + "(int) " + stateNames[stateToReturn] + "(String)");
        }
        return stateToReturn;
    }

    private void testState(int[] nextState) throws InvalidStateException {
        int newState;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "testState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
        }
        if ((newState = nextState[this.state]) == 0) {
            InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "testState", new Object[]{invalidStateException, new Integer(newState), stateNames[newState]});
            }
            throw invalidStateException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "testState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int[] nextState) throws StateErrorException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setState", new Object[]{nextState, new Integer(this.state), stateNames[this.state]});
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.previousState = this.state;
            this.state = nextState[this.state];
        }
        if (this.state == 0) {
            StateErrorException stateErrorException = new StateErrorException((Object)this, this.previousState, stateNames[this.previousState]);
            ObjectManager.ffdc.processException(this, cclass, "setState", stateErrorException, "1:2016:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "setState", new Object[]{stateErrorException, new Integer(this.state), stateNames[this.state]});
            }
            throw stateErrorException;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "setState", "state=" + this.state + "(int) " + stateNames[this.state] + "(String)");
        }
    }

    public String toString() {
        if (this.owningToken == null) {
            return new String("ManagedObject(null/null)/" + stateNames[this.state] + "/" + Integer.toHexString(this.hashCode()));
        }
        return new String("ManagedObject(" + this.owningToken.objectStoreIdentifier + "/" + this.owningToken.storedObjectIdentifier + ")/" + stateNames[this.state] + "/" + Integer.toHexString(this.hashCode()));
    }

    protected static long maximumSerializedSize() {
        return 5L;
    }

    int getSignature() {
        return 12;
    }

    public long estimatedLength() {
        return 64L;
    }

    protected void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException, IOException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", new Object[]{dataOutputStream});
        }
        try {
            dataOutputStream.writeByte(0);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "writeObject", exception, "1:2111:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    protected void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException, IOException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", new Object[]{"version:2147", new Byte(version)});
            }
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:2151:1.34");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", new Object[]{exception});
            }
            throw new PermanentIOException((Object)this, exception);
        }
        this.state = 8;
        this.previousState = -1;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, java.lang.ClassNotFoundException {
        String methodName = "readObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", new Object[]{objectInputStream});
        }
        objectInputStream.defaultReadObject();
        this.threadsWaitingForLock = 0;
        this.forcedUpdateSequence = 0L;
        this.forcedUpdateSequenceLock = new ForcedUpdateSequenceLock();
        this.transactionLock = new TransactionLock(null);
        this.state = 8;
        this.previousState = -1;
        this.stateLock = new Object();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    private class ForcedUpdateSequenceLock {
        private ForcedUpdateSequenceLock() {
        }
    }
}

