/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLEnumType
implements GraphQLNamedInputType,
GraphQLNamedOutputType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final Map<String, GraphQLEnumValueDefinition> valueDefinitionMap = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
    private final EnumTypeDefinition definition;
    private final List<EnumTypeExtensionDefinition> extensionDefinitions;
    private final List<GraphQLDirective> directives;
    public static final String CHILD_VALUES = "values";
    public static final String CHILD_DIRECTIVES = "directives";
    private final Coercing coercing = new Coercing(){

        public Object serialize(Object input) {
            return GraphQLEnumType.this.getNameByValue(input);
        }

        public Object parseValue(Object input) {
            return GraphQLEnumType.this.getValueByName(input);
        }

        private String typeName(Object input) {
            if (input == null) {
                return "null";
            }
            return input.getClass().getSimpleName();
        }

        public Object parseLiteral(Object input) {
            if (!(input instanceof EnumValue)) {
                throw new CoercingParseLiteralException("Expected AST type 'EnumValue' but was '" + this.typeName(input) + "'.");
            }
            EnumValue enumValue = (EnumValue)input;
            GraphQLEnumValueDefinition enumValueDefinition = (GraphQLEnumValueDefinition)GraphQLEnumType.this.valueDefinitionMap.get(enumValue.getName());
            if (enumValueDefinition == null) {
                throw new CoercingParseLiteralException("Expected enum literal value not in allowable values -  '" + String.valueOf(input) + "'.");
            }
            return enumValueDefinition.getValue();
        }
    };

    @Internal
    @Deprecated
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values) {
        this(name, description, values, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values, List<GraphQLDirective> directives, EnumTypeDefinition definition) {
        this(name, description, values, directives, definition, Collections.emptyList());
    }

    private GraphQLEnumType(String name, String description, List<GraphQLEnumValueDefinition> values, List<GraphQLDirective> directives, EnumTypeDefinition definition, List<EnumTypeExtensionDefinition> extensionDefinitions) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.definition = definition;
        this.extensionDefinitions = Collections.unmodifiableList(new ArrayList<EnumTypeExtensionDefinition>(extensionDefinitions));
        this.directives = directives;
        this.buildMap(values);
    }

    public List<GraphQLEnumValueDefinition> getValues() {
        return new ArrayList<GraphQLEnumValueDefinition>(this.valueDefinitionMap.values());
    }

    public GraphQLEnumValueDefinition getValue(String name) {
        return this.valueDefinitionMap.get(name);
    }

    private void buildMap(List<GraphQLEnumValueDefinition> values) {
        for (GraphQLEnumValueDefinition valueDefinition : values) {
            String name = valueDefinition.getName();
            if (this.valueDefinitionMap.containsKey(name)) {
                throw new AssertException("value " + name + " redefined");
            }
            this.valueDefinitionMap.put(name, valueDefinition);
        }
    }

    private Object getValueByName(Object value) {
        GraphQLEnumValueDefinition enumValueDefinition = this.valueDefinitionMap.get(value.toString());
        if (enumValueDefinition != null) {
            return enumValueDefinition.getValue();
        }
        throw new CoercingParseValueException("Invalid input for Enum '" + this.name + "'. No value found for name '" + value.toString() + "'");
    }

    private Object getNameByValue(Object value) {
        for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
            Object definitionValue = valueDefinition.getValue();
            if (value.equals(definitionValue)) {
                return valueDefinition.getName();
            }
            if (!(definitionValue instanceof Enum) || !(value instanceof String) || !value.equals(((Enum)definitionValue).name())) continue;
            return valueDefinition.getName();
        }
        if (value instanceof Enum) {
            String enumNameValue = ((Enum)value).name();
            for (GraphQLEnumValueDefinition valueDefinition : this.valueDefinitionMap.values()) {
                String definitionValue = String.valueOf(valueDefinition.getValue());
                if (!enumNameValue.equals(definitionValue)) continue;
                return valueDefinition.getName();
            }
        }
        throw new CoercingSerializeException("Invalid input for Enum '" + this.name + "'. Unknown value '" + value + "'");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Coercing getCoercing() {
        return this.coercing;
    }

    @Override
    public EnumTypeDefinition getDefinition() {
        return this.definition;
    }

    public List<EnumTypeExtensionDefinition> getExtensionDefinitions() {
        return this.extensionDefinitions;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public GraphQLEnumType transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLEnumType.newEnum(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLEnumType(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>(this.valueDefinitionMap.values());
        children.addAll(this.directives);
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_VALUES, this.valueDefinitionMap.values()).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public GraphQLEnumType withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)).replaceValues(newChildren.getChildren(CHILD_VALUES)));
    }

    public static Builder newEnum() {
        return new Builder();
    }

    public static Builder newEnum(GraphQLEnumType existing) {
        return new Builder(existing);
    }

    public static class Builder
    extends GraphqlTypeBuilder {
        private EnumTypeDefinition definition;
        private List<EnumTypeExtensionDefinition> extensionDefinitions = Collections.emptyList();
        private final Map<String, GraphQLEnumValueDefinition> values = new LinkedHashMap<String, GraphQLEnumValueDefinition>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLEnumType existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.definition = existing.getDefinition();
            this.extensionDefinitions = existing.getExtensionDefinitions();
            this.values.putAll(FpKit.getByName(existing.getValues(), GraphQLEnumValueDefinition::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(EnumTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder extensionDefinitions(List<EnumTypeExtensionDefinition> extensionDefinitions) {
            this.extensionDefinitions = extensionDefinitions;
            return this;
        }

        public Builder value(String name, Object value, String description, String deprecationReason) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description(description).value(value).deprecationReason(deprecationReason).build());
        }

        public Builder value(String name, Object value, String description) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).description(description).value(value).build());
        }

        public Builder value(String name, Object value) {
            Assert.assertNotNull(value, "value can't be null", new Object[0]);
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).value(value).build());
        }

        public Builder value(String name) {
            return this.value(GraphQLEnumValueDefinition.newEnumValueDefinition().name(name).value(name).build());
        }

        public Builder values(List<GraphQLEnumValueDefinition> valueDefinitions) {
            valueDefinitions.forEach(this::value);
            return this;
        }

        public Builder replaceValues(List<GraphQLEnumValueDefinition> valueDefinitions) {
            this.values.clear();
            valueDefinitions.forEach(this::value);
            return this;
        }

        public Builder value(GraphQLEnumValueDefinition enumValueDefinition) {
            Assert.assertNotNull(enumValueDefinition, "enumValueDefinition can't be null", new Object[0]);
            this.values.put(enumValueDefinition.getName(), enumValueDefinition);
            return this;
        }

        public boolean hasValue(String name) {
            return this.values.containsKey(name);
        }

        public Builder clearValues() {
            this.values.clear();
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, "directive can't be null", new Object[0]);
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLEnumType build() {
            return new GraphQLEnumType(this.name, this.description, this.sort(this.values, GraphQLEnumType.class, GraphQLEnumValueDefinition.class), this.sort(this.directives, GraphQLEnumType.class, GraphQLDirective.class), this.definition, this.extensionDefinitions);
        }
    }
}

