/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.am;

import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmImpl;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class AlarmManager {
    private static ScheduledExecutorService executorService;
    public static final AtomicServiceReference<ScheduledExecutorService> executorServiceRef;

    public static Alarm createNonDeferrable(long delay, AlarmListener alarmListener) {
        return AlarmManager.createNonDeferrable(delay, alarmListener, null);
    }

    public static Alarm createDeferrable(long delay, AlarmListener alarmListener) {
        return AlarmManager.createDeferrable(delay, alarmListener, null);
    }

    public static Alarm createNonDeferrable(long delay, AlarmListener alarmListener, Object context) {
        ScheduledFuture<?> future = null;
        AlarmImpl alarm = null;
        if (executorService != null && (future = executorService.schedule(new AlarmRunnable(alarmListener, context), delay, TimeUnit.MILLISECONDS)) != null) {
            alarm = new AlarmImpl(future);
        }
        return alarm;
    }

    public static Alarm createDeferrable(long delay, AlarmListener alarmListener, Object context) {
        ScheduledFuture<?> future = null;
        AlarmImpl alarm = null;
        if (executorService != null && (future = executorService.schedule(new AlarmRunnable(alarmListener, context), delay, TimeUnit.MILLISECONDS)) != null) {
            alarm = new AlarmImpl(future);
        }
        return alarm;
    }

    protected void activate(ComponentContext context) {
        executorServiceRef.activate(context);
        executorService = (ScheduledExecutorService)executorServiceRef.getServiceWithException();
    }

    protected void deactivate(ComponentContext context) {
        executorServiceRef.deactivate(context);
        executorService = null;
    }

    protected void setScheduledExecutor(ServiceReference<ScheduledExecutorService> ref) {
        executorServiceRef.setReference(ref);
    }

    protected void unsetScheduledExecutor(ServiceReference<ScheduledExecutorService> ref) {
        executorServiceRef.unsetReference(ref);
    }

    static {
        executorServiceRef = new AtomicServiceReference("scheduledExecutor");
    }

    private static class AlarmRunnable
    implements Runnable {
        AlarmListener alarmListener = null;
        Object context = null;

        AlarmRunnable(AlarmListener alarmListener, Object context) {
            this.alarmListener = alarmListener;
            this.context = context;
        }

        @Override
        public void run() {
            this.alarmListener.alarm(this.context);
        }
    }
}

