/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={KerberosService.class}, configurationPid={"com.ibm.ws.security.kerberos.auth.KerberosService"}, immediate=true, property={"service.vendor=IBM"})
public class KerberosService {
    private static final TraceComponent tc = Tr.register(KerberosService.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.auth.internal.resources.KerberosMessages");
    private static final String KRB5_CONFIG_PROPERTY = "java.security.krb5.conf";
    static SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    private Path keytab;
    private Path configFile;
    static final long serialVersionUID = 2532078167879369999L;

    @ManualTrace
    @Activate
    protected void activate(ComponentContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[]{ctx.getProperties()});
        }
        String rawKeytab = (String)ctx.getProperties().get("keytab");
        String rawConfigFile = (String)ctx.getProperties().get("configFile");
        if (rawKeytab != null) {
            this.keytab = Paths.get(rawKeytab, new String[0]);
            if (this.keytab.toFile().exists()) {
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"KRB5_FILE_FOUND_CWWKS4346I", (Object[])new Object[]{"keytab", this.keytab.toAbsolutePath()});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"keytab", "<kerberos>", this.keytab.toAbsolutePath()});
            }
        }
        if (rawConfigFile != null) {
            this.configFile = Paths.get(rawConfigFile, new String[0]);
            String originalConfigFile = priv.getProperty(KRB5_CONFIG_PROPERTY);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Setting system property java.security.krb5.conf=" + this.configFile.toAbsolutePath().toString() + "  Previous value was: " + originalConfigFile), (Object[])new Object[0]);
            }
            priv.setProperty(KRB5_CONFIG_PROPERTY, this.configFile.toAbsolutePath().toString());
            if (this.configFile.toFile().exists()) {
                if (tc.isInfoEnabled()) {
                    Tr.info((TraceComponent)tc, (String)"KRB5_FILE_FOUND_CWWKS4346I", (Object[])new Object[]{"configFile", this.configFile.toAbsolutePath()});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)"KRB5_FILE_NOT_FOUND_CWWKS4345E", (Object[])new Object[]{"configFile", "<kerberos>", this.configFile.toAbsolutePath()});
            }
        }
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public Path getKeytab() {
        return this.keytab;
    }
}

