/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder;
import com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder;
import com.ibm.ws.security.saml.sso20.rs.RsAssertionValidator;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.common.SAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RsSamlConsumer<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(RsSamlConsumer.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static RsSamlConsumer<?, ?, ?> instance = new RsSamlConsumer();
    static final long serialVersionUID = -1038309578086514297L;

    public static RsSamlConsumer<?, ?, ?> getInstance() {
        return instance;
    }

    static void setInstance(RsSamlConsumer<?, ?, ?> instance) {
        RsSamlConsumer.instance = instance;
    }

    @FFDCIgnore(value={SamlException.class})
    public BasicMessageContext<InboundMessageType, OutboundMessageType, NameIdentifierType> handleSAMLResponse(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, SsoRequest samlRequest, String headerContent) throws SamlException {
        BasicMessageContext<?, ?, ?> messageContext = null;
        try {
            BasicMessageContextBuilder<?, ?, ?> ctxBuilder = BasicMessageContextBuilder.getInstance();
            messageContext = ctxBuilder.buildRsSaml(req, res, ssoService, null, samlRequest);
            headerContent = headerContent.trim();
            byte[] bytes = null;
            bytes = headerContent.startsWith("<") && headerContent.endsWith(">") ? headerContent.getBytes("UTF-8") : Base64.decode((String)headerContent);
            if (bytes == null) {
                throw new SamlException("SAML_BAD_INBOUND_SAML_TOKEN", null, new Object[]{headerContent});
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ByteArrayDecoder byteArrayDecoder = new ByteArrayDecoder();
            byteArrayDecoder.doDecode((MessageContext)messageContext, byteArrayInputStream);
            List<Assertion> assertions = this.decryptEncryptedAssertion(messageContext);
            Assertion validatedAssertion = null;
            SamlException lastSamlException = null;
            Exception lastException = null;
            for (Assertion assertion : assertions) {
                if (assertion.getAuthnStatements().size() > 0 && assertion.getSubject() != null) {
                    try {
                        String issuer = assertion.getIssuer().getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Issuer from ToBeValidate-assertion:" + issuer), (Object[])new Object[0]);
                        }
                        messageContext.setInboundMessageIssuer(issuer);
                        RsAssertionValidator rsAssertionValidator = new RsAssertionValidator(messageContext, assertion);
                        rsAssertionValidator.validateAssertion();
                        validatedAssertion = assertion;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found valid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        break;
                    }
                    catch (SamlException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        }
                        lastSamlException = e;
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"120", (Object)this, (Object[])new Object[]{req, res, ssoService, samlRequest, headerContent});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        }
                        lastException = e;
                        continue;
                    }
                }
                if (assertion.getSubject() != null) continue;
                lastException = new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"Subject"});
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Assertion " + assertion.getID() + " does not contain Subject"), (Object[])new Object[0]);
            }
            if (validatedAssertion != null) {
                messageContext.setValidatedAssertion(validatedAssertion);
            } else {
                if (lastException != null) {
                    throw lastException;
                }
                if (lastSamlException != null) {
                    throw lastSamlException;
                }
            }
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"151", (Object)this, (Object[])new Object[]{req, res, ssoService, samlRequest, headerContent});
            throw new SamlException(e);
        }
        return messageContext;
    }

    /*
     * WARNING - void declaration
     */
    List<Assertion> decryptEncryptedAssertion(BasicMessageContext<?, ?, ?> context) throws SamlException {
        ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
        XMLObject objectMessage = context.getInboundMessage();
        if (objectMessage instanceof Response) {
            SsoSamlService ssoSamlService = context.getSsoService();
            String headerName = ssoSamlService.getConfig().getHeaderName();
            throw new SamlException("RS_SAML_RESPONSE_NOT_SUPPORTED", null, new Object[]{headerName});
        }
        if (objectMessage instanceof EncryptedAssertion) {
            try {
                EncryptedAssertion eA = (EncryptedAssertion)objectMessage;
                Decrypter decrypter = context.getDecrypter();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encryptedAssertion:" + eA + " decrypter:" + decrypter), (Object[])new Object[0]);
                }
                Assertion decryptedAssertion = decrypter.decrypt(eA);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decryptedAssertion:" + decryptedAssertion), (Object[])new Object[0]);
                }
                assertionList.add(decryptedAssertion);
            }
            catch (Exception eA) {
                void e;
                FFDCFilter.processException((Throwable)eA, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"183", (Object)this, (Object[])new Object[]{context});
                throw new SamlException((Exception)e);
            }
            return assertionList;
        }
        if (objectMessage instanceof Assertion) {
            assertionList.add((Assertion)objectMessage);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("InboundMessage is:" + objectMessage.getClass().getName() + "\n" + objectMessage), (Object[])new Object[0]);
        }
        return assertionList;
    }
}

