/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.springboot.container.config.ConfigElement;
import com.ibm.ws.app.manager.springboot.container.config.ConfigElementList;
import com.ibm.ws.app.manager.springboot.container.config.HttpEndpoint;
import com.ibm.ws.app.manager.springboot.container.config.HttpOptions;
import com.ibm.ws.app.manager.springboot.container.config.KeyEntry;
import com.ibm.ws.app.manager.springboot.container.config.KeyStore;
import com.ibm.ws.app.manager.springboot.container.config.SSLConfig;
import com.ibm.ws.app.manager.springboot.container.config.ServerConfiguration;
import com.ibm.ws.app.manager.springboot.container.config.SslOptions;
import com.ibm.ws.app.manager.springboot.container.config.VirtualHost;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ServerConfigurationWriter {
    private static ServerConfigurationWriter INSTANCE;
    private static final String SERVER_DEFAULT_ENCODING = "UTF-8";
    private final String encoding = "UTF-8";
    private XMLStreamWriter xmlStreamWriter;
    private Writer writer;
    private String LINE_SEPARATOR = null;
    static final long serialVersionUID = -562919003996829452L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static ServerConfigurationWriter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerConfigurationWriter();
        }
        return INSTANCE;
    }

    public void write(ServerConfiguration sourceConfig, Writer writer) throws XMLStreamException, IOException {
        this.writer = writer;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.xmlStreamWriter = factory.createXMLStreamWriter(writer);
        this.xmlStreamWriter.writeStartDocument(SERVER_DEFAULT_ENCODING, "1.0");
        this.indent(0);
        this.xmlStreamWriter.writeStartElement(ServerConfiguration.XML_ELEMENT_NAME_SERVER);
        this.writeVirtualHost(sourceConfig);
        this.writeSsl(sourceConfig);
        this.writeHttpEndpoint(sourceConfig);
        this.indent(0);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
        this.xmlStreamWriter.close();
        writer.close();
    }

    void indent(int count) throws IOException, XMLStreamException {
        this.xmlStreamWriter.flush();
        this.xmlStreamWriter.writeCharacters(" ");
        this.writer.write(this.getLineSeparator());
        for (int i = 0; i < count; ++i) {
            this.xmlStreamWriter.writeCharacters("    ");
        }
    }

    String getLineSeparator() {
        if (null == this.LINE_SEPARATOR) {
            String ls = (String)AccessController.doPrivileged(() -> System.getProperty("line.separator"));
            this.LINE_SEPARATOR = null != ls && (ls.equals("\n") || ls.equals("\r") || ls.equals("\r\n")) ? ls : "\n";
        }
        return this.LINE_SEPARATOR;
    }

    void writeVirtualHost(ServerConfiguration sourceConfig) throws XMLStreamException, IOException {
        ConfigElementList<VirtualHost> virtualHosts = sourceConfig.getVirtualHosts();
        if (virtualHosts != null && virtualHosts.size() > 0) {
            VirtualHost vh = (VirtualHost)virtualHosts.get(0);
            this.indent(1);
            this.xmlStreamWriter.writeStartElement(ServerConfiguration.XML_ELEMENT_NAME_VIRTUAL_HOST);
            if (vh.getAllowFromEndpointRef() != null && !vh.getAllowFromEndpointRef().isEmpty()) {
                this.xmlStreamWriter.writeAttribute(VirtualHost.XML_ATTRIBUTE_NAME_ALLOW_FROM_ENDPOINT_REF, vh.getAllowFromEndpointRef());
            }
            this.xmlStreamWriter.writeAttribute(ConfigElement.XML_ATTRIBUTE_NAME_ID, vh.getId());
            for (String ha : vh.getHostAliases()) {
                if (ha == null || "".equals(ha)) continue;
                this.indent(2);
                this.xmlStreamWriter.writeStartElement(VirtualHost.XML_ELEMENT_NAME_HOST_ALIAS);
                this.xmlStreamWriter.writeCharacters(ha);
                this.xmlStreamWriter.writeEndElement();
            }
            this.indent(1);
            this.xmlStreamWriter.writeEndElement();
        }
    }

    void writeHttpEndpoint(ServerConfiguration sourceConfig) throws XMLStreamException, IOException {
        ConfigElementList<HttpEndpoint> endpoints = sourceConfig.getHttpEndpoints();
        if (endpoints != null && endpoints.size() > 0) {
            String sslRef;
            SslOptions sslOptions;
            String serverHeader;
            HttpEndpoint ep = (HttpEndpoint)endpoints.get(0);
            this.indent(1);
            this.xmlStreamWriter.writeStartElement(ServerConfiguration.XML_ELEMENT_NAME_HTTP_ENDPOINT);
            this.xmlStreamWriter.writeAttribute("host", ep.getHost());
            this.xmlStreamWriter.writeAttribute("httpPort", ep.getHttpPort().toString());
            this.xmlStreamWriter.writeAttribute("httpsPort", ep.getHttpsPort().toString());
            String protocolVersion = ep.getProtocolVersion();
            if (protocolVersion != null) {
                this.xmlStreamWriter.writeAttribute("protocolVersion", ep.getProtocolVersion());
            }
            this.xmlStreamWriter.writeAttribute(ConfigElement.XML_ATTRIBUTE_NAME_ID, ep.getId());
            HttpOptions httpOptions = ep.getHttpOptions();
            if (httpOptions != null && (serverHeader = httpOptions.getServerHeaderValue()) != null) {
                this.indent(2);
                this.xmlStreamWriter.writeStartElement("httpOptions");
                this.xmlStreamWriter.writeAttribute(HttpOptions.XML_ATTRIBUTE_NAME_SERVER_HEADER_VALUE, serverHeader);
                this.xmlStreamWriter.writeEndElement();
            }
            if ((sslOptions = ep.getSslOptions()) != null && (sslRef = sslOptions.getSslRef()) != null) {
                this.indent(2);
                this.xmlStreamWriter.writeStartElement("sslOptions");
                this.xmlStreamWriter.writeAttribute("sslRef", sslRef);
                this.xmlStreamWriter.writeEndElement();
            }
            this.indent(1);
            this.xmlStreamWriter.writeEndElement();
        }
    }

    void writeSsl(ServerConfiguration sourceConfig) throws XMLStreamException, IOException {
        ConfigElementList<SSLConfig> ssls = sourceConfig.getSsls();
        if (ssls != null && ssls.size() > 0) {
            Boolean clientAuth;
            String enabledCiphers;
            String sslProtocol;
            SSLConfig ssl = (SSLConfig)ssls.get(0);
            this.indent(1);
            this.xmlStreamWriter.writeStartElement(ServerConfiguration.XML_ELEMENT_NAME_SSL);
            this.xmlStreamWriter.writeAttribute("keyStoreRef", ssl.getKeyStoreRef());
            String trustStoreRef = ssl.getTrustStoreRef();
            if (trustStoreRef != null && !"".equals(trustStoreRef)) {
                this.xmlStreamWriter.writeAttribute("trustStoreRef", trustStoreRef);
            }
            if ((sslProtocol = ssl.getSslProtocol()) != null) {
                this.xmlStreamWriter.writeAttribute("sslProtocol", sslProtocol);
            }
            if ((enabledCiphers = ssl.getEnabledCiphers()) != null) {
                this.xmlStreamWriter.writeAttribute("enabledCiphers", enabledCiphers);
            }
            if ((clientAuth = ssl.getClientAuthentication()) != null && clientAuth.booleanValue()) {
                this.xmlStreamWriter.writeAttribute("clientAuthentication", clientAuth.toString());
            } else {
                Boolean clientAuthSupported = ssl.getClientAuthenticationSupported();
                if (clientAuthSupported != null && clientAuthSupported.booleanValue()) {
                    this.xmlStreamWriter.writeAttribute("clientAuthenticationSupported", clientAuthSupported.toString());
                }
            }
            this.xmlStreamWriter.writeAttribute(ConfigElement.XML_ATTRIBUTE_NAME_ID, ssl.getId());
            this.indent(1);
            this.xmlStreamWriter.writeEndElement();
            this.writeKeyAndTrustStores(sourceConfig);
        }
    }

    void writeKeyAndTrustStores(ServerConfiguration sourceConfig) throws XMLStreamException, IOException {
        ConfigElementList<KeyStore> keyStores = sourceConfig.getKeyStores();
        if (keyStores != null && keyStores.size() > 0) {
            for (KeyStore keyStore : keyStores) {
                String provider;
                String type;
                this.indent(1);
                this.xmlStreamWriter.writeStartElement(ServerConfiguration.XML_ELEMENT_NAME_KEYSTORE);
                this.xmlStreamWriter.writeAttribute("location", keyStore.getLocation());
                String password = keyStore.getPassword();
                if (password != null && !"".equals(password)) {
                    this.xmlStreamWriter.writeAttribute("password", password);
                }
                if ((type = keyStore.getType()) != null && !"".equals(type)) {
                    this.xmlStreamWriter.writeAttribute("type", type);
                }
                if ((provider = keyStore.getProvider()) != null && !"".equals(provider)) {
                    this.xmlStreamWriter.writeAttribute("provider", provider);
                }
                this.xmlStreamWriter.writeAttribute(ConfigElement.XML_ATTRIBUTE_NAME_ID, keyStore.getId());
                ConfigElementList<KeyEntry> keyEntries = keyStore.getKeyEntries();
                if (keyEntries != null && keyEntries.size() > 0) {
                    KeyEntry keyEntry = (KeyEntry)keyEntries.get(0);
                    this.indent(2);
                    this.xmlStreamWriter.writeStartElement("keyEntry");
                    this.xmlStreamWriter.writeAttribute("name", keyEntry.getName());
                    String keyPassword = keyEntry.getKeyPassword();
                    if (keyPassword != null) {
                        this.xmlStreamWriter.writeAttribute("keyPassword", keyPassword);
                    }
                    this.xmlStreamWriter.writeEndElement();
                }
                this.indent(1);
                this.xmlStreamWriter.writeEndElement();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ServerConfigurationWriter.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.ServerConfigurationWriter");
    }
}

