/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppInfoFactory;
import com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationHandler;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.vendor=IBM", "type=spring"})
public class SpringBootHandler
implements ApplicationHandler<DeployedAppInfo> {
    private static final TraceComponent tc = Tr.register(SpringBootHandler.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootHandler");
    @Reference(target="(type=spring)")
    private DeployedAppInfoFactory deployedAppFactory;
    @Reference
    private FutureMonitor futureMonitor;
    private final AtomicReference<String> applicationActivated = new AtomicReference();
    static final long serialVersionUID = -7088793165734036036L;

    @Activate
    protected void activate(BundleContext context) {
        FrameworkWiring fwkWiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        Collection configs = fwkWiring.findProviders(new Requirement(){
            static final long serialVersionUID = 6826670597673992208L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "liberty.springboot.config";
            }

            public Map<String, String> getDirectives() {
                return Collections.emptyMap();
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootHandler$1");
            }
        });
        configs.forEach(c -> {
            try {
                c.getRevision().getBundle().uninstall();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        });
    }

    public Future<Boolean> install(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        final SpringBootApplicationImpl springBootApplication = (SpringBootApplicationImpl)applicationInformation.getHandlerInfo();
        if (springBootApplication == null) {
            IllegalStateException ise = new IllegalStateException("No SpringBootApplication found.");
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)ise);
        }
        if (springBootApplication.getError() != null) {
            return this.futureMonitor.createFutureWithResult(Boolean.class, springBootApplication.getError());
        }
        Future result = this.futureMonitor.createFuture(Boolean.class);
        String current = this.applicationActivated.getAndUpdate(s -> {
            if (s == null) {
                return applicationInformation.getName();
            }
            return s;
        });
        if (current != null) {
            IllegalStateException error = new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"error.multiple.applications.not.allowed", (Object[])new Object[]{applicationInformation.getName(), current}));
            return this.futureMonitor.createFutureWithResult(Boolean.class, (Throwable)error);
        }
        springBootApplication.setApplicationActivated(this.applicationActivated);
        this.futureMonitor.onCompletion(result, (CompletionListener)new CompletionListener<Boolean>(){
            static final long serialVersionUID = 4086236915268888801L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void successfulCompletion(Future<Boolean> future, Boolean result) {
                if (!result.booleanValue()) {
                    springBootApplication.uninstallApp();
                }
            }

            public void failedCompletion(Future<Boolean> future, Throwable t) {
                CountDownLatch readyLatch = springBootApplication.getApplicationReadyLatch();
                readyLatch.countDown();
                readyLatch.countDown();
                springBootApplication.uninstallApp();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootHandler$2");
            }
        });
        if (!springBootApplication.deployApp(result)) {
            this.futureMonitor.setResult(result, (Object)false);
        }
        return result;
    }

    public Future<Boolean> uninstall(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        SpringBootApplicationImpl deployedApp = (SpringBootApplicationImpl)applicationInformation.getHandlerInfo();
        if (deployedApp == null) {
            return this.futureMonitor.createFutureWithResult((Object)false);
        }
        boolean success = deployedApp.uninstallApp();
        return this.futureMonitor.createFutureWithResult((Object)success);
    }

    /*
     * WARNING - void declaration
     */
    public ApplicationMonitoringInformation setUpApplicationMonitoring(ApplicationInformation<DeployedAppInfo> applicationInformation) {
        Container originalContainer = applicationInformation.getContainer();
        try {
            applicationInformation.setHandlerInfo((Object)this.deployedAppFactory.createDeployedAppInfo(applicationInformation));
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootHandler", (String)"164", (Object)this, (Object[])new Object[]{applicationInformation});
            throw new IllegalStateException((Throwable)e);
        }
        SpringBootApplicationImpl springBootApplication = (SpringBootApplicationImpl)applicationInformation.getHandlerInfo();
        if (springBootApplication.getError() != null) {
            return null;
        }
        DefaultNotification bootInfNotification = new DefaultNotification(applicationInformation.getContainer(), springBootApplication.getSpringBootManifest().getSpringBootLib());
        DefaultNotification metaInfNotification = new DefaultNotification(applicationInformation.getContainer(), "/META-INF");
        HashSet<DefaultNotification> notifications = new HashSet<DefaultNotification>();
        notifications.add(bootInfNotification);
        notifications.add(metaInfNotification);
        if (originalContainer != applicationInformation.getContainer()) {
            DefaultNotification oldBoot = new DefaultNotification(originalContainer, springBootApplication.getSpringBootManifest().getSpringBootLib());
            DefaultNotification oldMeta = new DefaultNotification(originalContainer, "/META-INF");
            notifications.add(oldBoot);
            notifications.add(oldMeta);
        }
        return new DefaultApplicationMonitoringInformation(notifications, false);
    }
}

