/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml1.core.Advice;
import org.opensaml.saml1.core.Assertion;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml1.core.Statement;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AssertionUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        Assertion assertion = (Assertion)((Object)super.unmarshall(domElement));
        if (assertion.getMinorVersion() != 0 && !DatatypeHelper.isEmpty((String)assertion.getID())) {
            domElement.setIdAttributeNS(null, "AssertionID", true);
        }
        return assertion;
    }

    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        Assertion assertion = (Assertion)((Object)parentSAMLObject);
        if (childSAMLObject instanceof Signature) {
            assertion.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof Conditions) {
            assertion.setConditions((Conditions)((Object)childSAMLObject));
        } else if (childSAMLObject instanceof Advice) {
            assertion.setAdvice((Advice)childSAMLObject);
        } else if (childSAMLObject instanceof Statement) {
            assertion.getStatements().add((Statement)((Object)childSAMLObject));
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        Assertion assertion = (Assertion)((Object)samlObject);
        if ("AssertionID".equals(attribute.getLocalName())) {
            assertion.setID(attribute.getValue());
        } else if ("Issuer".equals(attribute.getLocalName())) {
            assertion.setIssuer(attribute.getValue());
        } else if ("IssueInstant".equals(attribute.getLocalName()) && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            assertion.setIssueInstant(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if ("MinorVersion".equals(attribute.getLocalName())) {
            if (attribute.getValue().equals("0")) {
                assertion.setVersion(SAMLVersion.VERSION_10);
            } else {
                assertion.setVersion(SAMLVersion.VERSION_11);
            }
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }
}

