/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.collector;

import com.ibm.ws.logging.collector.BurstDateFormat;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.JSONObject;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import com.ibm.ws.logging.data.Pair;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class CollectorJsonHelpers {
    private static String startMessageJson = null;
    private static String startMessageJsonFields = null;
    private static String startAccessLogLogstashCollector = null;
    private static String startTraceJson = null;
    private static String startTraceJsonFields = null;
    private static String startFFDCJson = null;
    private static String startFFDCJsonFields = null;
    private static String startAccessLogJson = null;
    private static String startAccessLogJsonFields = null;
    private static String startGCJson = null;
    private static String startAuditJson = null;
    private static String startAuditJsonFields = null;
    public static String hostName = null;
    public static String wlpUserDir = null;
    public static String serverName = null;
    private static final String TYPE_FIELD_KEY = "\"type";
    private static final String TYPE_FIELD_PREPPEND = "\":\"";
    private static final String TYPE_FIELD_APPEND = "\"";
    private static final String MESSAGE_JSON_TYPE_FIELD = "\":\"liberty_message\"";
    private static final String TRACE_JSON_TYPE_FIELD = "\":\"liberty_trace\"";
    private static final String ACCESS_JSON_TYPE_FIELD = "\":\"liberty_accesslog\"";
    private static final String FFDC_JSON_TYPE_FIELD = "\":\"liberty_ffdc\"";
    private static final String GC_JSON_TYPE_FIELD = "\":\"liberty_gc\"";
    private static final String AUDIT_JSON_TYPE_FIELD = "\":\"liberty_audit\"";
    private static String unchangingFieldsJson = null;
    public static final String TRUE_BOOL = "true";
    public static final String FALSE_BOOL = "false";
    public static final String INT_SUFFIX = "_int";
    public static final String FLOAT_SUFFIX = "_float";
    public static final String BOOL_SUFFIX = "_bool";
    public static final String LONG_SUFFIX = "_long";
    public static final String LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    });
    public static final String OMIT_FIELDS_STRING = "@@@OMIT@@@";
    public static ThreadLocal<BurstDateFormat> dateFormatTL = new ThreadLocal<BurstDateFormat>(){

        @Override
        protected BurstDateFormat initialValue() {
            return new BurstDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        }
    };

    public static void setHostName(String host) {
        hostName = host;
    }

    public static void setWlpUserDir(String userDir) {
        wlpUserDir = userDir;
    }

    public static void setServerName(String server) {
        serverName = server;
    }

    protected static String getEventType(String source, String location) {
        if (source.equals("com.ibm.ws.health.center.source.gcsource") && location.equals("memory")) {
            return "liberty_gc";
        }
        if (source.equals("com.ibm.ws.logging.source.message") && location.equals("memory")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace") && location.equals("memory")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource") && location.equals("memory")) {
            return "liberty_ffdc";
        }
        if (source.endsWith("com.ibm.ws.http.logging.source.accesslog") && location.equals("memory")) {
            return "liberty_accesslog";
        }
        if (source.contains("audit")) {
            return "liberty_audit";
        }
        return "";
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField) {
        boolean b = CollectorJsonHelpers.addToJSON(sb, name, value, jsonEscapeName, jsonEscapeValue, trim, isFirstField, false);
        return b;
    }

    protected static boolean addToJSON(StringBuilder sb, String name, String value, boolean jsonEscapeName, boolean jsonEscapeValue, boolean trim, boolean isFirstField, boolean isQuoteless) {
        if (name == null || value == null) {
            return false;
        }
        if (name.equals(OMIT_FIELDS_STRING)) {
            return false;
        }
        if (!isFirstField) {
            sb.append(",");
        }
        if (trim) {
            value = value.trim();
        }
        sb.append(TYPE_FIELD_APPEND);
        if (jsonEscapeName) {
            CollectorJsonHelpers.jsonEscape3(sb, name);
        } else {
            sb.append(name);
        }
        if (isQuoteless) {
            sb.append("\":");
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
        } else {
            sb.append(TYPE_FIELD_PREPPEND);
            if (jsonEscapeValue) {
                CollectorJsonHelpers.jsonEscape3(sb, value);
            } else {
                sb.append(value);
            }
            sb.append(TYPE_FIELD_APPEND);
        }
        return true;
    }

    protected static void jsonEscape3(StringBuilder sb, String s) {
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append("\\");
                    sb.append(c);
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static void updateFieldMappings() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField(LogTraceData.getTypeKeyJSON(true), "liberty_message", false, false).addField(LogTraceData.getHostKeyJSON(true), hostName, false, false).addField(LogTraceData.getUserDirKeyJSON(true), wlpUserDir, false, true).addField(LogTraceData.getServerNameKeyJSON(true), serverName, false, false);
        startMessageJsonFields = jsonBuilder.toString();
        jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField(AuditData.getTypeKeyJSON(), "liberty_audit", false, false).addField(AuditData.getHostKeyJSON(), hostName, false, false).addField(AuditData.getUserDirKeyJSON(), wlpUserDir, false, true).addField(AuditData.getServerNameKeyJSON(), serverName, false, false);
        startAuditJsonFields = jsonBuilder.toString();
        jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField(LogTraceData.getTypeKeyJSON(false), "liberty_trace", false, false).addField(LogTraceData.getHostKeyJSON(false), hostName, false, false).addField(LogTraceData.getUserDirKeyJSON(false), wlpUserDir, false, true).addField(LogTraceData.getServerNameKeyJSON(false), serverName, false, false);
        startTraceJsonFields = jsonBuilder.toString();
        for (int i = 0; i < 2; ++i) {
            jsonBuilder = new JSONObject.JSONObjectBuilder();
            jsonBuilder.addField(AccessLogData.getTypeKey(i), "liberty_accesslog", false, false).addField(AccessLogData.getHostKey(i), hostName, false, false).addField(AccessLogData.getUserDirKey(i), wlpUserDir, false, true).addField(AccessLogData.getServerNameKey(i), serverName, false, false);
            if (i == 0) {
                startAccessLogJsonFields = jsonBuilder.toString();
                continue;
            }
            if (i != 1) continue;
            startAccessLogLogstashCollector = jsonBuilder.toString();
        }
        jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addField(FFDCData.getTypeKeyJSON(), "liberty_ffdc", false, false).addField(FFDCData.getHostKeyJSON(), hostName, false, false).addField(FFDCData.getUserDirKeyJSON(), wlpUserDir, false, true).addField(FFDCData.getServerNameKeyJSON(), serverName, false, false);
        startFFDCJsonFields = jsonBuilder.toString();
    }

    private static void addUnchangingFields(StringBuilder sb, String hostName, String wlpUserDir, String serverName) {
        if (unchangingFieldsJson == null) {
            StringBuilder temp = new StringBuilder(512);
            CollectorJsonHelpers.addToJSON(temp, "hostName", hostName, false, false, false, false);
            CollectorJsonHelpers.addToJSON(temp, "wlpUserDir", wlpUserDir, false, true, false, false);
            CollectorJsonHelpers.addToJSON(temp, "serverName", serverName, false, false, false, false);
            unchangingFieldsJson = temp.toString();
        }
        sb.append(unchangingFieldsJson);
    }

    protected static StringBuilder startMessageJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startMessageJson != null) {
            sb.append(startMessageJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(MESSAGE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startMessageJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startTraceJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startTraceJson != null) {
            sb.append(startTraceJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(TRACE_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startTraceJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startFFDCJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startFFDCJson != null) {
            sb.append(startFFDCJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(FFDC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startFFDCJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAccessLogJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startAccessLogJson != null) {
            sb.append(startAccessLogJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(ACCESS_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startAccessLogJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startGCJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(512);
        if (startGCJson != null) {
            sb.append(startGCJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(GC_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startGCJson = sb.toString();
        }
        return sb;
    }

    protected static StringBuilder startAuditJson(String hostName, String wlpUserDir, String serverName) {
        StringBuilder sb = new StringBuilder(2048);
        if (startAuditJson != null) {
            sb.append(startAuditJson);
        } else {
            sb.append("{");
            sb.append(TYPE_FIELD_KEY);
            sb.append(AUDIT_JSON_TYPE_FIELD);
            CollectorJsonHelpers.addUnchangingFields(sb, hostName, wlpUserDir, serverName);
            startAuditJson = sb.toString();
        }
        return sb;
    }

    protected static JSONObject.JSONObjectBuilder startAuditJsonFields() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addPreformatted(startAuditJsonFields);
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startMessageJsonFields() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addPreformatted(startMessageJsonFields);
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startTraceJsonFields() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addPreformatted(startTraceJsonFields);
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startFFDCJsonFields() {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        jsonBuilder.addPreformatted(startFFDCJsonFields);
        return jsonBuilder;
    }

    protected static JSONObject.JSONObjectBuilder startAccessLogJsonFields(int format) {
        JSONObject.JSONObjectBuilder jsonBuilder = new JSONObject.JSONObjectBuilder();
        if (format == 0) {
            jsonBuilder.addPreformatted(startAccessLogJsonFields);
        } else if (format == 1) {
            jsonBuilder.addPreformatted(startAccessLogLogstashCollector);
        }
        return jsonBuilder;
    }

    protected static String formatMessage(String message, int maxLength) {
        return message.length() > maxLength && maxLength > 0 ? message.substring(0, maxLength) + "..." : message;
    }

    protected static String removeIBMTag(String s) {
        s = s.replace("ibm_", "");
        return s;
    }

    protected static StringBuilder addTagNameForVersion(StringBuilder sb) {
        sb.append(",\"tags\":");
        return sb;
    }

    protected static String jsonifyTags(String[] tags) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
            if (tags[i].contains(" ") || tags[i].contains("-")) continue;
            sb.append(TYPE_FIELD_APPEND);
            CollectorJsonHelpers.jsonEscape3(sb, tags[i]);
            sb.append(TYPE_FIELD_APPEND);
            if (i == tags.length - 1) continue;
            sb.append(",");
        }
        if (sb.toString().lastIndexOf(",") == sb.toString().length() - 1) {
            sb.delete(sb.toString().lastIndexOf(","), sb.toString().lastIndexOf(",") + 1);
        }
        sb.append("]");
        return sb.toString();
    }

    protected static String jsonRemoveSpace(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append(c);
                isLine = true;
                continue;
            }
            if (c == ' ' && isLine) continue;
            if (isLine && c != ' ') {
                isLine = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected static String getLogLevel(ArrayList<Pair> pairs) {
        KeyValuePair kvp = null;
        String loglevel = null;
        for (Pair p : pairs) {
            if (!(p instanceof KeyValuePair) || !(kvp = (KeyValuePair)((Object)p)).getKey().equals("loglevel")) continue;
            loglevel = kvp.getStringValue();
            break;
        }
        return loglevel;
    }

    public static void handleExtensions(KeyValuePairList extensions, String extKey, String extValue) {
        extKey = "ext_" + extKey;
        if (extKey.indexOf(95, 4) != -1) {
            if (extKey.endsWith(INT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Integer.parseInt(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(FLOAT_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Float.parseFloat(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (extKey.endsWith(BOOL_SUFFIX)) {
                if (extValue.toLowerCase().trim().equals(TRUE_BOOL)) {
                    extensions.addKeyValuePair(extKey, true);
                } else if (extValue.toLowerCase().trim().equals(FALSE_BOOL)) {
                    extensions.addKeyValuePair(extKey, false);
                }
            } else if (extKey.endsWith(LONG_SUFFIX)) {
                try {
                    extensions.addKeyValuePair(extKey, Long.parseLong(extValue));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                extensions.addKeyValuePair(extKey, extValue);
            }
        } else {
            extensions.addKeyValuePair(extKey, extValue);
        }
    }
}

