/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthUtils {
    public static final TraceComponent tc = Tr.register(AuthUtils.class, null, null);
    static final long serialVersionUID = 1588146005449590966L;

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req) {
        return this.getBearerTokenFromHeader(req, "Authorization");
    }

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req, String ... headersToCheck) {
        if (headersToCheck == null) {
            return null;
        }
        for (String headerName : headersToCheck) {
            String hdrValue = req.getHeader(headerName);
            if (!this.isAuthorizationHeader(headerName)) {
                return hdrValue;
            }
            String bearerAuthzMethod = "Bearer ";
            if (hdrValue == null || !hdrValue.startsWith(bearerAuthzMethod)) continue;
            return hdrValue.substring(bearerAuthzMethod.length());
        }
        return null;
    }

    private boolean isAuthorizationHeader(String headerName) {
        return "Authorization".equals(headerName);
    }
}

