/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.auth.KerberosService;
import com.ibm.ws.security.spnego.ErrorPageConfig;
import com.ibm.ws.security.spnego.SpnegoConfig;
import com.ibm.ws.security.spnego.internal.Krb5DefaultFile;
import com.ibm.ws.security.spnego.internal.SpnGssCredential;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import java.net.InetAddress;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ietf.jgss.GSSCredential;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpnegoConfigImpl
implements SpnegoConfig {
    private static final TraceComponent tc = Tr.register(SpnegoConfigImpl.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    public static final String KEY_ID = "id";
    public static final String KEY_AUTH_FILTER_REF = "authFilterRef";
    public static final String KEY_HOST_NAME = "hostName";
    public static final String KEY_ALLOW_LOCAL_HOST = "allowLocalHost";
    public static final String KEY_CANONICAL_HOST_NAME = "canonicalHostName";
    public static final String KEY_KRB5_CONFIG = "krb5Config";
    public static final String KEY_KRB5_KEYTAB = "krb5Keytab";
    public static final String KEY_KERBEROR_REALM_NAME = "kerberosRealmName";
    public static final String KEY_SERVICE_PRINCIPAL_NAMES = "servicePrincipalNames";
    public static final String KEY_SKIP_FOR_UNPROTECTED_URI = "skipForUnprotectedURI";
    public static final String KEY_DISABLE_FAIL_OVER_TO_APP_AUTH_TYPE = "disableFailOverToAppAuthType";
    public static final String KEY_INVOKE_AFTER_SSO = "invokeAfterSSO";
    public static final String KEY_SPNEGO_NOT_SUPPORTED_ERROR_PAGE_URL = "spnegoNotSupportedErrorPageURL";
    public static final String KEY_NTLM_TOKEN_RECEIVED_ERROR_PAGE_URL = "ntlmTokenReceivedErrorPageURL";
    public static final String KEY_TRIM_KERBEROS_REALM_NAME_FROM_PRINCIPAL = "trimKerberosRealmNameFromPrincipal";
    public static final String KEY_INCLUDE_CLIENT_GSS_CREDENTIAL_IN_SUBJECT = "includeClientGSSCredentialInSubject";
    public static final String KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT = "includeCustomCacheKeyInSubject";
    public static final String KEY_DISABLE_LTPA_COOKIE = "disableLtpaCookie";
    public static final String LOCAL_HOST = "localhost";
    public static final String HTTP_LOCAL_HOST = "HTTP/localhost";
    public static final String[] localhost = new String[]{"localhost"};
    static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    private WsLocationAdmin locationAdmin = null;
    private final KerberosService kerbSvc;
    private String id;
    private String authFilterRef;
    private boolean allowLocalHost;
    private String hostName;
    private boolean canonicalHostName;
    private String krb5Config;
    private String krb5Keytab;
    private String kerberosRealmName;
    private List<String> servicePrincipalNames;
    private boolean skipForUnprotectedURI;
    private boolean disableFailOverToAppAuthType;
    private boolean invokeAfterSSO;
    private String spnegoNotSupportedErrorPageURL;
    private String ntlmTokenReceivedErrorPageURL;
    private boolean includeCustomCacheKeyInSubject;
    private boolean trimKerberosRealmNameFromPrincipal;
    private boolean includeClientGSSCredentialInSubject;
    private ErrorPageConfig errorPageConfig = null;
    private final SpnGssCredential spnGssCredential = new SpnGssCredential();
    private Krb5DefaultFile krb5DefaultFile = null;
    private boolean disableLtpaCookie;
    static final long serialVersionUID = -5169850451560835924L;

    public SpnegoConfigImpl(WsLocationAdmin locationAdmin, KerberosService kerberosService, Map<String, Object> props) {
        this.locationAdmin = locationAdmin;
        this.kerbSvc = kerberosService;
        this.krb5DefaultFile = new Krb5DefaultFile(locationAdmin);
        this.processConfig(props);
        this.initSpnGssCrendential();
    }

    protected boolean initSpnGssCrendential() {
        boolean result = true;
        this.errorPageConfig = new ErrorPageConfig(this.spnegoNotSupportedErrorPageURL, this.ntlmTokenReceivedErrorPageURL);
        if (this.krb5Keytab == null || this.krb5Keytab.length() == 0) {
            result = false;
        } else {
            this.spnGssCredential.init(this.servicePrincipalNames, this);
            if (this.spnGssCredential.isEmpty()) {
                result = false;
            }
        }
        return result;
    }

    protected void processConfig(Map<String, Object> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.id = (String)props.get(KEY_ID);
        this.authFilterRef = (String)props.get(KEY_AUTH_FILTER_REF);
        this.hostName = (String)props.get(KEY_HOST_NAME);
        this.allowLocalHost = (Boolean)props.get(KEY_ALLOW_LOCAL_HOST);
        this.canonicalHostName = (Boolean)props.get(KEY_CANONICAL_HOST_NAME);
        this.krb5Config = this.processKrb5Config(props);
        this.krb5Keytab = this.processKrb5Keytab(props);
        String spns = (String)props.get(KEY_SERVICE_PRINCIPAL_NAMES);
        this.skipForUnprotectedURI = (Boolean)props.get(KEY_SKIP_FOR_UNPROTECTED_URI);
        this.disableFailOverToAppAuthType = (Boolean)props.get(KEY_DISABLE_FAIL_OVER_TO_APP_AUTH_TYPE);
        this.invokeAfterSSO = (Boolean)props.get(KEY_INVOKE_AFTER_SSO);
        this.spnegoNotSupportedErrorPageURL = (String)props.get(KEY_SPNEGO_NOT_SUPPORTED_ERROR_PAGE_URL);
        this.ntlmTokenReceivedErrorPageURL = (String)props.get(KEY_NTLM_TOKEN_RECEIVED_ERROR_PAGE_URL);
        this.trimKerberosRealmNameFromPrincipal = (Boolean)props.get(KEY_TRIM_KERBEROS_REALM_NAME_FROM_PRINCIPAL);
        this.includeClientGSSCredentialInSubject = (Boolean)props.get(KEY_INCLUDE_CLIENT_GSS_CREDENTIAL_IN_SUBJECT);
        this.servicePrincipalNames = this.resolveServicePrincipalNames((String)props.get(KEY_SERVICE_PRINCIPAL_NAMES));
        this.includeCustomCacheKeyInSubject = (Boolean)props.get(KEY_INCLUDE_CUSTOM_CACHE_KEY_IN_SUBJECT);
        this.disableLtpaCookie = (Boolean)props.get(KEY_DISABLE_LTPA_COOKIE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("id: " + this.id), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef: " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("hostName: " + this.hostName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("allowLocalHost: " + this.allowLocalHost), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("canonicalHostName: " + this.canonicalHostName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("krb5Config: " + this.krb5Config), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("krb5Keytab: " + this.krb5Keytab), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("kerberosRealmName: " + this.kerberosRealmName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("spns: " + spns), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("skipForUnprotectedURI: " + this.skipForUnprotectedURI), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("disableFailOverToAppAuthType: " + this.disableFailOverToAppAuthType), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("invokeAfterSSO: " + this.invokeAfterSSO), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("spnegoNotSupportedErrorPageURL: " + this.spnegoNotSupportedErrorPageURL), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ntlmTokenReceivedErrorPageURL: " + this.ntlmTokenReceivedErrorPageURL), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("trimKerberosRealmNameFromPrincipal: " + this.trimKerberosRealmNameFromPrincipal), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeClientGSSCredentialInSubject: " + this.includeClientGSSCredentialInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("includeCustomCacheKeyInSubject: " + this.includeCustomCacheKeyInSubject), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("disableLtpaCookie: " + this.disableLtpaCookie), (Object[])new Object[0]);
        }
    }

    protected String processKrb5Keytab(Map<String, Object> props) {
        String spnegoKeytab = (String)props.get(KEY_KRB5_KEYTAB);
        Path kerberosKeytab = this.kerbSvc.getKeytab();
        if (kerberosKeytab != null) {
            if (spnegoKeytab == null) {
                spnegoKeytab = kerberosKeytab.toAbsolutePath().toString();
            } else if (!kerberosKeytab.toAbsolutePath().toString().equals(spnegoKeytab)) {
                Tr.error((TraceComponent)tc, (String)"SPNEGO_CONFLICTING_SETTINGS_CWWKS4323E", (Object[])new Object[]{"keytab", "<kerberos>", KEY_KRB5_KEYTAB, "<spnego>"});
                return null;
            }
        }
        if (spnegoKeytab != null) {
            WsResource kt = this.locationAdmin.resolveResource(spnegoKeytab);
            if (kt == null || !kt.exists()) {
                Tr.error((TraceComponent)tc, (String)"SPNEGO_KRB5_KEYTAB_FILE_NOT_FOUND", (Object[])new Object[]{spnegoKeytab});
                return null;
            }
            return spnegoKeytab;
        }
        return this.krb5DefaultFile.getDefaultKrb5KeytabFile();
    }

    protected String processKrb5Config(Map<String, Object> props) {
        String spnegoConfigFile = (String)props.get(KEY_KRB5_CONFIG);
        Path kerberosConfigFile = this.kerbSvc.getConfigFile();
        if (kerberosConfigFile != null) {
            if (spnegoConfigFile == null) {
                spnegoConfigFile = kerberosConfigFile.toAbsolutePath().toString();
            } else if (!kerberosConfigFile.toAbsolutePath().toString().equals(spnegoConfigFile)) {
                Tr.error((TraceComponent)tc, (String)"SPNEGO_CONFLICTING_SETTINGS_CWWKS4323E", (Object[])new Object[]{"configFile", "<kerberos>", KEY_KRB5_CONFIG, "<spnego>"});
                return null;
            }
        }
        if (spnegoConfigFile != null) {
            WsResource kcf = this.locationAdmin.resolveResource(spnegoConfigFile);
            if (kcf == null || !kcf.exists()) {
                Tr.error((TraceComponent)tc, (String)"SPNEGO_KRB5_CONFIG_FILE_NOT_FOUND", (Object[])new Object[]{spnegoConfigFile});
                return null;
            }
            return spnegoConfigFile;
        }
        return this.krb5DefaultFile.getDefaultKrb5ConfigFile();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean getAllowLocalHost() {
        return this.allowLocalHost;
    }

    @Override
    public boolean isCanonicalHostName() {
        return this.canonicalHostName;
    }

    @Override
    public String getKrb5Config() {
        return this.krb5Config;
    }

    @Override
    public String getKrb5Keytab() {
        return this.krb5Keytab;
    }

    @Override
    public boolean getSkipForUnprotectedURI() {
        return this.skipForUnprotectedURI;
    }

    @Override
    public boolean getDisableFailOverToAppAuthType() {
        return this.disableFailOverToAppAuthType;
    }

    @Override
    public boolean isInvokeAfterSSO() {
        return this.invokeAfterSSO;
    }

    @Override
    public String getSpnegoNotSupportedErrorPageURL() {
        return this.spnegoNotSupportedErrorPageURL;
    }

    @Override
    public String getNtlmTokenReceivedErrorPageURL() {
        return this.ntlmTokenReceivedErrorPageURL;
    }

    @Override
    public boolean isTrimKerberosRealmNameFromPrincipal() {
        return this.trimKerberosRealmNameFromPrincipal;
    }

    @Override
    public boolean isIncludeClientGSSCredentialInSubject() {
        return this.includeClientGSSCredentialInSubject;
    }

    @Override
    public boolean isIncludeCustomCacheKeyInSubject() {
        return this.includeCustomCacheKeyInSubject;
    }

    @Override
    public ErrorPageConfig getErrorPageConfig() {
        return this.errorPageConfig;
    }

    @Override
    public GSSCredential getSpnGSSCredential(String hostName) {
        return this.spnGssCredential.getSpnGSSCredential(hostName);
    }

    @Override
    public boolean isSpnGssCredentialEmpty() {
        return this.spnGssCredential.isEmpty();
    }

    public List<String> resolveServicePrincipalNames(String servicePrincipalNames) {
        ArrayList<String> spns = new ArrayList<String>();
        if (servicePrincipalNames == null || servicePrincipalNames.length() == 0) {
            String lh;
            if (this.allowLocalHost) {
                spns.add(HTTP_LOCAL_HOST);
            }
            if ((lh = this.getHostName()) != null) {
                spns.add("HTTP/" + lh);
            }
            Tr.info((TraceComponent)tc, (String)"SPNEGO_DEFAULT_SPNS", (Object[])new Object[]{((Object)spns).toString()});
        } else {
            String[] valuesArray = servicePrincipalNames.split(",");
            for (int i = 0; i < valuesArray.length; ++i) {
                String spn = valuesArray[i].trim();
                if (!spn.startsWith("HTTP/")) {
                    spn = "HTTP/" + spn;
                }
                spns.add(spn);
            }
        }
        return spns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getHostName() {
        String host;
        block2: {
            host = null;
            try {
                host = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                    static final long serialVersionUID = 7047802552377136765L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() throws Exception {
                        if (SpnegoConfigImpl.this.canonicalHostName) {
                            return InetAddress.getLocalHost().getCanonicalHostName();
                        }
                        return InetAddress.getLocalHost().getHostName();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.spnego.internal.SpnegoConfigImpl$1", 1.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
                    }
                });
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.spnego.internal.SpnegoConfigImpl", (String)"386", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Un-expected exception: ", (Object[])new Object[]{e});
            }
        }
        return host;
    }

    @Override
    public boolean isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }
}

