/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.attachment.HeaderSizeExceededException;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class AttachmentDeserializer {
    public static final String ATTACHMENT_PART_HEADERS = AttachmentDeserializer.class.getName() + ".headers";
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final String ATTACHMENT_MAX_SIZE = "attachment-max-size";
    public static final String ATTACHMENT_MAX_COUNT = "attachment-max-count";
    public static final String ATTACHMENT_MAX_HEADER_SIZE = "attachment-max-header-size";
    public static final int DEFAULT_MAX_HEADER_SIZE = SystemPropertyAction.getInteger("org.apache.cxf.attachment-max-header-size", 300);
    public static final int THRESHOLD = 102400;
    private static final Pattern CONTENT_TYPE_BOUNDARY_PATTERN = Pattern.compile("boundary=\"?([^\";]*)");
    private static final Pattern INPUT_STREAM_BOUNDARY_PATTERN = Pattern.compile("^--(\\S*)$", 8);
    private static final Logger LOG = LogUtils.getL7dLogger(AttachmentDeserializer.class);
    private static final int PUSHBACK_AMOUNT = 2048;
    private boolean lazyLoading;
    private PushbackInputStream stream;
    private int createCount;
    private int closedCount;
    private boolean closed;
    private byte[] boundary;
    private String contentType;
    private LazyAttachmentCollection attachments;
    private Message message;
    private InputStream body;
    private Set<DelegatingInputStream> loaded;
    private List<String> supportedTypes;
    private int maxHeaderLength;
    static final long serialVersionUID = -6634844927293031851L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AttachmentDeserializer(Message message) {
        this(message, Collections.singletonList("multipart/related"));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "<init>", new Object[]{message});
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AttachmentDeserializer(Message message, List<String> supportedTypes) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "<init>", new Object[]{message, supportedTypes});
        }
        this.lazyLoading = true;
        this.loaded = new HashSet<DelegatingInputStream>();
        this.maxHeaderLength = DEFAULT_MAX_HEADER_SIZE;
        this.message = message;
        this.supportedTypes = supportedTypes;
        this.maxHeaderLength = MessageUtils.getContextualInteger(message, ATTACHMENT_MAX_HEADER_SIZE, DEFAULT_MAX_HEADER_SIZE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void initializeAttachments() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "initializeAttachments", new Object[0]);
        }
        this.initializeRootMessage();
        Object maxCountProperty = this.message.getContextualProperty(ATTACHMENT_MAX_COUNT);
        int maxCount = 50;
        if (maxCountProperty != null) {
            maxCount = maxCountProperty instanceof Integer ? (Integer)maxCountProperty : Integer.parseInt((String)maxCountProperty);
        }
        this.attachments = new LazyAttachmentCollection(this, maxCount);
        this.message.setAttachments(this.attachments);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "initializeAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void initializeRootMessage() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "initializeRootMessage", new Object[0]);
        }
        this.contentType = ((MessageImpl)this.message).getContentType();
        if (this.contentType == null) {
            throw new IllegalStateException("Content-Type can not be empty!");
        }
        if (this.message.getContent(InputStream.class) == null) {
            throw new IllegalStateException("An InputStream must be provided!");
        }
        if (AttachmentUtil.isTypeSupported(this.contentType.toLowerCase(), this.supportedTypes)) {
            MimeBodyPartInputStream mmps;
            InputStream ins;
            String cs;
            String boundaryString = this.findBoundaryFromContentType(this.contentType);
            if (null == boundaryString) {
                boundaryString = this.findBoundaryFromInputStream();
            }
            if (null == boundaryString) {
                throw new IOException("Couldn't determine the boundary from the message!");
            }
            this.boundary = boundaryString.getBytes("utf-8");
            this.stream = new PushbackInputStream(this.message.getContent(InputStream.class), 2048);
            if (!AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary)) {
                throw new IOException("Couldn't find MIME boundary: " + boundaryString);
            }
            Map<String, List<String>> ih = this.loadPartHeaders(this.stream);
            this.message.put(ATTACHMENT_PART_HEADERS, ih);
            String val = AttachmentUtil.getHeader(ih, "Content-Type", "; ");
            if (!StringUtils.isEmpty(val) && !StringUtils.isEmpty(cs = HttpHeaderHelper.findCharset(val))) {
                ((MessageImpl)this.message).setEncoding(HttpHeaderHelper.mapCharset(cs));
            }
            if ((ins = AttachmentUtil.decode(mmps = new MimeBodyPartInputStream(this.stream, this.boundary, 2048), val = AttachmentUtil.getHeader(ih, "Content-Transfer-Encoding"))) != mmps) {
                ih.remove("Content-Transfer-Encoding");
            }
            this.body = new DelegatingInputStream(ins, this);
            ++this.createCount;
            this.message.setContent(InputStream.class, this.body);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "initializeRootMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String findBoundaryFromContentType(String ct) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "findBoundaryFromContentType", new Object[]{ct});
        }
        Matcher m = CONTENT_TYPE_BOUNDARY_PATTERN.matcher(ct);
        String string = m.find() ? "--" + m.group(1) : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "findBoundaryFromContentType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String findBoundaryFromInputStream() throws IOException {
        int i;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "findBoundaryFromInputStream", new Object[0]);
        }
        InputStream is = this.message.getContent(InputStream.class);
        PushbackInputStream in = new PushbackInputStream(is, 4096);
        byte[] buf = new byte[2048];
        int len = i = in.read(buf);
        while (i > 0 && len < buf.length) {
            i = in.read(buf, len, buf.length - len);
            if (i <= 0) continue;
            len += i;
        }
        String msg = IOUtils.newStringFromBytes(buf, 0, len);
        in.unread(buf, 0, len);
        this.message.setContent(InputStream.class, in);
        Matcher m = INPUT_STREAM_BOUNDARY_PATTERN.matcher(msg);
        String string = m.find() ? "--" + m.group(1) : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "findBoundaryFromInputStream", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AttachmentImpl readNext() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "readNext", new Object[0]);
        }
        this.cacheStreamedAttachments();
        if (this.closed) {
            AttachmentImpl attachmentImpl = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                attachmentImpl = attachmentImpl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readNext", attachmentImpl);
            }
            return attachmentImpl;
        }
        int v = this.stream.read();
        if (v == -1) {
            AttachmentImpl attachmentImpl = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                attachmentImpl = attachmentImpl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readNext", attachmentImpl);
            }
            return attachmentImpl;
        }
        this.stream.unread(v);
        Map<String, List<String>> headers = this.loadPartHeaders(this.stream);
        AttachmentImpl attachmentImpl = (AttachmentImpl)this.createAttachment(headers);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attachmentImpl = attachmentImpl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readNext", attachmentImpl);
        }
        return attachmentImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cacheStreamedAttachments() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "cacheStreamedAttachments", new Object[0]);
        }
        if (this.body instanceof DelegatingInputStream && !((DelegatingInputStream)this.body).isClosed()) {
            this.cache((DelegatingInputStream)this.body);
        }
        ArrayList<Attachment> atts = new ArrayList<Attachment>(this.attachments.getLoadedAttachments());
        for (Attachment a : atts) {
            DataSource s = a.getDataHandler().getDataSource();
            if (s instanceof AttachmentDataSource) {
                AttachmentDataSource ads = (AttachmentDataSource)s;
                if (ads.isCached()) continue;
                ads.cache(this.message);
                continue;
            }
            if (!(s.getInputStream() instanceof DelegatingInputStream)) continue;
            this.cache((DelegatingInputStream)s.getInputStream());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "cacheStreamedAttachments");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void cache(DelegatingInputStream input) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "cache", new Object[]{input});
        }
        if (this.loaded.contains(input)) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "cache");
            }
            return;
        }
        this.loaded.add(input);
        InputStream origIn = input.getInputStream();
        CachedOutputStream out = new CachedOutputStream();
        try {
            AttachmentUtil.setStreamedAttachmentProperties(this.message, out);
            IOUtils.copy(input, out);
            input.setInputStream(out.getInputStream());
            origIn.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.attachment.AttachmentDeserializer", (String)"264", (Object)this, (Object[])new Object[]{input});
            try {
                out.close();
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException((Throwable)throwable2, (String)"org.apache.cxf.attachment.AttachmentDeserializer", (String)"264", (Object)this, (Object[])new Object[]{input});
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.close();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "cache");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean readTillFirstBoundary(PushbackInputStream pbs, byte[] bp) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "readTillFirstBoundary", new Object[]{pbs, bp});
        }
        int value = pbs.read();
        pbs.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pbs.read();
            if ((byte)value != bp[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < bp.length && (byte)value == bp[boundaryIndex]; ++boundaryIndex) {
                value = pbs.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != bp.length) continue;
            if (value == 13) {
                pbs.read();
            }
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readTillFirstBoundary", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readTillFirstBoundary", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Attachment createAttachment(Map<String, List<String>> headers) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "createAttachment", new Object[]{headers});
        }
        DelegatingInputStream partStream = new DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary, 2048), this);
        ++this.createCount;
        Attachment attachment = AttachmentUtil.createAttachment(partStream, headers);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attachment = attachment;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "createAttachment", attachment);
        }
        return attachment;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isLazyLoading() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "isLazyLoading", new Object[0]);
        }
        boolean bl = this.lazyLoading;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "isLazyLoading", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setLazyLoading(boolean lazyLoading) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "setLazyLoading", new Object[]{lazyLoading});
        }
        this.lazyLoading = lazyLoading;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "setLazyLoading");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void markClosed(DelegatingInputStream delegatingInputStream) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "markClosed", new Object[]{delegatingInputStream});
        }
        ++this.closedCount;
        if (this.closedCount == this.createCount && !this.attachments.hasNext(false)) {
            int x = this.stream.read();
            while (x != -1) {
                x = this.stream.read();
            }
            this.stream.close();
            this.closed = true;
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "markClosed");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean hasNext() throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "hasNext", new Object[0]);
        }
        this.cacheStreamedAttachments();
        if (this.closed) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "hasNext", bl);
            }
            return bl;
        }
        int v = this.stream.read();
        if (v == -1) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "hasNext", bl);
            }
            return bl;
        }
        this.stream.unread(v);
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "hasNext", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Map<String, List<String>> loadPartHeaders(InputStream in) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "loadPartHeaders", new Object[]{in});
        }
        StringBuilder buffer = new StringBuilder(128);
        StringBuilder b = new StringBuilder(128);
        TreeMap<String, List<String>> heads = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        while (this.readLine(in, b)) {
            char c = b.charAt(0);
            if (c == ' ' || c == '\t') {
                if (buffer.length() == 0) continue;
                buffer.append("\r\n");
                buffer.append((CharSequence)b);
                continue;
            }
            if (buffer.length() > 0) {
                this.addHeaderLine(heads, buffer);
                buffer.setLength(0);
            }
            buffer.append((CharSequence)b);
        }
        if (buffer.length() > 0) {
            this.addHeaderLine(heads, buffer);
        }
        TreeMap<String, List<String>> treeMap = heads;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            treeMap = treeMap;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "loadPartHeaders", treeMap);
        }
        return treeMap;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean readLine(InputStream in, StringBuilder buffer) throws IOException {
        int c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "readLine", new Object[]{in, buffer});
        }
        if (buffer.length() != 0) {
            buffer.setLength(0);
        }
        while ((c = in.read()) != -1 && c != 10) {
            if (c == 13) continue;
            buffer.append((char)c);
            if (buffer.length() <= this.maxHeaderLength) continue;
            LOG.fine("The attachment header size has exceeded the configured parameter: " + this.maxHeaderLength);
            throw new HeaderSizeExceededException();
        }
        boolean bl = buffer.length() != 0;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "readLine", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addHeaderLine(Map<String, List<String>> heads, StringBuilder line) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.attachment.AttachmentDeserializer", "addHeaderLine", new Object[]{heads, line});
        }
        int size = line.length();
        if (size == 0) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "addHeaderLine");
            }
            return;
        }
        int separator = line.indexOf(":");
        String name = null;
        String value = "";
        if (separator == -1) {
            name = line.toString().trim();
        } else {
            char ch;
            name = line.substring(0, separator);
            ++separator;
            while (separator < size && ((ch = line.charAt(separator)) == ' ' || ch == '\t' || ch == '\r' || ch == '\n')) {
                ++separator;
            }
            value = line.substring(separator);
        }
        List<String> v = heads.get(name);
        if (v == null) {
            v = new ArrayList<String>(1);
            heads.put(name, v);
        }
        v.add(value);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.attachment.AttachmentDeserializer", "addHeaderLine");
        }
    }
}

