/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import io.smallrye.graphql.spi.ClassloadingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;

public class CollectionCreator {
    private static final Logger LOG = Logger.getLogger((String)CollectionCreator.class.getName());
    private static ClassloadingService classloadingService = ClassloadingService.load();

    public static Collection<?> newCollection(String className) {
        Class<?> type = classloadingService.loadClass(className);
        return CollectionCreator.newCollection(type);
    }

    private static Collection<?> newCollection(Class<?> type) {
        try {
            return (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LOG.debug((Object)("Cannot create no-arg instance of [" + (type == null ? "null" : type.getName()) + "]"), (Throwable)ex);
            if (Set.class.isAssignableFrom(type)) {
                return new HashSet();
            }
            return new ArrayList();
        }
    }
}

