/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.decorator;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import io.smallrye.graphql.execution.datafetcher.decorator.DataFetcherDecorator;
import io.smallrye.graphql.spi.MetricsService;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class MetricDecorator
implements DataFetcherDecorator {
    private final Map<DataFetchingEnvironment, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    private final MetricRegistry metricRegistry = MetricsService.load().getMetricRegistry(MetricRegistry.Type.VENDOR);

    @Override
    public void before(DataFetchingEnvironment dfe) {
        this.startTimes.put(dfe, System.nanoTime());
    }

    @Override
    public void after(DataFetchingEnvironment dfe) {
        Long startTime = this.startTimes.remove(dfe);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            MetricID metricID = new MetricID("mp_graphql_" + this.getName(dfe.getParentType()) + "_" + dfe.getField().getName());
            this.metricRegistry.simpleTimer(metricID.getName(), metricID.getTagsAsArray()).update(Duration.ofNanos(duration));
        }
    }

    private String getName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return ((GraphQLNamedType)graphQLType).getName();
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getName(((GraphQLList)graphQLType).getWrappedType());
        }
        return "";
    }
}

