/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.number;

import graphql.Scalars;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.scalar.number.AbstractNumberScalar;
import io.smallrye.graphql.scalar.number.Converter;
import io.smallrye.graphql.schema.model.Argument;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegerScalar
extends AbstractNumberScalar {
    public BigIntegerScalar() {
        super(Scalars.GraphQLBigInteger.getName(), new Converter(){

            @Override
            public Object fromBigDecimal(BigDecimal bigDecimal) {
                return bigDecimal.toBigIntegerExact();
            }

            @Override
            public Object fromBigInteger(BigInteger bigInteger) {
                return bigInteger;
            }

            @Override
            public Object fromNumber(Number number, Argument argument) {
                String argumentName = argument.getReference().getClassName();
                if (argumentName.equals(Classes.LONG) || argumentName.equals(Classes.LONG_PRIMATIVE)) {
                    return number.longValue();
                }
                return new BigInteger(number.toString());
            }
        }, BigInteger.class, Long.class, Long.TYPE);
    }
}

