/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.time;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;

public class DateCoercing
implements Coercing {
    private final Class[] supportedTypes;
    private final String name;

    public DateCoercing(String name, Class ... supportedTypes) {
        this.name = name;
        this.supportedTypes = supportedTypes;
    }

    private Object convertImpl(Object input) {
        for (Class supportedType : this.supportedTypes) {
            if (!supportedType.isInstance(input)) continue;
            return supportedType.cast(input);
        }
        if (input instanceof String) {
            return input;
        }
        throw new DateTimeException("" + input);
    }

    public Object serialize(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw new CoercingSerializeException("Expected type '" + this.name + "' but was '" + input.getClass().getSimpleName() + "'.", (Throwable)e);
        }
    }

    public Object parseValue(Object input) {
        try {
            return this.convertImpl(input);
        }
        catch (DateTimeException e) {
            throw new CoercingParseValueException("Expected type '" + this.name + "' but was '" + input.getClass().getSimpleName() + "'.");
        }
    }

    public Object parseLiteral(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof StringValue) {
            return ((StringValue)input).getValue();
        }
        throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + input.getClass().getSimpleName() + "'.");
    }
}

