/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.Classes;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.SchemaBuilderException;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Scalars;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ReferenceCreator {
    private static final Logger LOG = Logger.getLogger((String)ReferenceCreator.class.getName());
    private final Queue<Reference> inputReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> typeReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> enumReferenceQueue = new ArrayDeque<Reference>();
    private final Queue<Reference> interfaceReferenceQueue = new ArrayDeque<Reference>();
    private final Map<String, Reference> inputReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> typeReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> enumReferenceMap = new HashMap<String, Reference>();
    private final Map<String, Reference> interfaceReferenceMap = new HashMap<String, Reference>();

    public void clear() {
        this.inputReferenceMap.clear();
        this.typeReferenceMap.clear();
        this.enumReferenceMap.clear();
        this.interfaceReferenceMap.clear();
        this.inputReferenceQueue.clear();
        this.typeReferenceQueue.clear();
        this.enumReferenceQueue.clear();
        this.interfaceReferenceQueue.clear();
    }

    public Queue<Reference> values(ReferenceType referenceType) {
        return this.getReferenceQueue(referenceType);
    }

    public Reference createReferenceForOperationField(Type fieldType, Annotations annotationsForMethod) {
        return this.getReference(Direction.OUT, null, fieldType, annotationsForMethod);
    }

    public Reference createReferenceForOperationArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.IN, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForSourceArgument(Type argumentType, Annotations annotationsForThisArgument) {
        return this.getReference(Direction.OUT, null, argumentType, annotationsForThisArgument);
    }

    public Reference createReferenceForInterfaceField(Type methodType, Annotations annotationsForThisMethod) {
        return this.getReference(Direction.OUT, null, methodType, annotationsForThisMethod);
    }

    public Reference createReferenceForPojoField(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        return this.getReference(direction, fieldType, methodType, annotations);
    }

    public Reference createReference(Direction direction, ClassInfo classInfo) {
        ReferenceType referenceType = ReferenceCreator.getCorrectReferenceType(direction);
        if (Classes.isInterface(classInfo)) {
            Collection knownDirectImplementors = ScanningContext.getIndex().getAllKnownImplementors(classInfo.name());
            for (ClassInfo impl : knownDirectImplementors) {
                this.createReference(direction, impl);
            }
            referenceType = ReferenceType.INTERFACE;
        } else if (Classes.isEnum(classInfo)) {
            referenceType = ReferenceType.ENUM;
        }
        String className = classInfo.name().toString();
        Annotations annotationsForClass = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(referenceType, classInfo, annotationsForClass);
        Reference reference = new Reference(className, name, referenceType);
        this.putIfAbsent(className, reference, referenceType);
        return reference;
    }

    private Reference getReference(Direction direction, Type fieldType, Type methodType, Annotations annotations) {
        if (fieldType == null) {
            fieldType = methodType;
        }
        String fieldTypeName = fieldType.name().toString();
        if (annotations.containsOneOfTheseAnnotations(Annotations.ID)) {
            return Scalars.getIDScalar(fieldTypeName);
        }
        if (Scalars.isScalar(fieldTypeName)) {
            return Scalars.getScalar(fieldTypeName);
        }
        if (fieldType.kind().equals((Object)Type.Kind.ARRAY)) {
            Type typeInArray = fieldType.asArrayType().component();
            Type typeInMethodArray = methodType.asArrayType().component();
            return this.getReference(direction, typeInArray, typeInMethodArray, annotations);
        }
        if (fieldType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
            Type typeInCollection = (Type)fieldType.asParameterizedType().arguments().get(0);
            Type typeInMethodCollection = (Type)methodType.asParameterizedType().arguments().get(0);
            return this.getReference(direction, typeInCollection, typeInMethodCollection, annotations);
        }
        if (fieldType.kind().equals((Object)Type.Kind.CLASS)) {
            ClassInfo classInfo = ScanningContext.getIndex().getClassByName(fieldType.name());
            if (classInfo != null) {
                return this.createReference(direction, classInfo);
            }
            LOG.warn((Object)("Class [" + fieldType.name() + "] in not indexed in Jandex. Can not scan Object Type, defaulting to String Scalar"));
            return Scalars.getScalar(String.class.getName());
        }
        throw new SchemaBuilderException("Don't know what to do with [" + fieldType + "] of kind [" + fieldType.kind() + "]");
    }

    private void putIfAbsent(String key, Reference reference, ReferenceType referenceType) {
        Map<String, Reference> map = this.getReferenceMap(referenceType);
        Queue<Reference> queue = this.getReferenceQueue(referenceType);
        if (!map.containsKey(key)) {
            map.put(key, reference);
            queue.add(reference);
        }
    }

    private Map<String, Reference> getReferenceMap(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceMap;
            }
            case INPUT: {
                return this.inputReferenceMap;
            }
            case INTERFACE: {
                return this.interfaceReferenceMap;
            }
            case TYPE: {
                return this.typeReferenceMap;
            }
        }
        return null;
    }

    private Queue<Reference> getReferenceQueue(ReferenceType referenceType) {
        switch (referenceType) {
            case ENUM: {
                return this.enumReferenceQueue;
            }
            case INPUT: {
                return this.inputReferenceQueue;
            }
            case INTERFACE: {
                return this.interfaceReferenceQueue;
            }
            case TYPE: {
                return this.typeReferenceQueue;
            }
        }
        return null;
    }

    private static ReferenceType getCorrectReferenceType(Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            return ReferenceType.INPUT;
        }
        return ReferenceType.TYPE;
    }
}

