/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import io.smallrye.graphql.schema.SchemaBuilder;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.servlet.GraphQLConfig;
import io.smallrye.graphql.servlet.GraphQLProducer;
import io.smallrye.graphql.servlet.IndexInitializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@WebListener
public class StartupListener
implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger((String)StartupListener.class.getName());
    @Inject
    private GraphQLProducer graphQLProducer;
    @Inject
    private GraphQLConfig config;
    private final IndexInitializer indexInitializer = new IndexInitializer();

    public void contextInitialized(ServletContextEvent sce) {
        try {
            HashSet<URL> warURLs = new HashSet<URL>();
            String warClasses = sce.getServletContext().getRealPath("WEB-INF/classes");
            warURLs.add(Paths.get(warClasses, new String[0]).toUri().toURL());
            String libs = sce.getServletContext().getRealPath("WEB-INF/lib");
            List<Path> jarsInLib = this.getJarsInLib(Paths.get(libs, new String[0]));
            warURLs.addAll(this.toURLs(jarsInLib));
            IndexView index = this.indexInitializer.createIndex(warURLs);
            Schema schema = SchemaBuilder.build(index);
            this.graphQLProducer.initializeGraphQL(this.config, schema);
            sce.getServletContext().setAttribute("io.smallrye.graphql.servlet.bootstrap", (Object)this.graphQLProducer.getGraphQLSchema());
            LOG.info((Object)"SmallRye GraphQL initialized");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOG.info((Object)"SmallRye GraphQL destroyed");
    }

    private List<URL> toURLs(List<Path> paths) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path path : paths) {
            urls.add(path.toUri().toURL());
        }
        return urls;
    }

    private List<Path> getJarsInLib(Path libFolder) {
        ArrayList<Path> jars = new ArrayList<Path>();
        if (libFolder != null && Files.isDirectory(libFolder, new LinkOption[0])) {
            try {
                jars.addAll(Files.walk(libFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()));
            }
            catch (IOException ex) {
                LOG.warn((Object)("Error reading jars files in WEB-INF/lib - not scanning libs [" + ex.getMessage() + "]"));
            }
        }
        return jars;
    }
}

