/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.spi;

import java.util.ServiceLoader;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.logging.Logger;

public interface MetricsService {
    public static final Logger LOG = Logger.getLogger((String)MetricsService.class.getName());

    public static MetricsService load() {
        MetricsService metricsService;
        try {
            ServiceLoader<MetricsService> sl = ServiceLoader.load(MetricsService.class);
            metricsService = sl.iterator().next();
        }
        catch (Exception ex) {
            metricsService = new DefaultMetricsService();
        }
        LOG.debug((Object)("Using " + metricsService.getName() + " lookup service"));
        return metricsService;
    }

    public String getName();

    public MetricRegistry getMetricRegistry(MetricRegistry.Type var1);

    public static class DefaultMetricsService
    implements MetricsService {
        @Override
        public String getName() {
            return "Unsupported Metrics Service";
        }

        @Override
        public MetricRegistry getMetricRegistry(MetricRegistry.Type type) {
            throw new UnsupportedOperationException("Metrics are not supported without CDI");
        }
    }
}

