/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.failover.ReplicatableImpl;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.protocol.OutboundProcessor;
import com.ibm.ws.sip.container.proxy.RecordRouteProxy;
import com.ibm.ws.sip.container.proxy.SipProxyInfo;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.router.SipServletInvokerListener;
import com.ibm.ws.sip.container.servlets.AddressImpl;
import com.ibm.ws.sip.container.servlets.B2buaHelperImpl;
import com.ibm.ws.sip.container.servlets.IncomingDeadSipRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletRequest;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletAckRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletRequest;
import com.ibm.ws.sip.container.servlets.OutgoingSipServletResponse;
import com.ibm.ws.sip.container.servlets.ReliableResponsesProcessor;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.sessions.SessionId;
import com.ibm.ws.sip.container.sessions.SipTransactionUserTable;
import com.ibm.ws.sip.container.timer.Invite2xxRetransmitTimer;
import com.ibm.ws.sip.container.transaction.ClientTransaction;
import com.ibm.ws.sip.container.transaction.SipTransaction;
import com.ibm.ws.sip.container.transaction.TransactionTable;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TUKeyPool;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.OutboundInterface;
import com.ibm.ws.sip.container.util.SipUtil;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.SIPTransactionConstants;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.message.MessageFactory;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;

public class TransactionUserImpl
extends ReplicatableImpl {
    private static final long serialVersionUID = 6551419490828855140L;
    private static final String NO_FINAL_RESP_PREV_INVITE = "No final response to previous INVITE";
    private static final String INCORRECT_CSEQ_REASON = "Incorrect CSeq number";
    private static final String RETRY_AFTER_SECONDS = "10";
    private static final transient LogMgr c_logger = Log.get(TransactionUserImpl.class);
    private static final transient SipRouter c_router = SipContainer.getInstance().getRouter();
    private transient SipServletRequestImpl m_sipMessage;
    private String m_callId;
    private transient SipProvider m_sipProvider;
    private Address m_localParty;
    private Address m_remoteParty;
    private boolean m_isServerTransaction;
    private int m_finalResponseStatus;
    private long m_localCSeq = 1L;
    private long m_remoteCseq = -1L;
    private String m_localTag;
    private String m_remoteTag;
    private String _destinationTagInProxy;
    private boolean m_isProxying;
    private boolean _isB2B = false;
    private boolean _isUAS = false;
    private boolean _isCombinedMode;
    private boolean m_isRRProxy;
    private boolean m_isVirtualBranch = false;
    private Address m_remoteContact;
    private Vector<String> m_routeHeaders = null;
    private transient ReliableResponsesProcessor m_reliableProcessor = null;
    private int _nextSipSessionId = 1;
    public static final String SESSION_RR_PARAM_KEY = "ibmsid";
    public static final char SESSION_ID_TAG_SEPARATOR = '_';
    private transient OutgoingSipServletAckRequest m_AckFor2xxRef;
    private long m_inviteCseq;
    private transient SipServletRequest m_pendingCancelReq;
    private transient boolean m_cancelSent = false;
    private transient boolean m_forwardToApplication = true;
    private transient boolean m_wasAnsweredReliable = false;
    private transient TransactionUserWrapper _tuWrapper = null;
    private transient boolean _duringInvalidate = false;
    private transient boolean _underlyingTransactionsBeingTerminated = false;
    private Invite2xxRetransmitTimer _2xxRetransmitTimer = null;
    private transient boolean _replicateAllStates = false;
    private String _initialDialogMethod;
    private transient boolean _proxyReceivedFinalResponse = false;
    private transient SipURL _latestDestination;
    private String _relatedSessionId = null;
    private String _relatedSessionHeader = null;
    private URI _subscriberURI = null;
    private SipApplicationRoutingRegion _region = null;
    private transient LinkedList<SipServletMessage> _b2bUACPendingMessages = null;
    private transient LinkedList<SipServletMessage> _b2bUASPendingMessages = null;
    private boolean _isFailedResponseSent = false;
    private OutboundInterface _preferedOutBoundIface = new OutboundInterface();
    private OutboundInterface _originatorPreferedOutBoundIface = new OutboundInterface();
    private boolean _terminateConfirmed = false;
    private transient boolean _addedToTUTable = false;
    private String _sharedIdForDS = null;
    private transient TUKey _key;
    private transient boolean _noFinalResponseToReceivedInvite = false;
    private transient boolean _noFinalResponseToSentInvite = false;
    private transient long _pendingReceivedInviteCseq = -1L;
    private transient long _pendingSentInviteCseq = -1L;
    private transient SipServletResponseImpl _lastOkResponse;
    private HashMap<Long, Invite2xxRetransmitTimer> _retransmitTimerPerCSeq = null;
    private int _sessionInvalidatedResponse = PropertiesStore.getInstance().getProperties().getInt("session.invalidated.response.code");
    private HashMap<Long, ClientTransaction> _proxyClientTransactions = null;
    private transient boolean _proxyHasOngoingReInvite = false;

    void initialize(TransactionUserWrapper tuWrapper, SipServletRequestImpl sipMessage, boolean isServerTransaction, SipApplicationSessionImpl sipApp) {
        this.m_sipMessage = sipMessage;
        this._tuWrapper = tuWrapper;
        this._initialDialogMethod = this.m_sipMessage.getMethod();
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("TU ID = ");
            buff.append(this._tuWrapper.getId());
            buff.append(this._tuWrapper.getAppName());
            buff.append(" Initial request Method = ");
            buff.append(this._initialDialogMethod);
            c_logger.traceDebug(this, "initialize", buff.toString());
        }
        this.m_isServerTransaction = isServerTransaction;
        this._tuWrapper.logToContext(264, this.m_isServerTransaction ? "true" : "false");
        this.setParams();
        this.setSharedId(this._tuWrapper.getSharedID());
    }

    void initializeDerivedTU(TransactionUserWrapper tuWrapper, TransactionUserWrapper originalTU) {
        this.m_sipMessage = originalTU.getSipMessage();
        this._tuWrapper = tuWrapper;
        SipTransaction st = this.m_sipMessage.getTransaction();
        if (st != null) {
            st.addReferece(this._tuWrapper);
        }
        this._b2bUACPendingMessages = null;
        this._b2bUASPendingMessages = null;
        this._initialDialogMethod = this.m_sipMessage.getMethod();
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer();
            buff.append("TU ID = ");
            buff.append(this._tuWrapper.getId());
            buff.append(this._tuWrapper.getAppName());
            buff.append("Base ID = ");
            buff.append(originalTU.getId());
            buff.append(" Initial request Method = ");
            buff.append(this._initialDialogMethod);
            c_logger.traceDebug(this, "initializeDerivedTU", buff.toString());
        }
        this.m_isServerTransaction = originalTU.isServerTransaction();
        this._tuWrapper.logToContext(264, this.m_isServerTransaction ? "true" : "false");
        this.setParams();
        this.setAllVariablesFromOriginal(originalTU);
        if (this._isB2B) {
            List<SipServletMessage> pendingMessages;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initializeDerivedTU", "Initialise TU for B2B");
            }
            if ((pendingMessages = originalTU.getPendingMessages(UAMode.UAS)) != null && pendingMessages.size() != 0) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "initializeDerivedTU", this._tuWrapper.getAppName() + " Creating UAS_ based on UAS_1 when pending request in B2B list");
                }
                IncomingSipServletRequest origRequest = (IncomingSipServletRequest)originalTU.getPendingMessages(UAMode.UAS).get(0);
                IncomingDeadSipRequest origRequestForThisTU = new IncomingDeadSipRequest(origRequest, this._tuWrapper);
                this.m_sipMessage = origRequestForThisTU;
                this.addB2BPendingMsg(origRequestForThisTU, UAMode.UAS);
            } else if (this.isServerTransaction()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "initializeDerivedTU", this._tuWrapper.getAppName() + " No Pending messages use initial m_sipMessage ");
                }
                if (this.m_sipMessage != null) {
                    IncomingDeadSipRequest origRequestForThisTU = new IncomingDeadSipRequest((IncomingSipServletRequest)this.m_sipMessage, this._tuWrapper);
                    this.addB2BPendingMsg(origRequestForThisTU, UAMode.UAS);
                }
            }
        }
    }

    private void setParams() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "setParams", params);
        }
        if (this.m_isServerTransaction) {
            this.m_localParty = this.m_sipMessage.getTo();
            this.m_remoteParty = this.m_sipMessage.getFrom();
            this.m_remoteTag = this.m_sipMessage.getRequest().getFromHeader().getTag();
        } else {
            this.m_localParty = this.m_sipMessage.getFrom();
            this.m_remoteParty = this.m_sipMessage.getTo();
        }
        this.m_callId = this.m_sipMessage.getCallIdHeader().getCallId();
        this.m_sipProvider = this.m_sipMessage.getSipProvider();
        if (this.m_isServerTransaction) {
            SipURI uri = SipProxyInfo.getInstance().extractReceivedOnInterface(this.m_sipMessage);
            if (uri != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("Extracted Received On Interface: ");
                    buff.append("host = " + uri.getHost());
                    buff.append(" port = " + uri.getPort());
                    c_logger.traceDebug(this, "setParams", buff.toString());
                }
                InetSocketAddress address = InetAddressCache.getInetSocketAddress(uri.getHost(), uri.getPort());
                this.setOutboundInterface(address);
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setParams", "ERROR: no received on interface was found!!!");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setParams: tu = " + this.hashCode(), null);
            c_logger.traceDebug(this, "setParams: _preferedOutBoundIfaceIdx = " + this._preferedOutBoundIface, null);
        }
        this._sessionInvalidatedResponse = PropertiesStore.getInstance().getProperties().getInt("session.invalidated.response.code");
    }

    private void setAllVariablesFromOriginal(TransactionUserWrapper originalTU) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "setAllVariablesFromOriginal", params);
        }
        this._isB2B = originalTU.isB2B();
        if (!this.m_isServerTransaction) {
            this.m_localTag = originalTU.getLocalTag();
        }
        this.m_isRRProxy = originalTU.isRRProxy();
        this.m_inviteCseq = originalTU.getInviteCseq();
        this.m_wasAnsweredReliable = originalTU.wasAnsweredReliable();
        this.m_remoteCseq = originalTU.getRemoteCseq();
        this.m_localCSeq = originalTU.getLocalCSeq();
        this._initialDialogMethod = this.m_sipMessage.getMethod();
        this._latestDestination = originalTU.getUsedDestination();
        this._preferedOutBoundIface = new OutboundInterface(originalTU.getPreferedOutboundIface("UDP"), originalTU.getPreferedOutboundIface("TCP"), originalTU.getPreferedOutboundIface("TLS"));
        this.m_isProxying = originalTU.isProxying();
        this.m_routeHeaders = originalTU.getRouteHeaders();
        this._sharedIdForDS = originalTU.getSharedIdForDS();
        this.m_remoteContact = originalTU.getContactHeader();
    }

    String getSharedIdForDS() {
        if (this._sharedIdForDS != null) {
            return this._sharedIdForDS;
        }
        return this._tuWrapper.getId();
    }

    void cleanTU() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "cleanTU", params);
        }
        this.m_sipMessage = null;
        this.m_callId = null;
        this.m_sipProvider = null;
        this.m_localParty = null;
        this.m_remoteParty = null;
        this.m_isServerTransaction = false;
        this.m_finalResponseStatus = -1;
        this.m_localCSeq = 1L;
        this.m_remoteCseq = -1L;
        this.m_localTag = null;
        this.m_remoteTag = null;
        this.m_isProxying = false;
        this.m_isRRProxy = false;
        this.m_isVirtualBranch = false;
        this.m_remoteContact = null;
        this.m_routeHeaders = null;
        this.m_reliableProcessor = null;
        this.m_AckFor2xxRef = null;
        this.m_inviteCseq = 0L;
        this.m_pendingCancelReq = null;
        this.m_cancelSent = false;
        this.m_forwardToApplication = true;
        this.m_wasAnsweredReliable = false;
        this._nextSipSessionId = 1;
        this._isCombinedMode = false;
        this._tuWrapper = null;
        this._duringInvalidate = false;
        this._underlyingTransactionsBeingTerminated = false;
        this._2xxRetransmitTimer = null;
        this._initialDialogMethod = null;
        this._relatedSessionId = null;
        this._relatedSessionHeader = null;
        this._latestDestination = null;
        this._isB2B = false;
        this._isUAS = false;
        if (this._b2bUACPendingMessages != null) {
            this._b2bUACPendingMessages.clear();
        }
        if (this._b2bUASPendingMessages != null) {
            this._b2bUASPendingMessages.clear();
        }
        this._isFailedResponseSent = false;
        this._addedToTUTable = false;
        this._sharedIdForDS = null;
        this._preferedOutBoundIface = new OutboundInterface();
        this._originatorPreferedOutBoundIface = new OutboundInterface();
        this._destinationTagInProxy = null;
        this._replicateAllStates = false;
        this._subscriberURI = null;
        this._region = null;
        this._terminateConfirmed = false;
        this._key = null;
        this._proxyReceivedFinalResponse = false;
        this._noFinalResponseToReceivedInvite = false;
        this._pendingReceivedInviteCseq = -1L;
        this._noFinalResponseToSentInvite = false;
        this._pendingSentInviteCseq = -1L;
        this._lastOkResponse = null;
        if (this._retransmitTimerPerCSeq != null) {
            this._retransmitTimerPerCSeq.clear();
        }
        if (this._proxyClientTransactions != null) {
            this._proxyClientTransactions.clear();
        }
        this._proxyHasOngoingReInvite = false;
        this._sessionInvalidatedResponse = PropertiesStore.getInstance().getProperties().getInt("session.invalidated.response.code");
        this.setSharedId(null);
    }

    SipSession getSipSession(boolean create) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "getSipSession", params);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipSession", "SipSession form the BaseTU will be returned");
        }
        return this._tuWrapper.getSipSessionFromBase(create);
    }

    public synchronized SipServletRequest createRequest(String method) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "createRequest", params);
        }
        if (method.equals("ACK") || method.equals("CANCEL")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createRequest", "Can not create request for ACK or CANCEL using this method");
            }
            throw new IllegalArgumentException("Can not create a " + method + " request by this method.");
        }
        if (this.isProxying()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createRequest", "Can not create request for a session in proxying mode");
            }
            throw new IllegalStateException("Can not create request while proxying request " + this);
        }
        SipSession.State state = this._tuWrapper.getState();
        if (this.isTermitedState(state) && (!method.equals("BYE") || this._terminateConfirmed)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createRequest", "Session is TERMINATED, Create Request not allowed, " + this);
            }
            throw new IllegalStateException("Session is TERMINATED: " + this);
        }
        if (!SipUtil.canSendOnDialog(method, this.getWrapper())) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Can not create Request while Session is in : ");
                b.append((Object)this._tuWrapper.getState());
                b.append(" State, Session");
                b.append(this);
                c_logger.traceDebug(this, "createRequest", b.toString());
            }
            throw new IllegalStateException("Invalid Session State: " + this);
        }
        boolean initial = this.isInitialState(state);
        OutgoingSipServletRequest req = new OutgoingSipServletRequest(this._tuWrapper, method, this.getLocalParty(), this.getRemoteParty(), initial);
        req.setIsSubsequentRequest(!initial);
        if (initial) {
            if (!this.m_isServerTransaction && this.m_sipMessage != null) {
                req.setRequestURI(this.m_sipMessage.getRequestURI());
            }
            this.m_isServerTransaction = false;
            this.m_remoteTag = null;
        } else {
            if (null != this.m_remoteContact) {
                req.setRequestURI(this.m_remoteContact.getURI());
            }
            if (null != this.m_routeHeaders) {
                Iterator<String> iter = this.m_routeHeaders.iterator();
                while (iter.hasNext()) {
                    req.addHeader("Route", iter.next(), false);
                }
            }
        }
        return req;
    }

    void setProvider(SipProvider provider) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "setProvider", "provider=" + provider);
        }
        this.m_sipProvider = provider;
    }

    public String getCallId() {
        return this.m_callId;
    }

    private synchronized void initiateReliableResponsesProcessor() {
        if (this.m_reliableProcessor == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initiateReliableResponsesProcessor", "creating a new reliableProcessor. tu=" + this);
            }
            this.m_reliableProcessor = new ReliableResponsesProcessor(this._tuWrapper);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initiateReliableResponsesProcessor", "reliableProcessor was already created before");
        }
    }

    long getNextRSegNumber() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "getNextRSegNumber");
        }
        if (this.m_reliableProcessor == null) {
            this.initiateReliableResponsesProcessor();
        }
        long result = this.m_reliableProcessor.getNextRseg();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getNextRSegNumber", new Long(result));
        }
        return result;
    }

    Address getLocalParty() {
        return this.m_localParty;
    }

    Address getRemoteParty() {
        return this.m_remoteParty;
    }

    protected void invalidateTU() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "invalidateTU", params);
        }
        this._duringInvalidate = true;
        SipServletRequestImpl originalRequest = this.m_sipMessage;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "invalidateTU", "before");
        }
        if (this.shouldTerminateUnderlyingTransactions(originalRequest)) {
            this.terminateUnderlyingTransaction(originalRequest);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "invalidateTU", "after");
        }
        if (this.m_pendingCancelReq == null) {
            this._tuWrapper.logToContext(4097);
            if (this._2xxRetransmitTimer != null) {
                this._2xxRetransmitTimer.cancel();
            }
            this._tuWrapper.setSessionState(SipSession.State.TERMINATED, originalRequest);
            this.m_sipMessage = null;
            this._latestDestination = null;
        }
        this.removeFromStorage();
        if (PerformanceMgr.getInstance() != null) {
            PerformanceMgr.getInstance().decrementNotReplicatedSipSessionsCounter();
        }
    }

    private boolean shouldTerminateUnderlyingTransactions(SipServletRequest request) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", " has onGoingReinvite = " + this._proxyHasOngoingReInvite + " isEarlyState(_tuWrapper.getState()) = " + this.isEarlyState(this._tuWrapper.getState()) + " isInitialState(_tuWrapper.getState()) " + this.isInitialState(this._tuWrapper.getState()) + " _tuWrapper.isAfterInitial() = " + this._tuWrapper.isAfterInitial() + " _proxyReceivedFinalResponse = " + this._proxyReceivedFinalResponse + " isProxying = " + this.isProxying() + " originalRequest.isCommitted() = " + (request != null ? Boolean.valueOf(request.isCommitted()) : "request is null"));
        }
        if (request != null && request.getMethod().equals("INVITE") && !(request instanceof IncomingDeadSipRequest)) {
            if (this.isProxying()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "Proxy mode.");
                }
                if (!(request.isCommitted() || this.proxyHasFinalResponse() && !this._proxyHasOngoingReInvite)) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "We have no final response for proxy or request is not commited.");
                    }
                    return true;
                }
            } else if (this.isServerTransaction()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "UAS mode.");
                }
                if (!request.isCommitted()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "We have to close the incoming INVITE transaction");
                    }
                    return true;
                }
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "UAC mode.");
                }
                if (this.isEarlyState(this._tuWrapper.getState())) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "shouldTerminateUnderlyingTransactions", "We have no final response for outgoing INVITE request");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean proxyHasFinalResponse() {
        int lastProxyBranchResponseStatus = this._tuWrapper.getLastProxyResponseStatus();
        return lastProxyBranchResponseStatus > 199;
    }

    private void terminateUnderlyingTransaction(SipServletRequest invite) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "terminateUnderlyingTransaction", (Object)invite);
        }
        if (!this._tuWrapper.hasOngoingTransactions()) {
            return;
        }
        this._underlyingTransactionsBeingTerminated = true;
        try {
            SipTransaction transaction = ((SipServletMessageImpl)((Object)invite)).getTransaction();
            if (transaction != null && transaction.isTerminated()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "terminateUnderlyingTransaction", "TU [" + this.toString() + "]: The transaction was already terminated. Possibly due to adownstream forking creating a derived session");
                }
                return;
            }
            if (this.isProxying()) {
                this.terminateUnderlyingProxyTransactions(invite);
            } else if (this.m_isServerTransaction) {
                this.terminateUndelyingServerTransactions(invite);
            } else {
                this.terminateUndelyingClientTransactions(invite);
            }
        }
        finally {
            this._underlyingTransactionsBeingTerminated = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "terminateUnderlyingTransaction");
            }
        }
    }

    private void terminateUndelyingClientTransactions(SipServletRequest invite) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "terminateUndelyingClientTransactions", "TU [" + this.toString() + "] terminating stale INVITE client transaction");
        }
        if (!this.m_cancelSent && this.m_pendingCancelReq == null) {
            if (((SipServletRequestImpl)invite).getTransaction() != null) {
                this.m_pendingCancelReq = invite.createCancel();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "terminateUndelyingClientTransactions", "This TU has no outgoing transaction. Request was not sent.");
            }
        }
        if (this.m_pendingCancelReq != null && this.m_finalResponseStatus > 1) {
            this.sendPendingCancelRequest();
        }
    }

    private void terminateUndelyingServerTransactions(SipServletRequest invite) {
        block3: {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "terminateUndelyingServerTransactions", "TU [" + this.toString() + "] terminating stale INVITE server transaction");
            }
            SipServletResponse message = invite.createResponse(this._sessionInvalidatedResponse);
            try {
                message.send();
            }
            catch (IOException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block3;
                c_logger.traceDebug(this, "terminateUndelyingServerTransactions", "failed sending message to terminate the call", e2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void terminateUnderlyingProxyTransactions(SipServletRequest invite) {
        block15: {
            Iterator<ClientTransaction> iterator;
            block18: {
                block17: {
                    block14: {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceEntry(this, "terminateUnderlyingProxyTransactions");
                        }
                        IncomingSipServletRequest originalInvite = (IncomingSipServletRequest)invite;
                        OutgoingSipServletResponse response = (OutgoingSipServletResponse)originalInvite.createResponse(408);
                        response.markAsProxyResponse();
                        try {
                            response.send();
                        }
                        catch (IOException e1) {
                            if (!c_logger.isTraceDebugEnabled()) break block14;
                            c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "Send response - IllegalStateException... " + e1.toString());
                        }
                    }
                    if (!this._proxyReceivedFinalResponse) break block17;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "This INVITE was already answered with a final response. Remove Client Transaction ");
                    }
                    if (this._proxyClientTransactions == null || this._proxyClientTransactions.size() <= 0) break block15;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "Remove open INVITE client transaction in Proxy");
                    }
                    iterator = this._proxyClientTransactions.values().iterator();
                    break block18;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "This INVITE was not completed yet, cancel the Proxy.");
                }
                try {
                    invite.getProxy().cancel();
                }
                catch (IllegalStateException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "IllegalStateException... " + e2.toString());
                    }
                    break block15;
                }
                catch (TooManyHopsException e3) {
                    if (!c_logger.isTraceDebugEnabled()) break block15;
                    c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "TooManyHopsException... " + e3.toString());
                }
                break block15;
            }
            while (iterator.hasNext()) {
                ClientTransaction transaction;
                block16: {
                    transaction = iterator.next();
                    try {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "Send CANCEL for transaction = " + transaction);
                        }
                        OutgoingSipServletRequest cancel = (OutgoingSipServletRequest)transaction.getOriginalRequest().createCancel();
                        cancel.send(transaction.getListener());
                    }
                    catch (IOException e4) {
                        if (!c_logger.isTraceDebugEnabled()) break block16;
                        c_logger.traceDebug(this, "terminateUnderlyingProxyTransactions", "IllegalStateException... " + e4.toString());
                    }
                }
                TransactionTable.getInstance().removeTransaction(transaction);
            }
        }
        c_logger.traceExit(this, "terminateUnderlyingProxyTransactions");
    }

    public boolean isPendingCancelExists() {
        return this.m_pendingCancelReq != null;
    }

    public boolean isInvalidating() {
        return this._duringInvalidate;
    }

    public boolean isUnderlyingTransactionsBeingTerminated() {
        return this._underlyingTransactionsBeingTerminated;
    }

    SipProvider getSipProvider() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSipProvider", "provider=" + this.m_sipProvider);
        }
        return this.m_sipProvider;
    }

    Address getContactHeader() {
        return this.m_remoteContact;
    }

    String getRemoteTag() {
        return this.m_remoteTag;
    }

    void setDestinationTagInProxy(String tag, boolean replaceExistingTU) {
        this._destinationTagInProxy = tag;
        if (this._destinationTagInProxy == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setDestinationTagInProxy", "set empty string");
            }
            this._destinationTagInProxy = "";
        }
        if (this._addedToTUTable && replaceExistingTU) {
            SessionRepository.getInstance().removeTuWrapper(this._key, false);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setDestinationTagInProxy", "Removed  key = " + this._key.toString() + " sessionId = " + this._tuWrapper.getId());
            }
            TUKeyPool.finishToUseKey(this._key);
            this._key = null;
            this._addedToTUTable = false;
            this.addToSessionsTable();
        }
    }

    private void addToSessionsTable() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "addToSessionsTable", params);
        }
        if (this._addedToTUTable) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addToSessionsTable", "This TU was already added to the table and Should be replaces.  Id = " + this._tuWrapper.getId());
            }
            return;
        }
        this._addedToTUTable = true;
        TUKey key = null;
        key = this._key != null ? this._key : new TUKey();
        if (this.isProxying()) {
            if (this.m_isVirtualBranch) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addToSessionsTable", " Adding as VirtualBranch");
                }
                key.setup(this._destinationTagInProxy, this.m_remoteTag, this.getCallId(), false);
            } else {
                key.setup(this.m_remoteTag, this._destinationTagInProxy, this.getSharedIdForDS(), true);
            }
        } else {
            key.setup(this.m_localTag, this.m_remoteTag, this.getCallId(), false);
        }
        this._key = key;
        SessionRepository.getInstance().put(key, this._tuWrapper, true);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addToSessionsTable", " key = " + key.toString() + " sessionId = " + this._tuWrapper.getId());
        }
    }

    void setRemoteTag(String tag) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), " Tag = " + tag};
            c_logger.traceEntry((Object)this, "setRemoteTag", params);
        }
        TUKey key = null;
        if (!(this._addedToTUTable || this.m_remoteTag != null && tag == null)) {
            this.m_remoteTag = tag;
            this.addToSessionsTable();
        }
        if (this._addedToTUTable && this.m_remoteTag == null && tag != null) {
            this.m_remoteTag = tag;
            if (!this.isProxying() && !this.isServerTransaction()) {
                key = ThreadLocalStorage.getTUKey();
                key.setup(this.m_localTag, null, this.getCallId(), false);
                TransactionUserWrapper tuw = SessionRepository.getInstance().removeTuWrapper(key, false);
                if (tuw == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "setRemoteTag", "Trying to update the key of a transaction user that is not found in the table, key = " + key.toString() + " sessionId = " + this._tuWrapper.getId());
                    }
                    if (c_logger.isTraceEntryExitEnabled()) {
                        c_logger.traceExit(this, "setRemoteTag");
                    }
                    return;
                }
                this._key = null;
                this._addedToTUTable = false;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "setRemoteTag", "Removed  key = " + key.toString() + " sessionId = " + this._tuWrapper.getId());
                }
                this.addToSessionsTable();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "setRemoteTag");
        }
    }

    String getDestinationTagInProxy() {
        return this._destinationTagInProxy;
    }

    String getLocalTag() {
        return this.m_localTag;
    }

    private boolean checkCSeq(SipServletRequestImpl request, boolean isAck, boolean isCancel) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), isAck, isCancel};
            c_logger.traceEntry((Object)this, "checkCSeq", params);
        }
        boolean isOk = false;
        if (isCancel) {
            isOk = this.checkCSeqACK_Cancel(request);
        } else if (isAck) {
            isOk = true;
        } else {
            long receivedRemoteCseq = request.getRequest().getCSeqHeader().getSequenceNumber();
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer();
                b.append(" Expected remote CSeq: ");
                b.append(this.m_remoteCseq);
                b.append(" Received CSeq: ");
                b.append(receivedRemoteCseq);
                c_logger.traceDebug(this, "checkCSeq", b.toString());
            }
            if (receivedRemoteCseq > this.m_remoteCseq) {
                this.m_remoteCseq = receivedRemoteCseq;
                isOk = true;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkCSeq", " Is OK: " + isOk);
            }
        }
        if (!isOk) {
            String reasonPhrase;
            int responseCode;
            if (isCancel) {
                responseCode = 481;
                reasonPhrase = null;
            } else {
                responseCode = 500;
                reasonPhrase = INCORRECT_CSEQ_REASON;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkCSeq", "lower CSeq received. return error [" + responseCode + "] latest cseq [" + this.m_remoteCseq + ']');
            }
            this.sendResponse(request, responseCode, reasonPhrase);
        }
        return isOk;
    }

    void processRequest(SipServletRequest request) {
        boolean isJSR289;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "processRequest", params);
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(request.getMethod());
            b.append(' ');
            b.append(request.getCallId());
            c_logger.traceDebug(this, "processRequest", b.toString());
        }
        if (this._tuWrapper.getSipServletDesc() == null && this.isProxying()) {
            isJSR289 = true;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "This request is for proxy without a local application");
            }
        } else {
            isJSR289 = this._tuWrapper.getSipServletDesc().getSipApp().isJSR289Application();
        }
        if (isJSR289) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequest", "checkTopRouteDestination");
            }
            boolean isIncomingRequest = true;
            ((SipServletRequestImpl)request).checkTopRouteDestination(isIncomingRequest);
        }
        this._tuWrapper.logToContext(259, request.getMethod(), (Object)request);
        SipApplicationSessionImpl appSession = this._tuWrapper.getAppSessionForInternalUse();
        if (appSession != null) {
            appSession.setLastAccessedTime();
        }
        if (!this.isProxying()) {
            this.processRequestUASMode((SipServletRequestImpl)request);
        } else {
            String toTag;
            if (this.isCombinedMode() && (toTag = ((SipServletRequestImpl)request).getRequest().getToHeader().getTag()) != null && toTag.equals(this.m_localTag)) {
                this.processRequestUASMode((SipServletRequestImpl)request);
                return;
            }
            if (request.getMethod().equals("CANCEL")) {
                this.cancelProxyOperation(request);
            } else if (request.getMethod().equals("ACK") && !SipUtil.is2xxResponse(this.m_finalResponseStatus)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processRequest", "ACK dropped, finalResponse = " + this.m_finalResponseStatus + " proxy final Response: " + this._proxyReceivedFinalResponse);
                }
            } else {
                this.processSubsequentProxyRequest(request);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processRequest");
        }
    }

    private boolean checkPrackRequest(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "checkPrackRequest", params);
        }
        int error = 400;
        boolean isPrackOk = false;
        if (this.m_wasAnsweredReliable && this.m_reliableProcessor != null && (error = this.m_reliableProcessor.isLegalPrack(request)) == 200) {
            isPrackOk = true;
        }
        if (!isPrackOk) {
            SipRouter.sendErrorResponse(request, error);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "checkPrackRequest", new Boolean(isPrackOk));
        }
        return isPrackOk;
    }

    private boolean checkReferRequest(SipServletRequestImpl request) {
        boolean isReferOk = false;
        ListIterator iter = request.getHeaders("Refer-To");
        if (iter.hasNext()) {
            iter.next();
            if (!iter.hasNext()) {
                isReferOk = true;
            }
        }
        if (!isReferOk) {
            SipRouter.sendErrorResponse(request, 400);
        }
        return isReferOk;
    }

    private void handleUASRequest(SipServletRequestImpl request, boolean isAck, boolean isCancel, boolean isInvite) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "handleUASRequest", params);
        }
        OutboundProcessor outboundProcessor = OutboundProcessor.instance();
        outboundProcessor.processRequest(request);
        if (SipUtil.isTargetRefreshRequest(request.getMethod())) {
            this.saveContactHeader(request);
        }
        boolean isAckOnErrorResponse = ((IncomingSipServletRequest)request).isAckOnErrorResponse();
        boolean isFirstACKForThis2xx = false;
        if (isAck) {
            long receivedCSeq = request.getRequest().getCSeqHeader().getSequenceNumber();
            if (this._retransmitTimerPerCSeq != null && this._retransmitTimerPerCSeq.containsKey(receivedCSeq)) {
                Invite2xxRetransmitTimer retransmitTimer = this._retransmitTimerPerCSeq.remove(receivedCSeq);
                retransmitTimer.cancel();
                isFirstACKForThis2xx = true;
            }
            if (this._2xxRetransmitTimer != null) {
                this._2xxRetransmitTimer.cancel();
                this._2xxRetransmitTimer = null;
                isFirstACKForThis2xx = true;
            }
            this.m_sipMessage = null;
            this._latestDestination = null;
        }
        if (isAckOnErrorResponse || isAck && !isFirstACKForThis2xx) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequestUASMode", "Not passing request to application, isAck:" + isAck + " , isOnErrorResponse: " + isAckOnErrorResponse + ", isFirstACKForThis2xx: " + isFirstACKForThis2xx);
            }
        } else {
            c_router.invokeSipServlet(request, null, this._tuWrapper.getSipServletDesc(), null);
        }
        if (isInvite) {
            this.m_sipMessage = request;
        }
    }

    private void processRequestUASMode(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "processRequestUASMode", params);
        }
        boolean isAck = request.getMethod().equals("ACK");
        boolean isCancel = false;
        boolean isInvite = false;
        boolean forwardToApplication = true;
        if (!isAck && !(isCancel = request.getMethod().equals("CANCEL"))) {
            isInvite = request.getMethod().equals("INVITE");
        }
        if (isInvite) {
            if (this._noFinalResponseToSentInvite) {
                SipRouter.sendErrorResponse(request, 491, NO_FINAL_RESP_PREV_INVITE);
                return;
            }
            this.m_inviteCseq = request.getRequest().getCSeqHeader().getSequenceNumber();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processRequestUASMode", "Updated local Invite CSeq: " + this.m_inviteCseq);
            }
        }
        if (this.checkCSeq(request, isAck, isCancel)) {
            if (isInvite) {
                if (this._noFinalResponseToReceivedInvite) {
                    SipRouter.sendErrorResponse(request, 500, NO_FINAL_RESP_PREV_INVITE);
                    return;
                }
                this._noFinalResponseToReceivedInvite = true;
                this._pendingReceivedInviteCseq = this.m_inviteCseq;
            }
            if (isCancel) {
                boolean isCanceled = this.cancelOriginalRequest(request);
                if (!PropertiesStore.getInstance().getProperties().getBoolean("forwardBadCancelToApp")) {
                    forwardToApplication = isCanceled;
                }
            } else if (request.getMethod().equals("REFER")) {
                forwardToApplication = this.checkReferRequest(request);
            } else if (request.getMethod().equals("PRACK")) {
                forwardToApplication = this.checkPrackRequest(request);
            }
            if (forwardToApplication) {
                PerformanceMgr perfMgr = PerformanceMgr.getInstance();
                if (perfMgr != null && !PropertiesStore.getInstance().getProperties().getBoolean("pmiCountAllMessages")) {
                    perfMgr.updatePmiInRequest(request.getMethod(), this._tuWrapper, null);
                }
                this.handleUASRequest(request, isAck, isCancel, isInvite);
            }
        }
    }

    void cleanReliableObject() {
        if (this.m_reliableProcessor != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "cleanReliableObject", "removing reliableProcessor");
            }
            this.m_reliableProcessor = null;
        }
    }

    private boolean checkCSeqACK_Cancel(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "checkCSeqACK_Cancel", params);
        }
        boolean rc = false;
        long receivedCSeq = request.getRequest().getCSeqHeader().getSequenceNumber();
        if (this.m_inviteCseq == receivedCSeq) {
            rc = true;
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer();
            b.append(" Expected CSeq (INVITE):  ");
            b.append(this.m_inviteCseq);
            b.append(" Received CSeq: ");
            b.append(receivedCSeq);
            b.append(" Is OK: ");
            b.append(rc);
            c_logger.traceDebug(this, "checkCSeqACK_Cancel", b.toString());
        }
        return rc;
    }

    private void saveContactHeader(SipServletMessage msg) {
        block5: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, "saveContactHeader", params);
            }
            Address contact = null;
            try {
                contact = msg.getAddressHeader("Contact");
                if (null != contact) {
                    this.m_remoteContact = contact;
                }
            }
            catch (ServletParseException e2) {
                if (!c_logger.isErrorEnabled()) break block5;
                c_logger.error("error.exception", "Create", null, (Throwable)((Object)e2));
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processRequest", "Saved Contact: " + this.m_remoteContact);
        }
    }

    private void cancelProxyOperation(SipServletRequest request) {
        block11: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, "cancelProxyOperation", params);
            }
            try {
                StatefullProxy p = (StatefullProxy)this.m_sipMessage.getProxy(false);
                this.sendResponse(request, 200, null);
                boolean cancelProxy = true;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Custom Property - clean.client.transaction.proxy is set - working according to it");
                }
                if (this._proxyHasOngoingReInvite) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("This is reINVITE. Cannot be canceled.");
                    }
                    cancelProxy = false;
                }
                if (cancelProxy) {
                    ArrayList<String> reasons = new ArrayList<String>();
                    ListIterator headerIter = request.getHeaders("Reason");
                    while (headerIter.hasNext()) {
                        reasons.add(headerIter.next().toString());
                    }
                    p.cancel(reasons.toArray(new String[reasons.size()]));
                }
                if (this._tuWrapper.getSipServletDesc() != null) {
                    c_router.invokeSipServlet(request, null, this._tuWrapper.getSipServletDesc(), null);
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "cancelProxyOperation", "This request is for proxy without a local application");
                }
            }
            catch (TooManyHopsException e2) {
                if (!c_logger.isErrorEnabled()) break block11;
                c_logger.error("error.exception", "Create", null, (Throwable)((Object)e2));
            }
        }
    }

    private void sendResponse(SipServletRequest request, int responseCode, String responseCodePhrase) {
        block5: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " sendResponse", params);
            }
            if (request.getMethod().equals("ACK")) {
                return;
            }
            SipServletResponse resp = null;
            try {
                resp = responseCodePhrase == null ? request.createResponse(responseCode) : request.createResponse(responseCode, responseCodePhrase);
                if (responseCodePhrase != null && responseCodePhrase.equals(NO_FINAL_RESP_PREV_INVITE)) {
                    resp.addHeader("Retry-After", RETRY_AFTER_SECONDS);
                }
                resp.send();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block5;
                Object[] args = new Object[]{resp};
                c_logger.error("error.sending.response", "Request", args, (Throwable)e2);
            }
        }
    }

    boolean isProxying() {
        return this.m_isProxying;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelOriginalRequest(SipServletRequest request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " cancelOriginalRequest", params);
        }
        SipTransaction transaction = this.m_sipMessage.getTransaction();
        boolean cancelAccepted = true;
        SipTransaction sipTransaction = transaction;
        synchronized (sipTransaction) {
            if (!transaction.isTerminated()) {
                SipServletRequestImpl originalMsg;
                block13: {
                    originalMsg = this.m_sipMessage;
                    SipServletResponse response487 = null;
                    try {
                        response487 = originalMsg.createResponse(487);
                    }
                    catch (IllegalStateException e2) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "cancelOriginalRequest", "Exception thrown " + e2 + "Is intial INVITE confirmed " + originalMsg.isCommitted());
                        }
                        this.sendResponse(request, 481, null);
                    }
                    if (response487 != null) {
                        this.sendResponse(request, 200, null);
                        try {
                            response487.send();
                        }
                        catch (IOException e3) {
                            if (!c_logger.isErrorEnabled()) break block13;
                            Object[] args = new Object[]{this.m_sipMessage};
                            c_logger.error("error.sending.487.response", "Request", args, (Throwable)e3);
                        }
                    }
                }
                originalMsg.getTransaction().markAsTerminated();
            } else {
                cancelAccepted = false;
                this.sendResponse(request, 481, null);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "cancelOriginalRequest", cancelAccepted);
        }
        return cancelAccepted;
    }

    void sendResponseToApplication(SipServletResponse response, SipServletInvokerListener listener) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] args = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getReasonPhrase(), Integer.toString(response.getStatus()), response.getCallId()};
            c_logger.traceEntry((Object)this, this._tuWrapper.getAppName() + "sendResponseToApplication", args);
        }
        if (this._duringInvalidate) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "sendResponseToApplication", "This response will be not forwarded to the Application as it already invalidated");
            }
        } else {
            c_router.invokeSipServlet(null, response, this._tuWrapper.getSipServletDesc(), listener);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "sendResponseToApplication");
        }
    }

    void processSubsequentProxyRequest(SipServletRequest request) {
        InetSocketAddress address;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), request.getMethod()};
            c_logger.traceEntry((Object)this, "processSubsequentProxyRequest", params);
        }
        c_router.invokeSipServlet(request, null, this._tuWrapper.getSipServletDesc(), this._tuWrapper);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processSubsequentProxyRequest");
        }
        if (request.getMethod().equals("INVITE")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processSubsequentProxyRequest", "Set new m_sipMessage = " + this.m_sipMessage);
            }
            this.m_sipMessage = (SipServletRequestImpl)request;
            this._proxyHasOngoingReInvite = true;
        }
        String originalFromHeaderTag = this._tuWrapper.getBranch().getOriginalRequest().getFrom().getParameter("tag");
        String fromHeaderTag = request.getFrom().getParameter("tag");
        if (originalFromHeaderTag != null && originalFromHeaderTag.equals(fromHeaderTag) && (address = this.extractReceivedOnInterface(request)) != null) {
            this.setOriginatorOutboundInterface(address);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processSubsequentProxyRequest");
        }
    }

    boolean onSendingResponse(SipServletResponse response) {
        PerformanceMgr perfMgr;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getReasonPhrase(), Integer.toString(response.getStatus()), response.getCallId()};
            c_logger.traceEntry((Object)this, "onSendingResponse", params);
        }
        this._tuWrapper.logToContext(261, response.getStatus(), (Object)response);
        String method = response.getMethod();
        boolean isInvite = method.equals("INVITE");
        int status = response.getStatus();
        if (this._initialDialogMethod != null && this._initialDialogMethod.equals(response.getMethod()) && !this.is1xxResponse(status) && !SipUtil.is2xxResponse(status)) {
            this._isFailedResponseSent = true;
        }
        if (SipUtil.is2xxResponse(status)) {
            this._tuWrapper.checkIfTerminateRequest(response.getRequest());
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
            perfMgr.updatePmiOutResponse(status, this._tuWrapper);
        }
        boolean exitAfterUpdatingState = false;
        if (this.isConfirmedState(this._tuWrapper.getState())) {
            if (isInvite && !this.m_isProxying && SipUtil.is2xxResponse(status)) {
                this.setRetransmitTimerFor2xxResponse(response);
            }
            if (isInvite && status >= 200) {
                this.clearPendingInviteStatusOnFinalResponse(response);
            }
            exitAfterUpdatingState = true;
        }
        this.updateSessionState(response);
        if (exitAfterUpdatingState) {
            return true;
        }
        this.updateTags(response);
        if (SipUtil.is2xxResponse(status) || !((OutgoingSipServletResponse)response).isSendingReliably() && SipUtil.isDialogInitialRequest(method)) {
            this.addToTransactionUsersTable();
            this.saveRoutingInfo(response);
            if (isInvite && !this.m_isProxying && SipUtil.is2xxResponse(status)) {
                this.setRetransmitTimerFor2xxResponse(response);
            }
        }
        if (this.isEqualToInitalRequestMethod(response)) {
            if (this.m_finalResponseStatus < 200) {
                this.m_finalResponseStatus = status;
                this.setDirty();
            }
            if (isInvite && status >= 200) {
                this.clearPendingInviteStatusOnFinalResponse(response);
            }
        }
        if (!(status != 401 && status != 403 && status != 407 || this.wasForwardedToApplication() || SipUtil.isDialogInitialRequest(response.getMethod()))) {
            this.getWrapper().invalidateTU(true, true);
        }
        this.replicateForInitialRequest(response);
        this.checkIfTUShouldBeReused();
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] args = new Object[]{"Sip Session on sending response", response.getReasonPhrase(), Integer.toString(response.getStatus())};
            c_logger.traceExit((Object)this, "onSendingResponse", args);
        }
        return true;
    }

    private void clearPendingInviteStatusOnFinalResponse(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getReasonPhrase(), Integer.toString(response.getStatus()), response.getCallId()};
            c_logger.traceEntry((Object)this, "clearPendingInviteStatusOnFinalResponse", params);
        }
        long responseCseq = ((SipServletRequestImpl)response.getRequest()).getRequest().getCSeqHeader().getSequenceNumber();
        if (c_logger.isTraceDebugEnabled()) {
            StringBuilder sb = new StringBuilder(500);
            sb.append("Response status=").append(response.getStatus());
            sb.append(" Response cseq=").append(responseCseq);
            sb.append(" _noFinalResponseToReceivedInvite=").append(this._noFinalResponseToReceivedInvite);
            sb.append(" _pendingReceivedInviteCseq=").append(this._pendingReceivedInviteCseq);
            sb.append(" _noFinalResponseToSentInvite=").append(this._noFinalResponseToSentInvite);
            sb.append(" _pendingSentInviteCseq=").append(this._pendingSentInviteCseq);
            c_logger.traceDebug(this, "clearPendingInviteStatusOnFinalResponse", sb.toString());
        }
        if (responseCseq == this._pendingReceivedInviteCseq || responseCseq == this._pendingSentInviteCseq) {
            this._noFinalResponseToReceivedInvite = false;
            this._pendingReceivedInviteCseq = -1L;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "clearPendingInviteStatusOnFinalResponse", "clearing status");
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] args = new Object[]{"clearPendingInviteStatusOnFinalResponse", response.getReasonPhrase(), Integer.toString(response.getStatus())};
            c_logger.traceExit((Object)this, "clearPendingInviteStatusOnFinalResponse", args);
        }
    }

    private void updateTags(SipServletResponse response) {
        SipSession.State state;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " updateTags", params);
        }
        if (this.isConfirmedState(state = this._tuWrapper.getState()) || this.isTermitedState(state)) {
            return;
        }
        int respStatus = response.getStatus();
        String toTag = ((AddressImpl)response.getTo()).getTag();
        if (SipUtil.is2xxResponse(respStatus) || this.is1xxResponse(respStatus) && SipUtil.isDialogInitialRequest(response.getMethod()) && toTag != null) {
            if (this.isProxying()) {
                if (this._destinationTagInProxy == null) {
                    this._destinationTagInProxy = ((SipServletResponseImpl)response).getResponse().getToHeader().getTag();
                    if (this._destinationTagInProxy == null) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "updateTags", "Both destinationTag and To-tag are null");
                        }
                        this._destinationTagInProxy = "";
                    }
                }
            } else if (this.m_isServerTransaction) {
                this.m_localParty = response.getTo();
                if (!this.isProxying()) {
                    this.m_localTag = ((SipServletResponseImpl)response).getResponse().getToHeader().getTag();
                }
                this.setDirty();
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "onSendingResponse", "SipSession OnSending Response Error 1");
            }
        }
    }

    public boolean shouldBeReplicated(boolean forBootstrap) {
        boolean result;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "shouldBeReplicated", (Object)(this._tuWrapper.getAppName() + this._tuWrapper.getId()));
        }
        if (this._tuWrapper.getSipServletDesc() == null) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "shouldBeReplicated", "servlet desc is null");
            }
            return false;
        }
        SipAppDesc appDescriptor = this._tuWrapper.getSipServletDesc().getSipApp();
        boolean bl = result = appDescriptor != null && appDescriptor.isDistributed() && (this.isConfirmedState(this._tuWrapper.getState()) || this._replicateAllStates);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "shouldBeReplicated", " result is:" + result + " appDesc=" + appDescriptor + " dialogConfirmed?" + this.isConfirmedState(this._tuWrapper.getState()));
        }
        if (result && this._duringInvalidate) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "this TU is during invalidation ID = " + this._tuWrapper.getId());
            }
            return false;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "shouldBeReplicated", this._tuWrapper.getId() + "=" + result);
        }
        return result;
    }

    void onSendingReliableProvisionalResponse(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "onSendingReliableProvisionalResponse", (Object)response);
        }
        if (this.m_reliableProcessor == null) {
            this.initiateReliableResponsesProcessor();
        }
        this.m_reliableProcessor.sendResponse((SipServletResponseImpl)response);
        this.updateSessionWithReliableResponse(response);
        this.addToTransactionUsersTable();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "onSendingReliableProvisionalResponse");
        }
    }

    void updateSessionWithReliableResponse(SipServletResponse response) {
        if (!this.m_wasAnsweredReliable) {
            this.m_wasAnsweredReliable = true;
        }
        if (response.getStatus() >= 180 && response.getStatus() < 190) {
            boolean isInitial = this.isInitialState(this._tuWrapper.getState());
            if (response instanceof IncomingSipServletResponse) {
                this.updateTargetAndRoutingInfo(response, isInitial);
                this.setRemoteTag(((SipServletResponseImpl)response).getResponse().getToHeader().getTag());
            } else if (isInitial) {
                this.saveRoutingInfo(response);
            }
        }
    }

    void updateWithProxyReliableResponse(SipServletResponse response) {
        if (this.m_reliableProcessor == null) {
            this.initiateReliableResponsesProcessor();
        }
        this.updateSessionWithReliableResponse(response);
    }

    void onSendingFinalResponseAfterProvisional(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " onSendingFinalResponseAfterProvisional", params);
        }
        if (this.m_wasAnsweredReliable && this.m_reliableProcessor != null) {
            this.m_reliableProcessor.sendFinalResponse((SipServletResponseImpl)response);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "onSendingFinalResponseAfterProvisional", this._tuWrapper.getAppName() + "No Provisional response was sent before");
        }
    }

    private void setRetransmitTimerFor2xxResponse(SipServletResponse response) {
        if (this._2xxRetransmitTimer == null) {
            this._2xxRetransmitTimer = new Invite2xxRetransmitTimer((SipServletResponseImpl)response);
            SipContainerComponent.getTimerService().schedule(this._2xxRetransmitTimer, false, SIPTransactionConstants.T1);
        } else {
            if (this._retransmitTimerPerCSeq == null) {
                this._retransmitTimerPerCSeq = new HashMap();
                this._retransmitTimerPerCSeq.put(this._2xxRetransmitTimer.getRetransmittedResponseCSeq(), this._2xxRetransmitTimer);
                this._2xxRetransmitTimer = null;
            }
            Invite2xxRetransmitTimer retransmitTimer = new Invite2xxRetransmitTimer((SipServletResponseImpl)response);
            this._retransmitTimerPerCSeq.put(retransmitTimer.getRetransmittedResponseCSeq(), retransmitTimer);
            SipContainerComponent.getTimerService().schedule(retransmitTimer, false, SIPTransactionConstants.T1);
        }
    }

    public void storeClientTransaction(ClientTransaction transaction) {
        if (!this.isProxying() || !transaction.getOriginalRequest().getMethod().equals("INVITE")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "storeClientTransaction", "We store only INVITE transactions");
            }
            return;
        }
        if (this._proxyClientTransactions == null) {
            this._proxyClientTransactions = new HashMap();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "storeClientTransaction", "Transaction Id  = " + transaction.getTransactionID());
        }
        this._proxyClientTransactions.put(transaction.getTransactionID(), transaction);
    }

    public void removeClientTransaction(ClientTransaction transaction) {
        if (this._proxyClientTransactions != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeClientTransaction", "Transaction Id  = " + transaction.getTransactionID());
            }
            this._proxyClientTransactions.remove(transaction.getTransactionID());
        }
    }

    private void saveRoutingInfo(SipServletResponse response) {
        block8: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " saveRoutingInfo", params);
            }
            if (this.isProxying()) {
                return;
            }
            try {
                ListIterator iter = response.getAddressHeaders("Record-Route");
                if (iter.hasNext()) {
                    this.m_routeHeaders = new Vector(3);
                    while (iter.hasNext()) {
                        Object rroute = iter.next();
                        if (this.m_isServerTransaction) {
                            this.m_routeHeaders.add(rroute.toString());
                        } else {
                            this.m_routeHeaders.add(0, rroute.toString());
                        }
                        if (!c_logger.isTraceDebugEnabled()) continue;
                        c_logger.traceDebug(this, "saveRoutingInfo", "Added Route: " + rroute);
                    }
                    this.setDirty();
                }
            }
            catch (ServletParseException e2) {
                if (!c_logger.isErrorEnabled()) break block8;
                c_logger.error("error.exception", "Create", null, (Throwable)((Object)e2));
            }
        }
    }

    private void updateTargetAndRoutingInfo(SipServletResponse resp, boolean updateRoutingInfo) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "updateTargetAndRoutingInfo", params);
        }
        if (SipUtil.isTargetRefreshRequest(resp.getMethod())) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateTargetAndRoutingInfo", "Target Refresh Request");
            }
            this.saveContactHeader(resp);
            if (updateRoutingInfo) {
                this.saveRoutingInfo((SipServletResponseImpl)resp);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "updateTargetAndRoutingInfo");
        }
    }

    private final boolean is1xxResponse(int status) {
        return status >= 100 && status < 200;
    }

    SipServletMessage getSipServletRequest() {
        return this.m_sipMessage;
    }

    void addToTransactionUsersTable() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " addToTransactionUsersTable", params);
        }
        if (this.isTermitedState(this._tuWrapper.getState()) || this._duringInvalidate) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addToTransactionUsersTable", "Will not add TUimpl to Sessions table because session is already expired" + this._tuWrapper.getId());
            }
            return;
        }
        this.addToSessionsTable();
    }

    void processResponse(SipServletResponseImpl response) {
        long responseCseq;
        boolean shouldInvalidate;
        SipApplicationSessionImpl sipApp;
        PerformanceMgr perfMgr;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getStatus(), response.getMethod()};
            c_logger.traceEntry((Object)this, " processResponse", params);
        }
        boolean shouldBeForwardedToApp = true;
        if (this.isInitialState(this._tuWrapper.getState()) && SipUtil.isDialogInitialRequest(response.getMethod())) {
            SipTransactionUserTable.getInstance().removeTransactionUserForOutgoingRequest((SipServletRequestImpl)response.getRequest());
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null && !PropertiesStore.getInstance().getProperties().getBoolean("pmiCountAllMessages")) {
            perfMgr.updatePmiInResponse(response.getStatus(), this._tuWrapper);
        }
        if ((sipApp = this._tuWrapper.getAppSessionForInternalUse()) != null) {
            sipApp.setLastAccessedTime();
        }
        this._tuWrapper.logToContext(260, response.getStatus(), (Object)response);
        boolean bl = shouldInvalidate = this.m_pendingCancelReq != null && this._duringInvalidate;
        if (this.m_pendingCancelReq != null && this.is1xxResponse(response.getStatus())) {
            this.sendPendingCancelRequest();
        }
        this.m_pendingCancelReq = null;
        if (response.isReliableResponse()) {
            if (this.m_reliableProcessor == null) {
                this.initiateReliableResponsesProcessor();
            }
            this.updateSessionWithReliableResponse(response);
            shouldBeForwardedToApp = this.m_reliableProcessor.processReliableResponse(response);
        }
        if (!response.getMethod().equals("CANCEL")) {
            this.m_finalResponseStatus = response.getStatus();
            if (shouldBeForwardedToApp && response.getStatus() > 100) {
                if (this.isEqualToInitalRequestMethod(response)) {
                    this.setDirty();
                }
                if (this._initialDialogMethod != null && !SipUtil.isDialogInitialRequest(this._initialDialogMethod)) {
                    this.m_sipMessage = null;
                }
                this.sendResponseToApplication(response, null);
                this.checkIfTUShouldBeReused();
            }
        }
        if (!this.is1xxResponse(response.getStatus()) && this._latestDestination != null && this.isEqualToInitalRequestMethod(response)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("final response received, remove latest destination");
            }
            this._latestDestination = null;
        }
        if (shouldInvalidate) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processResponse", "Sent cancel on a partial invalidated sessiom, forcing invalidation.");
            }
            this._tuWrapper.invalidateTU(true, true);
        }
        if (response.getRequest().getMethod().equals("BYE")) {
            this._terminateConfirmed = true;
            this.setDirty();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "processResponse", "try to clear _noFinalResponseToSentInvite");
        }
        if (response.getRequest().getMethod().equals("INVITE") && response.getStatus() >= 200 && (responseCseq = ((SipServletRequestImpl)response.getRequest()).getRequest().getCSeqHeader().getSequenceNumber()) == this._pendingSentInviteCseq) {
            this._noFinalResponseToSentInvite = false;
            this._pendingSentInviteCseq = -1L;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processResponse", "clearing _noFinalResponseToSentInvite" + this._noFinalResponseToSentInvite);
            }
        }
        if (this.isDirty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("TransactionUSerImpl.processResponse(): replicate (status change on cancel)");
            }
            this.store();
        }
    }

    private void checkIfTUShouldBeReused() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " checkIfTUShouldBeReused", params);
        }
        if (this.isConfirmedState(this._tuWrapper.getState()) && !this._tuWrapper.isTUDialog()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "checkIfTUShouldBeReused", "This TU should be reUsed as it is not a dialog " + this);
            }
            this._tuWrapper.setShouldBeReused();
        }
    }

    void updateSession(SipServletResponse response) {
        String method;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " updateSession", params);
        }
        if ((method = response.getMethod()).equals("PRACK")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "updateSession", "The response on PRACK should not change the session state");
            }
            return;
        }
        int status = response.getStatus();
        if (!this.isConfirmedState(this._tuWrapper.getState())) {
            this.updateSessionState(response);
            String toTag = ((AddressImpl)response.getTo()).getTag();
            if (SipUtil.is2xxResponse(status) || this.is1xxResponse(status) && method.equals("INVITE") && toTag != null) {
                if (this.m_isServerTransaction) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "updateSession", "Error Processing Response for a Server Transaction");
                    }
                } else {
                    this.m_remoteParty = response.getTo();
                    this.m_localParty = response.getFrom();
                }
                if (SipUtil.is2xxResponse(status) || toTag != null) {
                    this.updateTargetAndRoutingInfo(response, true);
                    this.setRemoteTag(((SipServletResponseImpl)response).getResponse().getToHeader().getTag());
                }
            }
        } else if (SipUtil.is2xxResponse(status)) {
            this.updateTargetAndRoutingInfo(response, false);
        } else if (SipUtil.isUsageTerminatingResponse(status, response)) {
            this._tuWrapper.setSessionState(SipSession.State.TERMINATED, response);
        }
        this.setDirty();
        this.replicateForInitialRequest(response);
    }

    private void replicateForInitialRequest(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " replicateForInitialRequest", params);
        }
        if (SipUtil.isDialogInitialRequest(response.getMethod())) {
            this.store();
        }
    }

    void onTransactionCompleted() {
        if (this.isConfirmedState(this._tuWrapper.getState()) && this.m_sipMessage != null && !this.m_sipMessage.getMethod().equals("INVITE")) {
            this.m_sipMessage = null;
        }
    }

    void processTimeout(SipServletRequestImpl req) {
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " processTimeout", params);
            }
            if (this.isInitialState(this._tuWrapper.getState()) && SipUtil.isDialogInitialRequest(req.getMethod())) {
                SipTransactionUserTable.getInstance().removeTransactionUserForOutgoingRequest(req);
            }
            req.setIsCommited(true);
            this._tuWrapper.logToContext(65537, req.getCallId(), (Object)req);
            IncomingSipServletResponse response = null;
            try {
                response = SipUtil.createResponse(408, req);
                this.updateSession(response);
                this.sendResponseToApplication(response, null);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.failed.create.timeout.response", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.failed.create.timeout.response", "Create", null, (Throwable)e3);
            }
        }
    }

    void generateCompositionErrorResponse(SipServletRequestImpl req) {
        block6: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " generateCompositionErrorResponse", params);
            }
            if (this.isInitialState(this._tuWrapper.getState()) && SipUtil.isDialogInitialRequest(req.getMethod())) {
                SipTransactionUserTable.getInstance().removeTransactionUserForOutgoingRequest(req);
            }
            req.setIsCommited(true);
            this._tuWrapper.logToContext(261, req.getCallId(), (Object)req);
            Request jainReq = req.getRequest();
            MessageFactory msgFactory = StackProperties.getInstance().getMessageFactory();
            try {
                Response jainRes = msgFactory.createResponse(500, jainReq);
                IncomingSipServletResponse response = new IncomingSipServletResponse(jainRes, req.getTransactionId(), req.getSipProvider());
                response.setRequest(req);
                response.setTransactionUser(req.getTransactionUser());
                this.updateSession(response);
                this.sendResponseToApplication(response, null);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.failed.create.500.response", "Create", null, (Throwable)e2);
                }
            }
            catch (SipParseException e3) {
                if (!c_logger.isErrorEnabled()) break block6;
                c_logger.error("error.failed.create.500.response", "Create", null, (Throwable)e3);
            }
        }
    }

    boolean onSendingRequest(SipServletRequestImpl request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " onSendingRequest", params);
        }
        this._tuWrapper.logToContext(262, request.getMethod(), (Object)request);
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.updatePmiOutRequest(request.getMethod(), this._tuWrapper);
        }
        SipSessionImplementation sipSession = this._tuWrapper.getSipSessionForInternalUse();
        SipApplicationSessionImpl sipAppSession = this._tuWrapper.getAppSessionForInternalUse();
        if (sipSession != null) {
            sipSession.setLastAccessedTime();
        }
        if (sipAppSession != null) {
            sipAppSession.setLastAccessedTime();
        }
        boolean rc = true;
        if (request instanceof OutgoingSipServletAckRequest) {
            if (this.m_AckFor2xxRef != null && this.m_AckFor2xxRef != request && c_logger.isTraceDebugEnabled()) {
                String oldCSeq = this.m_AckFor2xxRef.getHeader("CSeq");
                String newCSeq = request.getHeader("CSeq");
                c_logger.traceDebug(this, "onSendingRequest", "replacing cached ACK [" + oldCSeq + "] with [" + newCSeq + "] in TU [" + this + ']');
            }
            this.m_AckFor2xxRef = (OutgoingSipServletAckRequest)request;
        } else if (request.getMethod().equals("PRACK")) {
            if (this.m_reliableProcessor == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "onSendingRequest", "Cannot send the PRACk no reliable provisional response was received");
                }
                throw new IllegalStateException("PRACK request should be sent only after the reliable response received " + this);
            }
            this.m_reliableProcessor.checkPrack(request);
        } else if (this._tuWrapper.isAfterInitial() && request.getMethod().equals("CANCEL")) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "onSendingRequest", "Pending CANCEL request till a 1xx response is received");
            }
            this.m_pendingCancelReq = request;
            rc = false;
        } else {
            this._tuWrapper.checkIfTerminateRequest(request);
        }
        if (this.isInitialState(this._tuWrapper.getState()) && rc && SipUtil.isDialogInitialRequest(request.getMethod())) {
            this._tuWrapper.setStateToAfterInitial();
            if (this._initialDialogMethod == null) {
                this._initialDialogMethod = request.getMethod();
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("TU ID = ");
                    buff.append(this._tuWrapper.getId());
                    buff.append(" Set new initial request Method = ");
                    buff.append(this._initialDialogMethod);
                    c_logger.traceDebug(this, "onSendingRequest", buff.toString());
                }
            }
            this.addToTransactionUsersTable();
        }
        if (request.getMethod().equals("INVITE") && !this.m_isProxying) {
            this._noFinalResponseToSentInvite = true;
            this._pendingSentInviteCseq = request.getRequest().getCSeqHeader().getSequenceNumber();
        }
        if (rc && request.getMethod().equals("CANCEL")) {
            this.m_cancelSent = true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, " onSendingRequest", rc);
        }
        return rc;
    }

    private void sendPendingCancelRequest() {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " sendPendingCancelRequest", params);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "sendPendingCancelRequest", "Call Id: " + this.m_pendingCancelReq.getCallId());
        }
        try {
            this.m_pendingCancelReq.send();
        }
        catch (IOException e2) {
            this.logException(e2);
        }
        this.m_pendingCancelReq = null;
    }

    private void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception", "Create", null, (Throwable)e2);
        }
    }

    private boolean isEqualToInitalRequestMethod(SipServletMessage message) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " isEqualToInitalRequestMethod", params);
        }
        boolean isEqual = false;
        if (this._initialDialogMethod != null) {
            if (message.getMethod().equals(this._initialDialogMethod)) {
                isEqual = true;
            } else if (c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(100);
                b.append("Different method in received response = ");
                b.append(message.getMethod());
                b.append(" Initial dialog method = ");
                b.append(this._initialDialogMethod);
                c_logger.traceDebug(this, "isEqualToInitalRequestMethod", b.toString());
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isEqualToInitalRequestMethod", "_initialDialogMethod is null. Is dialog ? " + this._tuWrapper.isTUDialog());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "isEqualToInitalRequestMethod", isEqual ? "true" : "false");
        }
        return isEqual;
    }

    private void updateSessionState(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " updateSessionState", params);
        }
        SipSession.State prevState = this._tuWrapper.getState();
        if (SipUtil.isDialogInitialRequest(response.getMethod())) {
            SipSession.State newState = this._tuWrapper.updateState(response);
            if (this._tuWrapper.getState() == SipSession.State.INITIAL && prevState != newState) {
                this._initialDialogMethod = null;
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append("TU ID = ");
                    buff.append(this._tuWrapper.getId());
                    buff.append(" Remove initial request Method");
                    c_logger.traceDebug(this, "updateSessionState", buff.toString());
                }
                AddressImpl newRemoteParty = (AddressImpl)((AddressImpl)this.m_remoteParty).clone(true);
                newRemoteParty.removeTag();
                this.m_remoteParty = newRemoteParty;
            }
            if (newState != prevState && c_logger.isTraceDebugEnabled()) {
                StringBuffer b = new StringBuffer(64);
                b.append("Previous State: ");
                b.append((Object)prevState);
                b.append(" ,New State: ");
                b.append((Object)((Object)newState) + " Session: " + this);
                c_logger.traceDebug(this, "updateSessionState", b.toString());
            }
        }
    }

    SessionId getDialogId() {
        SessionId sessionId = null;
        String localTag = ((AddressImpl)this.m_localParty).getTag();
        String remoteTag = ((AddressImpl)this.m_remoteParty).getTag();
        if (null == localTag) {
            localTag = "";
        }
        if (null == remoteTag) {
            remoteTag = "";
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer b = new StringBuffer(64);
            b.append("Local tag: ");
            b.append(localTag);
            b.append(" , Remote tag: ");
            b.append(remoteTag);
            c_logger.traceDebug(this, "getSessionId", b.toString());
        }
        sessionId = new SessionId(this.getCallId(), localTag, remoteTag);
        return sessionId;
    }

    boolean isServerTransaction() {
        return this.m_isServerTransaction;
    }

    long getNextCSeqNumber() {
        ++this.m_localCSeq;
        return this.m_localCSeq;
    }

    void setcSeq(long l) {
        this.m_localCSeq = l;
        this.setDirty();
        this.store();
    }

    synchronized String generateLocalTag() {
        if (null == this.m_localTag) {
            this.m_localTag = this.generateTag();
            if (this.m_isProxying) {
                this.setCombinedMode(true);
            }
        }
        return this.m_localTag;
    }

    private String generateTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Math.random());
        buffer.append('_');
        buffer.append(this._tuWrapper.getId());
        return buffer.substring(2);
    }

    void setIsProxying(boolean isProxying) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " setIsProxying", params);
        }
        if (isProxying != this.m_isProxying) {
            this._tuWrapper.logToContext(263, isProxying);
        }
        if (this.m_localTag != null && isProxying) {
            this.setCombinedMode(true);
        }
        this.m_isProxying = isProxying;
        this.store();
    }

    void setIsRRProxying(boolean isRRProxy) {
        InetSocketAddress address;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " setIsRRProxying", params);
        }
        this.m_isRRProxy = isRRProxy;
        if (this.m_isRRProxy && (this._originatorPreferedOutBoundIface == null || !this._originatorPreferedOutBoundIface.isSet()) && (address = this.extractReceivedOnInterface(this.m_sipMessage)) != null) {
            this.setOriginatorOutboundInterface(address);
        }
        this.setDirty();
        this.store();
    }

    private void setOriginatorOutboundInterface(InetSocketAddress address) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "setOriginatorOutboundInterface", params);
        }
        this._originatorPreferedOutBoundIface = this.getOutboundInterface(address);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "setOriginatorOutboundInterface: " + this._originatorPreferedOutBoundIface);
        }
    }

    private InetSocketAddress extractReceivedOnInterface(SipServletRequest sipRequest) {
        InetSocketAddress receivedIf = null;
        SipURI uri = SipProxyInfo.getInstance().extractReceivedOnInterface(sipRequest);
        if (uri != null) {
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Extracted Received On Interface: ");
                buff.append("host = " + uri.getHost());
                buff.append(" port = " + uri.getPort());
                c_logger.traceDebug(this, "extractReceivedOnInterface", buff.toString());
            }
            receivedIf = InetAddressCache.getInetSocketAddress(uri.getHost(), uri.getPort());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "extractReceivedOnInterface", "" + receivedIf);
        }
        return receivedIf;
    }

    void setIsVirtualBranch(Response response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " setIsVirtualBranch", params);
        }
        this.m_isVirtualBranch = true;
        this.setDestinationTagInProxy(response.getToHeader().getTag(), false);
    }

    public boolean isVirtualBranch() {
        return this.m_isVirtualBranch;
    }

    boolean isRRProxy() {
        return this.m_isRRProxy;
    }

    void servletInvoked(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getMethod(), response.getReasonPhrase()};
            c_logger.traceEntry((Object)this, "servletInvoked", params);
        }
        SipServletResponseImpl respImpl = (SipServletResponseImpl)response;
        this.updateTags(response);
        if (response.getMethod().equals("INVITE") && !response.getRequest().isInitial() && SipUtil.is2xxResponse(response.getStatus())) {
            this._lastOkResponse = (SipServletResponseImpl)response;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "servletInvoked", "Saving _lastOkResponse");
            }
        }
        if (respImpl.getTransactionId() == -1L) {
            SipRouter.sendResponseDirectlyToTransport(respImpl.getSipProvider(), respImpl.getResponse(), true);
        } else {
            this.sendResponseUpStream(response);
        }
    }

    void servletInvoked(SipServletRequest request) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), request.getMethod(), request.getFrom(), request.getTo()};
            c_logger.traceEntry((Object)this, "servletInvoked", params);
        }
        if (!request.isCommitted()) {
            RecordRouteProxy.proxyRequest(request, this._tuWrapper);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "servletInvoked", "Session In RR Proxy mode but application generated final response for a new request in dialog");
        }
    }

    private void sendResponseUpStream(SipServletResponse response) {
        block3: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getMethod()};
                c_logger.traceEntry((Object)this, "sendResponseUpStream", params);
            }
            try {
                response.send();
            }
            catch (IOException e2) {
                if (!c_logger.isErrorEnabled()) break block3;
                c_logger.error("error.exception", "Request", null, (Throwable)e2);
            }
        }
    }

    void processSubsequentProxyResponse(SipServletResponse response) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getMethod()};
            c_logger.traceEntry((Object)this, "processSubsequentProxyResponse", params);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "setProxyReceivprocessSubsequentProxyResponseedFinalResponse", "Response status = " + response.getStatus() + " Proxy has open reINVITE ? = " + this._proxyHasOngoingReInvite);
        }
        if (this._proxyHasOngoingReInvite && response.getStatus() > 199 && response.getMethod().equals("INVITE")) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntryExit((Object)this, "setProxyReceivprocessSubsequentProxyResponseedFinalResponse", "ReInvite transaction terminated");
            }
            this._proxyHasOngoingReInvite = false;
        }
        c_router.invokeSipServlet(null, response, this._tuWrapper.getSipServletDesc(), this._tuWrapper);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "processSubsequentProxyResponse");
        }
    }

    void processStrayResponse(Response response, SipProvider provider) {
        block4: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " processStrayResponse", params);
            }
            try {
                if (SipUtil.is2xxResponse(response.getStatusCode())) {
                    this.processStrayInvite2xx(response, provider);
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isErrorEnabled()) break block4;
                c_logger.error("error.exception", "Parse Failure", null, (Throwable)e2);
            }
        }
    }

    private void processStrayInvite2xx(Response response, SipProvider provider) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), response.getCallIdHeader().getCallId()};
            c_logger.traceEntry((Object)this, "processStrayInvite2xx", params);
        }
        if (this.isProxying()) {
            this.processProxyStrayInvite2xx(response, provider);
        } else if (this._tuWrapper.getState() == SipSession.State.CONFIRMED || this._tuWrapper.getState() == SipSession.State.TERMINATED) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processStrayInvite2xx", "This stray response is retransmission on CONFIRMED session.");
            }
            this.processUACInvite2xxRetransmission(response, provider);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processStrayInvite2xx", "This stray response received on derived non-CONFIRMED session and handled as regular 2xx response");
            }
            IncomingSipServletResponse sipResponse = new IncomingSipServletResponse(response, -1L, provider);
            sipResponse.setRequest(this.m_sipMessage);
            sipResponse.setTransactionUser(this._tuWrapper);
            this.updateSession(sipResponse);
            this.processResponse(sipResponse);
        }
    }

    private void processUACInvite2xxRetransmission(Response response, SipProvider provider) {
        block14: {
            if (c_logger.isTraceEntryExitEnabled()) {
                Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
                c_logger.traceEntry((Object)this, " processUACInvite2xxRetransmission", params);
            }
            if (this.m_AckFor2xxRef == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processUACInvite2xxRetransmission", "ACK Reference is unavailable, can not send reply to retransmission");
                }
                return;
            }
            OutgoingSipServletAckRequest ack = this.m_AckFor2xxRef;
            if (!ack.wasSent()) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processUACInvite2xxRetransmission", "ACK request not sent yet, can not send reply to retransmission");
                }
                return;
            }
            CSeqHeader ackCseqHeader = ack.getRequest().getCSeqHeader();
            if (response.getCSeqHeader() != null && ackCseqHeader != null) {
                if (ackCseqHeader.getSequenceNumber() != response.getCSeqHeader().getSequenceNumber()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "processUACInvite2xxRetransmission", "Response: " + response.getCSeqHeader().getSequenceNumber() + " CSEQ != Ack " + ackCseqHeader.getSequenceNumber() + " CSEQ");
                    }
                    return;
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processUACInvite2xxRetransmission", "Response CSeq : " + response.getCSeqHeader() + " ackCSeqHeader : " + ackCseqHeader);
            }
            Request request = ack.getRequest();
            try {
                provider.sendRequest(request);
            }
            catch (IllegalArgumentException e2) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.exception", "Create", null, (Throwable)e2);
                }
            }
            catch (SipException e3) {
                if (!c_logger.isErrorEnabled()) break block14;
                c_logger.error("error.exception", "Create", null, (Throwable)e3);
            }
        }
    }

    private void processProxyStrayInvite2xx(Response response, SipProvider provider) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, " processProxyStrayInvite2xx", params);
        }
        if (this._lastOkResponse == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processProxyStrayInvite2xx", "Got a Stray 2xx Response for Initial Invite");
            }
            if (this.m_sipMessage != null) {
                StatefullProxy p = null;
                try {
                    p = (StatefullProxy)this.m_sipMessage.getProxy(false);
                }
                catch (TooManyHopsException e2) {
                    this.logException((Exception)((Object)e2));
                }
                if (null != p) {
                    p.handleStrayInvite2xx(response, provider, this.getWrapper());
                } else if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processProxyStrayInvite2xx", "Error, Got a stray response for a proxy when no matching proxy exists");
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processProxyStrayInvite2xx", "Error, Got a stray response for a proxy when no matching message exists");
            }
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "processProxyStrayInvite2xx", "Got a Stray 2xx Response for ReInvite");
            }
            Response lastResponse = (Response)this._lastOkResponse.getMessage();
            SipRouter.sendResponseDirectlyToTransport(provider, lastResponse, false);
        }
    }

    boolean wasForwardedToApplication() {
        return this.m_forwardToApplication;
    }

    void setForwardToApplication(boolean toApplication) {
        this.m_forwardToApplication = toApplication;
    }

    @Override
    public void store() {
        if (this.isInvalidating()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "store", "replication denied, session was already invalidated");
            }
            return;
        }
        SessionRepository.getInstance().put(this._tuWrapper.getId(), this);
    }

    public TransactionUserWrapper getWrapper() {
        return this._tuWrapper;
    }

    @Override
    public void removeFromStorage() {
        SessionRepository.getInstance().removeTuImpl(this);
    }

    public boolean isCombinedMode() {
        return this._isCombinedMode;
    }

    public void setCombinedMode(boolean isCombinedMode) {
        this._isCombinedMode = isCombinedMode;
        this.setDirty();
    }

    int getNexSipSessionId() {
        return this._nextSipSessionId++;
    }

    public boolean wasAnsweredReliable() {
        return this.m_wasAnsweredReliable;
    }

    public void notifyOnActivation() {
        this.addToTransactionUsersTable();
    }

    public void setWrapper(TransactionUserWrapper wrapper) {
        this._tuWrapper = wrapper;
    }

    public String toString() {
        StringBuffer myInformation = new StringBuffer("My Id = ");
        myInformation.append(this.getSharedId());
        myInformation.append(" Wrapper = ");
        myInformation.append(this._tuWrapper.toString());
        myInformation.append(" My Info = ");
        myInformation.append(super.toString());
        return myInformation.toString();
    }

    private boolean isTermitedState(SipSession.State state) {
        return state == SipSession.State.TERMINATED;
    }

    private boolean isInitialState(SipSession.State state) {
        return state == SipSession.State.INITIAL;
    }

    private boolean isEarlyState(SipSession.State state) {
        return state == SipSession.State.EARLY;
    }

    private boolean isConfirmedState(SipSession.State state) {
        return state == SipSession.State.CONFIRMED;
    }

    public void setRelatedSessionId(String id) {
        this._relatedSessionId = id;
    }

    public String getRelatedSipSessionId() {
        return this._relatedSessionId;
    }

    public void setRelatedSessionHeader(String relatedSessionHeader) {
        this._relatedSessionHeader = relatedSessionHeader;
    }

    public String getRelatedSipSessionHeader() {
        return this._relatedSessionHeader;
    }

    public void setUsedDestination(SipURL lastUsedDestination) {
        this._latestDestination = lastUsedDestination;
    }

    public SipURL getUsedDestination() {
        return this._latestDestination;
    }

    public void setSessionInvalidatedResponse(int code) {
        this._sessionInvalidatedResponse = code;
    }

    public boolean isB2B() {
        return this._isB2B;
    }

    public boolean isUAS() {
        return this._isUAS;
    }

    public B2buaHelperImpl getB2buaHelper(boolean create, UAMode mode) throws IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), create, mode};
            c_logger.traceEntry((Object)TransactionUserImpl.class.getName(), "getB2buaHelper", params);
        }
        if (!create && !this._isB2B) {
            return null;
        }
        if (this.m_isProxying) {
            throw new IllegalStateException("the application has already retrieved a proxy");
        }
        if (!this._isB2B) {
            this._isB2B = true;
            if (this.m_sipMessage != null && !this.m_sipMessage.isCommitted()) {
                this.addB2BPendingMsg(this.m_sipMessage, mode);
            }
        }
        return B2buaHelperImpl.getInstance();
    }

    public List<SipServletMessage> getPendingMessages(UAMode mode) {
        LinkedList<SipServletMessage> pending;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), mode};
            c_logger.traceEntry((Object)TransactionUserImpl.class.getName(), "getPendingMessages", params);
        }
        if (mode == UAMode.UAC) {
            pending = this._b2bUACPendingMessages;
            if (pending == null) {
                pending = this._b2bUACPendingMessages = new LinkedList();
            }
        } else {
            pending = this._b2bUASPendingMessages;
            if (pending == null) {
                this._b2bUASPendingMessages = new LinkedList();
                pending = this._b2bUASPendingMessages;
            }
        }
        return pending;
    }

    public void removeB2BPendingMsg(SipServletMessage msg, UAMode mode) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), mode, this._isB2B, Integer.toHexString(msg.hashCode())};
            c_logger.traceEntry((Object)TransactionUserImpl.class.getName(), "removeB2BPendingMsg", params);
        }
        if (!this.isB2B()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeB2BPendingMsg", "left with no update " + !this.isB2B());
            }
            return;
        }
        LinkedList<SipServletMessage> listToWork = null;
        listToWork = mode == UAMode.UAC ? this._b2bUACPendingMessages : this._b2bUASPendingMessages;
        if (listToWork != null) {
            if (listToWork.remove(msg)) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "removeB2BPendingMsg", "removing message from list in mode " + (Object)((Object)mode) + " list.size: " + listToWork.size());
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "removeB2BPendingMsg", "msg doesn't exist in the list");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeB2BPendingMsg", "Pending List is null");
        }
    }

    public void addB2BPendingMsg(SipServletMessage msg, UAMode mode) {
        if (c_logger.isTraceEntryExitEnabled()) {
            String messageHex = "null";
            if (msg != null) {
                messageHex = Integer.toHexString(msg.hashCode());
            }
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId(), mode, this._isB2B, messageHex};
            c_logger.traceEntry((Object)TransactionUserImpl.class.getName(), "addB2BPendingMsg", params);
        }
        if (!this._isB2B) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addB2BPendingMsg", "left with no update " + !this.isB2B());
            }
            return;
        }
        if (msg == null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addB2BPendingMsg", "message is null");
            }
            return;
        }
        if (mode == UAMode.UAC) {
            if (this._b2bUACPendingMessages == null) {
                this._b2bUACPendingMessages = new LinkedList();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addB2BPendingMsg", "create new b2bUAC PendingMessages list");
                }
            }
            this._b2bUACPendingMessages.add(msg);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addB2BPendingMsg", "adding message to UAC list.size: " + this._b2bUACPendingMessages.size());
            }
        } else {
            if (this._b2bUASPendingMessages == null) {
                this._b2bUASPendingMessages = new LinkedList();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "addB2BPendingMsg", "create new b2bUAS PendingMessages list");
                }
            }
            this._b2bUASPendingMessages.add(msg);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "addB2BPendingMsg", "adding message to UAS list.size: " + this._b2bUASPendingMessages.size());
            }
        }
    }

    public boolean isFailedResponseSent() {
        return this._isFailedResponseSent;
    }

    public boolean isTerminated() {
        return this.isTermitedState(this._tuWrapper.getState());
    }

    public String getInitialDialogMethod() {
        return this._initialDialogMethod;
    }

    public void setIsB2bua(boolean mode) {
        this._isB2B = mode;
    }

    public void setB2buaMode() {
        if (!this._isB2B) {
            this._isB2B = true;
            if (this.isServerTransaction() && !this.m_sipMessage.isCommitted()) {
                this.addB2BPendingMsg(this.m_sipMessage, UAMode.UAS);
            }
        }
    }

    public void setUASMode() {
        this._isUAS = true;
    }

    public Vector<String> getRouteHeaders() {
        return this.m_routeHeaders;
    }

    public URI getSubscriberURI() {
        return this._subscriberURI;
    }

    public void setSubscriberURI(URI subscriberURI) {
        this._subscriberURI = subscriberURI;
    }

    public SipApplicationRoutingRegion getRegion() {
        return this._region;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        this._region = region;
    }

    public void setOutboundInterface(InetSocketAddress address) {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "setOutboundInterface", params);
        }
        this._preferedOutBoundIface = this.getOutboundInterface(address);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "setOutboundInterface: " + this._preferedOutBoundIface);
        }
    }

    public OutboundInterface getOutboundInterface(InetSocketAddress address) {
        int preferedOutBoundIfaceIdxTLS;
        int preferedOutBoundIfaceIdxTCP;
        OutboundInterface outboundIf = null;
        if (address == null) {
            throw new IllegalArgumentException("Invalid address = null");
        }
        boolean isSet = false;
        int preferedOutBoundIfaceIdxUDP = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
        if (preferedOutBoundIfaceIdxUDP != -1) {
            isSet = true;
        }
        if ((preferedOutBoundIfaceIdxTCP = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
            isSet = true;
        }
        if ((preferedOutBoundIfaceIdxTLS = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
            isSet = true;
        }
        if (!isSet) {
            throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
        }
        outboundIf = new OutboundInterface(preferedOutBoundIfaceIdxUDP, preferedOutBoundIfaceIdxTCP, preferedOutBoundIfaceIdxTLS);
        return outboundIf;
    }

    public void setOutboundInterface(InetAddress address) {
        int preferedOutBoundIfaceIdxTLS;
        int preferedOutBoundIfaceIdxTCP;
        int preferedOutBoundIfaceIdxUDP;
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{this._tuWrapper.getAppName(), this._tuWrapper.getId()};
            c_logger.traceEntry((Object)this, "setOutboundInterface", params);
        }
        if (address != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "setOutboundInterface", "Attempting to set outbound interface to: " + address);
            }
            boolean isSet = false;
            preferedOutBoundIfaceIdxUDP = SipProxyInfo.getInstance().getIndexOfIface(address, "udp");
            if (preferedOutBoundIfaceIdxUDP != -1) {
                isSet = true;
            }
            if ((preferedOutBoundIfaceIdxTCP = SipProxyInfo.getInstance().getIndexOfIface(address, "tcp")) != -1) {
                isSet = true;
            }
            if ((preferedOutBoundIfaceIdxTLS = SipProxyInfo.getInstance().getIndexOfIface(address, "tls")) != -1) {
                isSet = true;
            }
            if (!isSet) {
                throw new IllegalArgumentException("address:" + address + " is not listed as allowed outbound interface.");
            }
        } else {
            throw new IllegalArgumentException("Invalid address = null");
        }
        this._preferedOutBoundIface = new OutboundInterface(preferedOutBoundIfaceIdxUDP, preferedOutBoundIfaceIdxTCP, preferedOutBoundIfaceIdxTLS);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "setOutboundInterface");
        }
    }

    public int getOriginatorPreferedOutboundIface(String transport) {
        int outboundIfaceInd = -1;
        if (this._originatorPreferedOutBoundIface != null) {
            outboundIfaceInd = this._originatorPreferedOutBoundIface.getOutboundInterface(transport);
        }
        return outboundIfaceInd;
    }

    public int getPreferedOutboundIface(String transport) {
        int returnValue;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "getPreferedOutboundIface", (Object)("transport = " + transport + " tu = " + this.hashCode()));
        }
        if (SIPTransactionStack.instance().getConfiguration().getSentByHost() != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getPreferedOutboundIface", "Return OUTBOUND_INTERFACE_NOT_DEFINED since the sentByHost property is set");
            }
            returnValue = -1;
        } else {
            returnValue = this._preferedOutBoundIface.getOutboundInterface(transport);
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit((Object)this, "getPreferedOutboundIface", "transport = " + transport + " tu = " + this.hashCode());
        }
        return returnValue;
    }

    public SipServletRequestImpl getSipMessage() {
        return this.m_sipMessage;
    }

    public long getInviteCseq() {
        return this.m_inviteCseq;
    }

    public TUKey getTUkey() {
        return this._key;
    }

    public boolean isProxyReceivedFinalResponse() {
        return this._proxyReceivedFinalResponse;
    }

    public void setProxyReceivedFinalResponse(boolean receivedFinalResponse, int status) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "setProxyReceivedFinalResponse", new Object[]{receivedFinalResponse, status});
        }
        this._proxyReceivedFinalResponse = receivedFinalResponse;
        this.m_finalResponseStatus = status;
    }

    public long getLocalCSeq() {
        return this.m_localCSeq;
    }

    public long getRemoteCseq() {
        return this.m_remoteCseq;
    }
}

