/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.util;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.jain.protocol.ip.sip.address.AddressFactoryImpl;
import com.ibm.ws.jain.protocol.ip.sip.extensions.ReasonHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.GenericNameAddressHeaderImpl;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.servlets.IncomingSipServletResponse;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipServletsFactoryImpl;
import com.ibm.ws.sip.container.servlets.SipURIImpl;
import com.ibm.ws.sip.container.tu.DialogUsageKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.stack.properties.StackProperties;
import com.ibm.ws.sip.stack.transaction.util.SIPStackUtil;
import jain.protocol.ip.sip.ListeningPoint;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.NameAddressHeader;
import jain.protocol.ip.sip.header.ParametersHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.MessageFactory;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;

public class SipUtil {
    public static final String REASON_PROTOCOL_MULTIPLE = "The Reason header includes more than one of the same protocol. Please use different protocols when there are multiple Reason headers.";
    private static final LogMgr c_logger = Log.get(SipUtil.class);
    public static final String IBM_CLIENT_ADDRESS = "IBM-Client-Address";
    public static final String STRICT_ROUTING_PARAM = "ibmsr";
    public static final String REFER_HEADER_NAME = "Refer-To";
    public static final String EARLY_ONLY_TAG = "early-only";
    public static final String TO_TAG = "to-Tag";
    public static final String FROM_TAG = "from-Tag";
    public static final String CALL_ID = "call-id";
    public static final String EVENT_HEADER = "Event";
    public static final String EVENT_HEADER_ID_PARAM = "id";
    public static final String PATH_PARAM = "path";
    public static final String DESTINATION_URI = "IBM-Destination";
    public static final String SIP_SCHEME = "sip";
    public static final String SIPS_SCHEME = "sips";
    public static final String TLS_TRANSPORT = "tls";
    public static final int DEFAULT_TLS_PORT = 5061;
    public static final String SUBSCRIPTION_STATE = "Subscription-State";
    public static final String TERMINATED_STATE = "terminated";
    public static final String IBM_ROUTE_BACK_PARAM = "ibmrb";
    public static final String IBM_STATE_INFO_ATTR = "com.ibm.ws.sip.ibm.state.info";
    private static final String INTERNAL_RESPONSE_ATTR = "com.ibm.websphere.sip.container.internal.message";
    private static final String[] dialogRelatedMethods = new String[]{"INVITE", "SUBSCRIBE"};

    public static boolean isDialogInitialRequest(String method) {
        return method.equals("INVITE") || method.equals("SUBSCRIBE") || method.equals("REFER");
    }

    public static boolean shouldAddContact(int error) {
        return error > 100 && error < 400 || error == 485;
    }

    public static String getDialogRelatedMethod(String method) {
        if (method.equals("INVITE") || method.equals("UPDATE") || method.equals("PRACK") || method.equals("ACK") || method.equals("CANCEL") || method.equals("BYE") || method.equals("INFO")) {
            return "INVITE";
        }
        if (method.equals("SUBSCRIBE") || method.equals("NOTIFY") || method.equals("REFER")) {
            return "SUBSCRIBE";
        }
        return null;
    }

    public static int getDialogRelatedMethodId(String method) {
        int length = dialogRelatedMethods.length;
        for (int i = 0; i < length; ++i) {
            if (!method.equals(dialogRelatedMethods[i])) continue;
            return i;
        }
        return -1;
    }

    public static String getDialogRelatedMethod(int id) {
        return dialogRelatedMethods[id];
    }

    public static boolean shouldContainContact(String method) {
        return SipUtil.isDialogInitialRequest(method) || method.equals("NOTIFY") || method.equals("REGISTER") || method.equals("UPDATE");
    }

    public static boolean isSubsequestRequest(String method) {
        return method.equals("BYE") || method.equals("PRACK") || method.equals("UPDATE") || method.equals("NOTIFY");
    }

    public static boolean isTargetRefreshRequest(String method) {
        return method.equals("INVITE") || method.equals("UPDATE") || method.equals("SUBSCRIBE") || method.equals("NOTIFY") || method.equals("REFER");
    }

    public static boolean is2xxResponse(int status) {
        return status >= 200 && status < 300;
    }

    public static boolean isErrorResponse(int status) {
        return status >= 400 && status < 700;
    }

    public static boolean canReceiveOnDialog(String method, TransactionUserWrapper transactionUser) {
        boolean rc = false;
        if (transactionUser.getState() == SipSession.State.EARLY) {
            if (method.equals("PRACK") || method.equals("CANCEL") || method.equals("INFO")) {
                rc = true;
            } else if (method.equals("BYE")) {
                if (transactionUser.isProxying()) {
                    rc = true;
                } else if (transactionUser.isServerTransaction()) {
                    rc = true;
                }
            }
        }
        return rc;
    }

    public static boolean canSendOnDialog(String method, TransactionUserWrapper tUser) {
        boolean rc = false;
        switch (tUser.getState()) {
            case EARLY: {
                if (method.equals("PRACK") || method.equals("UPDATE") || method.equals("INFO")) {
                    rc = true;
                    break;
                }
                if (!method.equals("BYE") || tUser.isServerTransaction()) break;
                rc = true;
                break;
            }
            case INITIAL: {
                if (method.equals("SUBSCRIBE")) break;
                rc = true;
                break;
            }
            case CONFIRMED: {
                rc = true;
                break;
            }
        }
        return rc;
    }

    public static boolean isNumericIP(SipURI sipUrlToSend) {
        String host = sipUrlToSend.getHost();
        boolean isIP = false;
        isIP = host.indexOf(58) != -1 ? true : SipUtil.isNumIPV4Ip(host);
        return isIP;
    }

    private static boolean isNumIPV4Ip(String host) {
        int dotsNum = 0;
        boolean isIp = true;
        int digitsNum = 0;
        char[] hostChar = host.toCharArray();
        for (int i = 0; isIp && i < host.length() && digitsNum < 4; ++i) {
            if (hostChar[i] == '.') {
                if (dotsNum > 2 || digitsNum == 0) {
                    isIp = false;
                }
                ++dotsNum;
                digitsNum = 0;
                continue;
            }
            if (hostChar[i] < '0' || hostChar[i] > '9') {
                isIp = false;
                continue;
            }
            if (digitsNum > 2) {
                isIp = false;
                continue;
            }
            ++digitsNum;
        }
        if (dotsNum != 3) {
            isIp = false;
        }
        return isIp;
    }

    public static void setDestinationHeader(SipURL targetAddressUri, Message message) throws SipParseException {
        NameAddressHeader ibmDestination;
        String scheme = targetAddressUri.getScheme();
        if (scheme != null) {
            String transport = targetAddressUri.getTransport();
            int port = targetAddressUri.getPort();
            if (scheme.equals(SIP_SCHEME)) {
                if (transport == null) {
                    targetAddressUri.setTransport("udp");
                    transport = "udp";
                }
                if (port < 0) {
                    if (transport.equalsIgnoreCase(TLS_TRANSPORT)) {
                        targetAddressUri.setPort(5061);
                    } else {
                        targetAddressUri.setPort(5060);
                    }
                }
            } else if (scheme.equals(SIPS_SCHEME)) {
                if (transport == null || !transport.equalsIgnoreCase(TLS_TRANSPORT)) {
                    targetAddressUri.setTransport(TLS_TRANSPORT);
                }
                if (port < 0) {
                    targetAddressUri.setPort(5061);
                }
            }
        }
        if ((ibmDestination = (NameAddressHeader)message.getHeader(DESTINATION_URI, true)) == null) {
            AddressFactory addressFactory = StackProperties.getInstance().getAddressFactory();
            NameAddress address = addressFactory.createNameAddress(targetAddressUri);
            ibmDestination = new GenericNameAddressHeaderImpl(DESTINATION_URI);
            ibmDestination.setNameAddress(address);
            message.setHeader(ibmDestination, true);
        } else {
            NameAddress address = ibmDestination.getNameAddress();
            address.setAddress(targetAddressUri);
        }
    }

    public static IncomingSipServletResponse createResponse(int errorCode, SipServletRequestImpl req) throws IllegalArgumentException, SipParseException {
        Request jainReq = req.getRequest();
        MessageFactory msgFactory = StackProperties.getInstance().getMessageFactory();
        Response jainRes = msgFactory.createResponse(408, jainReq);
        if (jainRes.getToHeader().getTag() == null || jainRes.getToHeader().getTag().length() == 0) {
            jainRes.getToHeader().setTag(String.valueOf(SIPStackUtil.generateTag()));
        }
        SipProvider sipProvider = req.getSipProvider();
        ListeningPoint lp = null;
        if (sipProvider != null) {
            lp = sipProvider.getListeningPoint();
        }
        if (lp != null) {
            SIPStackUtil.addIbmClientAddressHeader(jainRes, lp);
        }
        IncomingSipServletResponse response = new IncomingSipServletResponse(jainRes, req.getTransactionId(), req.getSipProvider());
        SipUtil.setIntenalResponseFlag(response);
        response.setRequest(req);
        response.setTransactionUser(req.getTransactionUser());
        return response;
    }

    public static boolean canCreateDerivedSession(SipServletResponseImpl response) {
        return response.getMethod().equals("INVITE") || response.getMethod().equals("SUBSCRIBE");
    }

    public static String getCanonicalURI(URI uri) {
        try {
            if (uri == null) {
                return null;
            }
            if (uri instanceof SipURI) {
                return SipUtil.getCanonicalURI((SipURI)uri);
            }
            if (uri instanceof TelURL) {
                return SipUtil.getCanonicalURI((TelURL)uri);
            }
            return uri.toString();
        }
        catch (SipParseException e2) {
            return null;
        }
    }

    public static String getCanonicalURI(SipURI sipURI) throws SipParseException {
        boolean ipv6;
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        buffer.append(sipURI.getScheme());
        buffer.append(':');
        if (sipURI.getUser() != null) {
            buffer.append(Coder.decode(sipURI.getUser()));
            if (sipURI.getUserPassword() != null) {
                buffer.append(':');
                buffer.append(Coder.decode(sipURI.getUserPassword()));
            }
            buffer.append('@');
        }
        boolean bl = ipv6 = sipURI.getHost().indexOf(58) != -1;
        if (ipv6) {
            buffer.append('[');
        }
        buffer.append(sipURI.getHost());
        if (ipv6) {
            buffer.append(']');
        }
        if (sipURI.getPort() != -1) {
            buffer.append(':');
            buffer.append(sipURI.getPort());
        }
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public static String getCanonicalURI(TelURL telURL) {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        buffer.append(telURL.getScheme());
        buffer.append(':');
        if (telURL.getPhoneNumber() != null) {
            buffer.append(telURL.getPhoneNumber());
        }
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public static DialogUsageKey getDialogUsageKey(SipServletMessageImpl sipMessage) {
        String method = sipMessage.getMethod();
        if ((method = SipUtil.getDialogRelatedMethod(method)) == null) {
            return null;
        }
        String usageSecondaryKey = null;
        if (method.equals("SUBSCRIBE") || method.equals("REFER")) {
            ParametersHeader eventHeader = null;
            try {
                eventHeader = (ParametersHeader)sipMessage.getMessage().getHeader(EVENT_HEADER, true);
                if (eventHeader == null && sipMessage instanceof SipServletResponseImpl) {
                    SipServletRequestImpl req = (SipServletRequestImpl)((SipServletResponseImpl)sipMessage).getRequest();
                    eventHeader = (ParametersHeader)req.getMessage().getHeader(EVENT_HEADER, true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eventHeader != null && (usageSecondaryKey = eventHeader.getParameter(EVENT_HEADER_ID_PARAM)) == null) {
                usageSecondaryKey = eventHeader.getValue();
            }
        }
        return DialogUsageKey.instance(method, usageSecondaryKey);
    }

    public static boolean shouldTerminateAllDialogUsages(int responseCode) {
        switch (responseCode) {
            case 404: 
            case 410: 
            case 416: 
            case 482: 
            case 483: 
            case 484: 
            case 485: 
            case 502: 
            case 604: {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldTerminateAllDialogUsages(SipServletMessageImpl sipMessage) {
        if (sipMessage == null) {
            return true;
        }
        if (sipMessage instanceof SipServletResponse) {
            SipServletResponse response = (SipServletResponse)((Object)sipMessage);
            int statusCode = response.getStatus();
            return SipUtil.shouldTerminateAllDialogUsages(statusCode);
        }
        return false;
    }

    public static boolean isUsageTerminatingRequest(SipServletRequest msg) throws IllegalArgumentException {
        String stateHeader;
        if (msg.getMethod().equals("BYE")) {
            return true;
        }
        return msg.getMethod().equals("NOTIFY") && (stateHeader = msg.getHeader(SUBSCRIPTION_STATE)) != null && stateHeader.indexOf(TERMINATED_STATE) != -1;
    }

    public static boolean isUsageTerminatingResponse(int responseCode, SipServletResponse response) {
        if (SipUtil.shouldTerminateAllDialogUsages(responseCode)) {
            return true;
        }
        switch (responseCode) {
            case 405: 
            case 501: {
                return !response.getMethod().equals("INFO");
            }
            case 480: 
            case 481: {
                return true;
            }
        }
        return false;
    }

    public static SipApplicationSessionImpl getApplicationSessionAccordingToEncodedUri(SipServletRequest request) {
        URI uri;
        SipApplicationSessionImpl appSession = null;
        String appSessionId = null;
        try {
            Address route = request.getAddressHeader("Route");
            if (route != null && (uri = route.getURI()).isSipURI()) {
                appSessionId = ((SipURI)uri).getParameter("ibmappid");
            }
        }
        catch (ServletParseException servletParseException) {
            // empty catch block
        }
        if (null == appSessionId && (uri = request.getRequestURI()).isSipURI()) {
            appSessionId = ((SipURI)uri).getParameter("ibmappid");
        }
        if (null == appSessionId && (uri = request.getTo().getURI()).isSipURI()) {
            appSessionId = ((SipURI)uri).getParameter("ibmappid");
        }
        if (null != appSessionId) {
            appSession = SipApplicationSessionImpl.getAppSession(appSessionId);
        }
        return appSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKeyBaseTargetingKey(SipAppDesc appDesc, SipServletRequestImpl request) {
        String returnValue = null;
        if (!appDesc.hasApplicationKeyMethod()) {
            return null;
        }
        ContextEstablisher contextEstablisher = appDesc.getContextEstablisher();
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            contextEstablisher.establishContext();
            returnValue = appDesc.getApplicationKeyHelper().generateApplicationKey(request);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (contextEstablisher != null && currentThreadClassLoader != null) {
                contextEstablisher.removeContext(currentThreadClassLoader);
            }
        }
        if (returnValue == null || returnValue == "") {
            return null;
        }
        return SipUtil.composeSessionKeyBaseKey(appDesc.getApplicationName(), returnValue);
    }

    public static final String composeSessionKeyBaseKey(String appName, String appKey) {
        StringBuilder sb = new StringBuilder(appName.length() + appKey.length() + 1);
        sb.append(appName).append("_").append(appKey);
        return sb.toString();
    }

    public static final SipURI creatLocalRouteHeader(SipServletRequestImpl request, Serializable stateInfo) {
        SipURIImpl routeUri;
        block5: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)SipUtil.class, "creatLocalRouteHeader", request, stateInfo);
            }
            SipProvider provider = request.getSipProvider();
            ListeningPoint lp = provider.getListeningPoint();
            String host = null;
            int port = -1;
            String transport = null;
            host = lp.getSentBy();
            port = lp.getPort();
            transport = ((ListeningPointImpl)lp).isSecure() ? "TLS" : lp.getTransport();
            routeUri = null;
            try {
                SipURL url = AddressFactoryImpl.createSipURL(null, null, null, host, port, null, null, null, transport);
                routeUri = new SipURIImpl(url);
                routeUri.setParameter("lr", "");
                routeUri.setParameter(IBM_ROUTE_BACK_PARAM, "");
                if (stateInfo != null) {
                    SipApplicationSessionImpl sas = (SipApplicationSessionImpl)SipServletsFactoryImpl.getInstance().createApplicationSession();
                    sas.setInvalidateWhenReady(false);
                    routeUri.setParameter("ibmappid", sas.getId());
                    sas.setAttribute(IBM_STATE_INFO_ATTR, stateInfo);
                }
            }
            catch (SipParseException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug(SipUtil.class, "creatLocalRouteHeader", "failed to create the route back route header", e2);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(SipUtil.class, "creatLocalRouteHeader", routeUri);
        }
        return routeUri;
    }

    public static boolean isSameTransport(SipURI firstURI, SipURI secondURI) {
        String firstURLTransport = SipUtil.getTransport(firstURI);
        String secondURLTransport = SipUtil.getTransport(secondURI);
        return firstURLTransport.equalsIgnoreCase(secondURLTransport);
    }

    public static boolean isSameHost(SipURI url1, SipURI url2) {
        boolean retValue = true;
        if (url1 != null && url2 != null) {
            String host1 = url1.getHost();
            String host2 = url2.getHost();
            retValue = host1.equalsIgnoreCase(host2);
        }
        return retValue;
    }

    public static String getTransport(SipURI uri) {
        if (SIPS_SCHEME.equalsIgnoreCase(uri.getScheme())) {
            return TLS_TRANSPORT;
        }
        if (uri.getTransportParam() != null) {
            return uri.getTransportParam();
        }
        return "udp";
    }

    public static boolean hasBothTags(Request req) {
        if (req.getToHeader().getTag() == null) {
            return false;
        }
        return req.getFromHeader().getTag() != null;
    }

    public static List<ReasonHeaderImpl> parseReasons(String[] reasons) throws SipParseException {
        HashSet uniqueProtocols = new HashSet();
        ArrayList<ReasonHeaderImpl> reasonHeaders = new ArrayList<ReasonHeaderImpl>();
        for (String reason : reasons) {
            boolean moreReason = true;
            while (moreReason) {
                int reasonHeaderLength = 0;
                moreReason = false;
                int cause = 0;
                String text = "";
                String[] reasonParam = reason.split(";");
                String protocol = reasonParam[0].trim();
                reasonHeaderLength += reasonParam[0].length() + 1;
                for (int j = 1; j < reasonParam.length; ++j) {
                    String[] keyVal = reasonParam[j].split("=");
                    if (keyVal[0].trim().equals("cause")) {
                        cause = Integer.parseInt(keyVal[1].trim());
                        reasonHeaderLength += keyVal[0].length() + keyVal[1].length() + 2;
                        continue;
                    }
                    if (!keyVal[0].trim().equals("text")) continue;
                    String restReason = keyVal[1].trim();
                    int indexOfSecondQute = restReason.indexOf(34, restReason.indexOf(34) + 1);
                    text = restReason.substring(1, indexOfSecondQute);
                    if ((reason = reason.substring(reasonHeaderLength += keyVal[0].length() + indexOfSecondQute + 1)).indexOf(44) <= 0) continue;
                    reason = reason.substring(reason.indexOf(44) + 1).trim();
                    moreReason = true;
                    break;
                }
                if (uniqueProtocols.contains(protocol)) {
                    throw new SipParseException(REASON_PROTOCOL_MULTIPLE, reason);
                }
                reasonHeaders.add(new ReasonHeaderImpl(protocol, cause, text));
            }
        }
        return reasonHeaders;
    }

    public static void setIntenalResponseFlag(SipServletResponse resp) {
        boolean markInternalMessage = PropertiesStore.getInstance().getProperties().getBoolean("markInternalResponse");
        if (markInternalMessage && resp != null) {
            resp.setAttribute(INTERNAL_RESPONSE_ATTR, Boolean.TRUE);
        }
        if (resp != null) {
            ((IncomingSipServletResponse)resp).setInternal(true);
        }
    }
}

