/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.jaxrs2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.model.security.OAuthFlowImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.OAuthFlowsImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.ScopesImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.SecurityRequirementImpl;
import com.ibm.ws.microprofile.openapi.impl.model.security.SecuritySchemeImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.annotations.security.OAuthScope;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.annotations.security.SecurityRequirementsSet;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;
import org.eclipse.microprofile.openapi.models.security.Scopes;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityParser {
    static final long serialVersionUID = -97312208405035133L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Optional<List<org.eclipse.microprofile.openapi.models.security.SecurityRequirement>> getSecurityRequirements(SecurityRequirement[] securityRequirementsApi) {
        if (securityRequirementsApi == null || securityRequirementsApi.length == 0) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirementImpl> securityRequirements = new ArrayList<SecurityRequirementImpl>();
        for (SecurityRequirement securityRequirementApi : securityRequirementsApi) {
            SecurityRequirementImpl securityRequirement = new SecurityRequirementImpl();
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addScheme(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
            } else {
                securityRequirement.addScheme(securityRequirementApi.name());
            }
            securityRequirements.add(securityRequirement);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    public static Optional<org.eclipse.microprofile.openapi.models.security.SecurityRequirement> getSecurityRequirementFromSet(SecurityRequirementsSet securityRequirementsApi) {
        if (securityRequirementsApi == null) {
            return Optional.empty();
        }
        SecurityRequirementImpl securityRequirement = new SecurityRequirementImpl();
        for (SecurityRequirement securityRequirementApi : securityRequirementsApi.value()) {
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addScheme(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
                continue;
            }
            securityRequirement.addScheme(securityRequirementApi.name());
        }
        if (securityRequirement.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirement);
    }

    public static Optional<SecurityScheme> getSecurityScheme(org.eclipse.microprofile.openapi.annotations.security.SecurityScheme securityScheme) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        SecuritySchemeImpl securitySchemeObject = new SecuritySchemeImpl();
        if (StringUtils.isNotBlank((CharSequence)securityScheme.ref())) {
            securitySchemeObject.setRef(securityScheme.ref());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.in().toString())) {
            securitySchemeObject.setIn(SecurityParser.getIn(securityScheme.in().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.type().toString())) {
            securitySchemeObject.setType(SecurityParser.getType(securityScheme.type().toString()));
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(securityScheme.openIdConnectUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.securitySchemeName())) {
            securitySchemeObject.setSchemeName(securityScheme.securitySchemeName());
        }
        if (StringUtils.isNotBlank((CharSequence)securityScheme.apiKeyName())) {
            securitySchemeObject.setName(securityScheme.apiKeyName());
        }
        SecurityParser.getOAuthFlows(securityScheme.flows()).ifPresent(arg_0 -> ((SecurityScheme)securitySchemeObject).setFlows(arg_0));
        return Optional.of(securitySchemeObject);
    }

    public static Optional<OAuthFlows> getOAuthFlows(org.eclipse.microprofile.openapi.annotations.security.OAuthFlows oAuthFlows) {
        if (SecurityParser.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        OAuthFlowsImpl oAuthFlowsObject = new OAuthFlowsImpl();
        SecurityParser.getOAuthFlow(oAuthFlows.authorizationCode()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setAuthorizationCode(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.clientCredentials()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setClientCredentials(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.implicit()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setImplicit(arg_0));
        SecurityParser.getOAuthFlow(oAuthFlows.password()).ifPresent(arg_0 -> ((OAuthFlows)oAuthFlowsObject).setPassword(arg_0));
        return Optional.of(oAuthFlowsObject);
    }

    public static Optional<OAuthFlow> getOAuthFlow(org.eclipse.microprofile.openapi.annotations.security.OAuthFlow oAuthFlow) {
        if (SecurityParser.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlowImpl oAuthFlowObject = new OAuthFlowImpl();
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(oAuthFlow.authorizationUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(oAuthFlow.refreshUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(oAuthFlow.tokenUrl());
        }
        SecurityParser.getScopes(oAuthFlow.scopes()).ifPresent(arg_0 -> ((OAuthFlow)oAuthFlowObject).setScopes(arg_0));
        return Optional.of(oAuthFlowObject);
    }

    public static Optional<Scopes> getScopes(OAuthScope[] scopes) {
        if (SecurityParser.isEmpty(scopes)) {
            return Optional.empty();
        }
        ScopesImpl scopesObject = new ScopesImpl();
        for (OAuthScope scope : scopes) {
            scopesObject.addScope(scope.name(), scope.description());
        }
        return Optional.of(scopesObject);
    }

    private static SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i -> i.toString().equals(value)).findFirst().orElse(null);
    }

    private static boolean isEmpty(org.eclipse.microprofile.openapi.annotations.security.OAuthFlows oAuthFlows) {
        if (oAuthFlows == null) {
            return true;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.implicit())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.authorizationCode())) {
            return false;
        }
        if (!SecurityParser.isEmpty(oAuthFlows.clientCredentials())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlows.password());
    }

    private static boolean isEmpty(org.eclipse.microprofile.openapi.annotations.security.OAuthFlow oAuthFlow) {
        if (oAuthFlow == null) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.authorizationUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.refreshUrl())) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)oAuthFlow.tokenUrl())) {
            return false;
        }
        return SecurityParser.isEmpty(oAuthFlow.scopes());
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        return scopes == null || scopes.length == 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.SecurityParser", SecurityParser.class, (String)"MPOPENAPI", (String)"com.ibm.ws.microprofile.openapi.resources.OpenAPI");
    }
}

