/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidGrantTypeException;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerAppTokenAndPasswordImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerClientCredentialsImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerCodeImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerRefreshImpl;
import com.ibm.oauth.core.internal.oauth20.granttype.impl.OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.JwtGrantTypeHandlerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerFactoryImpl
implements OAuth20GrantTypeHandlerFactory {
    static final String CLASS = OAuth20GrantTypeHandlerFactoryImpl.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OAuth20GrantTypeHandler getHandler(String providerId, String grantType, OAuth20ConfigProvider config) throws OAuthException {
        String methodName = "getHandler";
        _log.entering(CLASS, methodName, new Object[]{grantType});
        OAuth20GrantTypeHandler result = null;
        try {
            if (grantType != null) {
                if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(grantType)) {
                    throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", grantType);
                }
                if (grantType.equals("app_token") || grantType.equals("app_password")) {
                    result = this.getCustomGTHandlerInstance(providerId, config, grantType);
                } else {
                    if (!config.isGrantTypeAllowed(grantType)) {
                        throw new OAuthConfigurationException("security.oauth.error.mismatch.granttype.exception", "oauth20.grant.types.allowed", grantType, null);
                    }
                    if (grantType.equals("authorization_code")) {
                        result = new OAuth20GrantTypeHandlerCodeImpl();
                    } else if (grantType.equals("client_credentials")) {
                        result = new OAuth20GrantTypeHandlerClientCredentialsImpl();
                    } else if (grantType.equals("password")) {
                        result = new OAuth20GrantTypeHandlerResourceOwnerCredentialsImpl();
                    } else if (grantType.equals("refresh_token")) {
                        result = new OAuth20GrantTypeHandlerRefreshImpl(config);
                    } else if (grantType.equals("urn:ietf:params:oauth:grant-type:jwt-bearer")) {
                        result = this.getJwtHandlerInstance(providerId, config);
                    }
                }
            }
            if (result == null) {
                throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", grantType);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }

    public synchronized OAuth20GrantTypeHandler getJwtHandlerInstance(String providerId, OAuth20ConfigProvider config) throws OAuth20Exception {
        OAuth20GrantTypeHandler instance;
        block5: {
            String methodName = "getJwtHandlerInstance";
            String handlerClassName = "com.ibm.ws.security.oauth20.jwt.GrantTypeCustomizedHandlerJwtImpl";
            instance = null;
            boolean finestLoggable = _log.isLoggable(Level.FINEST);
            JwtGrantTypeHandlerFactory jwtHandler = null;
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                try {
                    jwtHandler = (JwtGrantTypeHandlerFactory)handlerClass.newInstance();
                    jwtHandler.setHandlerInfo(providerId, (OAuth20Provider)config);
                    instance = jwtHandler.getHandlerInstance();
                }
                catch (Exception e) {
                    if (finestLoggable) {
                        _log.logp(Level.FINEST, CLASS, methodName, "Get an unpexted exception", e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                _log.logp(Level.FINEST, CLASS, methodName, "Do not find class:" + handlerClassName + " If the OP Server intends to handle urn:ietf:params:oauth:grant-type:jwt-bearer, please make sure your server has included openidConnectServer feature");
                if (!finestLoggable) break block5;
                _log.logp(Level.FINEST, CLASS, methodName, "Do not find class:" + handlerClassName + " Please make sure your server has included openidConnectServer feature");
            }
        }
        return instance;
    }

    public synchronized OAuth20GrantTypeHandler getCustomGTHandlerInstance(String providerId, OAuth20ConfigProvider config, String gt) throws OAuth20Exception {
        String methodName = "getCustomGTHandlerInstance";
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        return new OAuth20GrantTypeHandlerAppTokenAndPasswordImpl(gt, (OAuth20Provider)config);
    }
}

