/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.version.Version;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class Headers {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    public static final String ADD_HEADERS_PROPERTY = "org.apache.cxf.http.add-headers";
    public static final String PROTOCOL_HEADERS_CONTENT_TYPE = "Content-Type".toLowerCase();
    public static final String HTTP_HEADERS_SETCOOKIE = "Set-Cookie";
    public static final String HTTP_HEADERS_LINK = "Link";
    public static final String EMPTY_REQUEST_PROPERTY = "org.apache.cxf.empty.request";
    private static final String SET_EMPTY_REQUEST_CT_PROPERTY = "set.content.type.for.empty.request";
    private static final TimeZone TIME_ZONE_GMT = TimeZone.getTimeZone("GMT");
    private static final Logger LOG = LogUtils.getL7dLogger(Headers.class);
    private static final List<String> SENSITIVE_HEADERS = Arrays.asList("Authorization", "Proxy-Authorization");
    private static final List<Object> SENSITIVE_HEADER_MARKER = Arrays.asList("***");
    private static final String ALLOW_LOGGING_SENSITIVE_HEADERS = "allow.logging.sensitive.headers";
    private static final String USER_AGENT = Headers.initUserAgent();
    private final Message message;
    private final Map<String, List<String>> headers;
    static final long serialVersionUID = -1700168025027990899L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Headers(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "<init>", new Object[]{message});
        }
        this.message = message;
        this.headers = Headers.getSetProtocolHeaders(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Headers() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "<init>", new Object[0]);
        }
        this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.message = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getUserAgent() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getUserAgent", new Object[0]);
        }
        String string = USER_AGENT;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getUserAgent", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String initUserAgent() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "initUserAgent", new Object[0]);
        }
        String name = Version.getName();
        if ("Apache CXF".equals(name)) {
            name = "Apache-CXF";
        }
        String version = Version.getCurrentVersion();
        String string = name + "/" + version;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "initUserAgent", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static String toString(Map<String, List<Object>> headers, boolean logSensitiveHeaders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "toString", new Object[]{headers, logSensitiveHeaders});
        }
        TreeMap<String, List<Object>> filteredHeaders = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        filteredHeaders.putAll(headers);
        if (!logSensitiveHeaders) {
            for (String filteredKey : SENSITIVE_HEADERS) {
                filteredHeaders.put(filteredKey, SENSITIVE_HEADER_MARKER);
            }
        }
        String string = ((Object)filteredHeaders).toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "toString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Map<String, List<String>> headerMap() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "headerMap", new Object[0]);
        }
        Map<String, List<String>> map = this.headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "headerMap", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void writeSessionCookies(Map<String, Cookie> sessionCookies) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "writeSessionCookies", new Object[]{sessionCookies});
        }
        List<Object> cookies = null;
        for (String s : this.headers.keySet()) {
            if (!"Cookie".equalsIgnoreCase(s)) continue;
            cookies = this.headers.remove(s);
            break;
        }
        cookies = cookies == null ? new ArrayList() : new ArrayList(cookies);
        this.headers.put("Cookie", cookies);
        for (Cookie c : sessionCookies.values()) {
            cookies.add(c.requestCookieHeader());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "writeSessionCookies");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFromClientPolicy(HTTPClientPolicy policy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setFromClientPolicy", new Object[]{policy});
        }
        if (policy == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromClientPolicy");
            }
            return;
        }
        if (policy.isSetCacheControl()) {
            this.headers.put("Cache-Control", Headers.createMutableList(policy.getCacheControl()));
        }
        if (policy.isSetHost()) {
            this.headers.put("Host", Headers.createMutableList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            this.headers.put("Connection", Headers.createMutableList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            this.headers.put("Accept", Headers.createMutableList(policy.getAccept()));
        } else if (!this.headers.containsKey("Accept")) {
            this.headers.put("Accept", Headers.createMutableList("*/*"));
        }
        if (policy.isSetAcceptEncoding()) {
            this.headers.put("Accept-Encoding", Headers.createMutableList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            this.headers.put("Accept-Language", Headers.createMutableList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            this.message.put("Content-Type", policy.getContentType());
        }
        if (policy.isSetCookie()) {
            this.headers.put("Cookie", Headers.createMutableList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            this.headers.put("User-Agent", Headers.createMutableList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            this.headers.put("Referer", Headers.createMutableList(policy.getReferer()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromClientPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void setFromServerPolicy(HTTPServerPolicy policy) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setFromServerPolicy", new Object[]{policy});
        }
        if (policy.isSetCacheControl()) {
            this.headers.put("Cache-Control", Headers.createMutableList(policy.getCacheControl()));
        }
        if (policy.isSetContentLocation()) {
            this.headers.put("Content-Location", Headers.createMutableList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            this.headers.put("Content-Encoding", Headers.createMutableList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            this.headers.put("Content-Type", Headers.createMutableList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            this.headers.put("Server", Headers.createMutableList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            this.headers.put("Connection", Headers.createMutableList("close"));
        } else if (policy.isSetKeepAliveParameters()) {
            this.headers.put("Keep-Alive", Headers.createMutableList(policy.getKeepAliveParameters()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setFromServerPolicy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeAuthorizationHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "removeAuthorizationHeaders", new Object[0]);
        }
        this.headers.remove("Authorization");
        this.headers.remove("Proxy-Authorization");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "removeAuthorizationHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setAuthorization(String authorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setAuthorization", new Object[]{authorization});
        }
        this.headers.put("Authorization", Headers.createMutableList(authorization));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProxyAuthorization(String authorization) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setProxyAuthorization", new Object[]{authorization});
        }
        this.headers.put("Proxy-Authorization", Headers.createMutableList(authorization));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setProxyAuthorization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Map<String, List<String>> getSetProtocolHeaders(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getSetProtocolHeaders", new Object[]{message});
        }
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            message.put(Message.PROTOCOL_HEADERS, headers);
        } else if (headers instanceof HashMap) {
            TreeMap<String, List<String>> headers2 = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            headers2.putAll(headers);
            message.put(Message.PROTOCOL_HEADERS, headers2);
            headers = headers2;
        }
        Map<String, List<String>> map = headers;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            map = map;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getSetProtocolHeaders", map);
        }
        return map;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFromConnection(HttpURLConnection connection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "readFromConnection", new Object[]{connection});
        }
        Map<String, List<String>> origHeaders = connection.getHeaderFields();
        this.headers.clear();
        for (Map.Entry<String, List<String>> entry : origHeaders.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = HttpHeaderHelper.getHeaderKey(entry.getKey());
            List<String> old = this.headers.get(key);
            if (old != null) {
                ArrayList<String> nl = new ArrayList<String>(old.size() + entry.getValue().size());
                nl.addAll(old);
                nl.addAll((Collection)entry.getValue());
                this.headers.put(key, nl);
                continue;
            }
            this.headers.put(key, entry.getValue());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "readFromConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<String> createMutableList(String val) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "createMutableList", new Object[]{val});
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(val));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "createMutableList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static void logProtocolHeaders(Logger logger, Level level, Map<String, List<Object>> headersMap, boolean logSensitiveHeaders) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "logProtocolHeaders", new Object[]{logger, level, headersMap, logSensitiveHeaders});
        }
        if (logger.isLoggable(level)) {
            for (Map.Entry<String, List<Object>> entry : headersMap.entrySet()) {
                String key = entry.getKey();
                boolean sensitive = !logSensitiveHeaders && SENSITIVE_HEADERS.contains(key);
                List<Object> headerList = sensitive ? SENSITIVE_HEADER_MARKER : entry.getValue();
                for (Object value : headerList) {
                    logger.log(level, key + ": " + (value == null ? "<null>" : value.toString()));
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "logProtocolHeaders");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setProtocolHeadersInConnection(HttpURLConnection connection) throws IOException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "setProtocolHeadersInConnection", new Object[]{connection});
        }
        boolean contentTypeSet = this.headers.containsKey("Content-Type");
        if (!contentTypeSet) {
            boolean emptyRequest;
            boolean dropContentType = false;
            boolean getRequest = "GET".equals(this.message.get("org.apache.cxf.request.method"));
            boolean bl = emptyRequest = getRequest || PropertyUtils.isTrue(this.message.get(EMPTY_REQUEST_PROPERTY));
            if (emptyRequest) {
                Object setCtForEmptyRequestProp = this.message.getContextualProperty(SET_EMPTY_REQUEST_CT_PROPERTY);
                if (setCtForEmptyRequestProp != null) {
                    dropContentType = PropertyUtils.isFalse(setCtForEmptyRequestProp);
                } else if (getRequest) {
                    dropContentType = true;
                }
            }
            if (!dropContentType) {
                String ct = emptyRequest && !contentTypeSet ? "*/*" : this.determineContentType();
                connection.setRequestProperty("Content-Type", ct);
            }
        } else {
            connection.setRequestProperty("Content-Type", this.determineContentType());
        }
        this.transferProtocolHeadersToURLConnection(connection);
        Map<String, List<Object>> theHeaders = CastUtils.cast(this.headers);
        Headers.logProtocolHeaders(LOG, Level.FINE, theHeaders, this.logSensitiveHeaders());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "setProtocolHeadersInConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String determineContentType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "determineContentType", new Object[0]);
        }
        String ct = null;
        List ctList = CastUtils.cast(this.headers.get("Content-Type"));
        ct = ctList != null && ctList.size() == 1 && ctList.get(0) != null ? ctList.get(0).toString() : (String)this.message.get("Content-Type");
        String enc = (String)this.message.get(Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        String string = ct;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "determineContentType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void transferProtocolHeadersToURLConnection(URLConnection connection) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "transferProtocolHeadersToURLConnection", new Object[]{connection});
        }
        boolean addHeaders = MessageUtils.isTrue(this.message.getContextualProperty(ADD_HEADERS_PROPERTY));
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String header = entry.getKey();
            List<String> headerList = entry.getValue();
            if ("Content-Type".equalsIgnoreCase(header)) continue;
            if (addHeaders || "Cookie".equalsIgnoreCase(header)) {
                for (String s : headerList) {
                    connection.addRequestProperty(header, s);
                }
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                b.append(headerList.get(i));
                if (i + 1 >= headerList.size()) continue;
                b.append(',');
            }
            connection.setRequestProperty(header, b.toString());
        }
        if (connection.getRequestProperty("User-Agent") == null) {
            connection.addRequestProperty("User-Agent", USER_AGENT);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "transferProtocolHeadersToURLConnection");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void copyFromRequest(HttpServletRequest req) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "copyFromRequest", new Object[]{req});
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String fname = (String)e.nextElement();
            String mappedName = HttpHeaderHelper.getHeaderKey(fname);
            List<String> values = this.headers.get(mappedName);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(mappedName, values);
            }
            Enumeration e2 = req.getHeaders(fname);
            while (e2.hasMoreElements()) {
                String val = (String)e2.nextElement();
                if ("Accept".equals(mappedName) && values.size() > 0) {
                    String firstAccept = values.get(0);
                    firstAccept = firstAccept + ", " + val;
                    values.set(0, firstAccept);
                }
                values.add(val);
            }
        }
        if (!this.headers.containsKey("Content-Type")) {
            this.headers.put("Content-Type", Collections.singletonList(req.getContentType()));
        }
        if (LOG.isLoggable(Level.FINE)) {
            Map<String, List<Object>> theHeaders = CastUtils.cast(this.headers);
            LOG.log(Level.FINE, "Request Headers: " + Headers.toString(theHeaders, this.logSensitiveHeaders()));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "copyFromRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean logSensitiveHeaders() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "logSensitiveHeaders", new Object[0]);
        }
        boolean bl = PropertyUtils.isTrue(this.message.getContextualProperty(ALLOW_LOGGING_SENSITIVE_HEADERS));
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "logSensitiveHeaders", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getContentTypeFromMessage() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", new Object[0]);
        }
        String ct = (String)this.message.get("Content-Type");
        String enc = (String)this.message.get(Message.ENCODING);
        if (null != ct && null != enc && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
            String string = ct + "; charset=" + enc;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", string);
            }
            return string;
        }
        String string = ct;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getContentTypeFromMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isResponseBodyAvailable() {
        block7: {
            boolean bl;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", new Object[0]);
            }
            List<String> ctLen = this.headers.get("Content-Length");
            if (ctLen == null || ctLen.size() != 1) {
                boolean bl2 = true;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl2 = bl2;
                    LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl2);
                }
                return bl2;
            }
            try {
                if (Integer.parseInt(ctLen.get(0)) != 0) break block7;
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"org.apache.cxf.transport.http.Headers", (String)"502", (Object)this, (Object[])new Object[0]);
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "isResponseBodyAvailable", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSingleHeader(String header) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "isSingleHeader", new Object[]{header});
        }
        boolean bl = HTTP_HEADERS_SETCOOKIE.equalsIgnoreCase(header) || HTTP_HEADERS_LINK.equalsIgnoreCase(header);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "isSingleHeader", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void copyToResponse(HttpServletResponse response) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "copyToResponse", new Object[]{response});
        }
        String contentType = this.getContentTypeFromMessage();
        if (!this.headers.containsKey("Content-Type") && contentType != null && this.isResponseBodyAvailable()) {
            response.setContentType(contentType);
        }
        boolean addHeaders = MessageUtils.isTrue(this.message.getContextualProperty(ADD_HEADERS_PROPERTY));
        for (Map.Entry<String, List<String>> entry : this.headers.entrySet()) {
            String header = entry.getKey();
            List<String> headerList = entry.getValue();
            if (addHeaders || this.isSingleHeader(header)) {
                for (int i = 0; i < headerList.size(); ++i) {
                    String headerObject = headerList.get(i);
                    if (headerObject == null) continue;
                    response.addHeader(header, this.headerObjectToString(headerObject));
                }
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                String headerObject = headerList.get(i);
                if (headerObject != null) {
                    sb.append(this.headerObjectToString(headerObject));
                }
                if (i + 1 >= headerList.size()) continue;
                sb.append(',');
            }
            response.setHeader(header, sb.toString());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "copyToResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String headerObjectToString(Object headerObject) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "headerObjectToString", new Object[]{headerObject});
        }
        if (headerObject.getClass() == String.class) {
            String string = headerObject.toString();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "headerObjectToString", string);
            }
            return string;
        }
        String headerString = headerObject instanceof Date ? Headers.toHttpDate((Date)headerObject) : (headerObject instanceof Locale ? Headers.toHttpLanguage((Locale)headerObject) : headerObject.toString());
        String string = headerString;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "headerObjectToString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void removeContentType() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "removeContentType", new Object[0]);
        }
        this.headers.remove(PROTOCOL_HEADERS_CONTENT_TYPE);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.http.Headers", "removeContentType");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getAuthorization() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getAuthorization", new Object[0]);
        }
        List<String> authorizationLines = this.headers.get("Authorization");
        if (authorizationLines != null && !authorizationLines.isEmpty()) {
            String string = authorizationLines.get(0);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.transport.http.Headers", "getAuthorization", string);
            }
            return string;
        }
        String string = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getAuthorization", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SimpleDateFormat getHttpDateFormat() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "getHttpDateFormat", new Object[0]);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateFormat.setTimeZone(TIME_ZONE_GMT);
        SimpleDateFormat simpleDateFormat = dateFormat;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            simpleDateFormat = simpleDateFormat;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "getHttpDateFormat", simpleDateFormat);
        }
        return simpleDateFormat;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toHttpDate(Date date) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "toHttpDate", new Object[]{date});
        }
        SimpleDateFormat format = Headers.getHttpDateFormat();
        String string = format.format(date);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "toHttpDate", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toHttpLanguage(Locale locale) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.http.Headers", "toHttpLanguage", new Object[]{locale});
        }
        StringBuilder sb = new StringBuilder();
        sb.append(locale.getLanguage());
        if (locale.getCountry() != null) {
            sb.append('-').append(locale.getCountry());
        }
        String string = sb.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.transport.http.Headers", "toHttpLanguage", string);
        }
        return string;
    }
}

