/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.tasks.BaseWaitTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class SubmitTask
extends BaseWaitTask<SubmitTask> {
    public SubmitTask(String scriptName) {
        super("submit", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        List<JobExecution> jobExecutions;
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        this.verifyApplicationNameOrModuleName();
        String instanceId = this.getRestartToken();
        JobInstance jobInstance = null;
        boolean restart = false;
        if (instanceId != null && !(restart = (jobExecutions = this.getBatchRestClient().getJobExecutions(Long.decode(instanceId))) != null && jobExecutions.size() > 0 ? this.isRestartable(jobExecutions.get(0).getBatchStatus()) : true)) {
            this.getTaskArgs().clearRestartTokenFromFile("--restartTokenFile");
        }
        if (!restart) {
            jobInstance = this.getBatchRestClient().start(this.getApplicationName(), this.getModuleName(), this.getComponentName(), this.getJobXMLName(), this.getJobProperties(), this.getJobXMLFile());
            this.issueJobSubmittedMessage(jobInstance);
            this.issueJobInstanceMessage(jobInstance);
        } else {
            Long jobInstanceId = Long.decode(instanceId);
            jobInstance = this.getBatchRestClient().restartJobInstance(jobInstanceId, this.getJobProperties());
            this.issueJobRestartedMessage(jobInstance);
            this.issueJobInstanceMessage(jobInstance);
        }
        if (this.shouldWaitForTermination()) {
            JobExecution jobExecution = this.getPollingBatchRestClient().waitForLatestJobExecution(jobInstance);
            this.writeRestartToken(jobInstance.getInstanceId());
            Thread shutdownHook = this.shouldAddShutdownHook() ? this.addShutdownHook(jobInstance) : null;
            jobExecution = this.waitForTermination(jobInstance, jobExecution);
            if (!this.isRestartable(jobExecution.getBatchStatus())) {
                this.getTaskArgs().clearRestartTokenFromFile("--restartTokenFile");
            }
            this.removeShutdownHook(shutdownHook);
            return this.getProcessReturnCode(jobExecution);
        }
        this.writeRestartToken(jobInstance.getInstanceId());
        return 0;
    }

    protected String getJobXMLName() {
        return this.getTaskArgs().getStringValue("--jobXMLName");
    }

    protected String getApplicationName() {
        return this.getTaskArgs().getStringValue("--applicationName");
    }

    protected String getModuleName() {
        return this.getTaskArgs().getStringValue("--moduleName");
    }

    protected String getComponentName() {
        return this.getTaskArgs().getStringValue("--componentName");
    }

    protected Properties getJobProperties() throws IOException {
        return this.getTaskArgs().getJobParameters();
    }

    protected String getRestartToken() throws IOException {
        Properties restartProps = this.getTaskArgs().getJobPropsFileProps("--restartTokenFile");
        return restartProps.getProperty("restartJob");
    }

    protected void writeRestartToken(Long instanceId) throws IOException {
        this.getTaskArgs().writeRestartTokenFileValue("--restartTokenFile", instanceId.toString());
    }

    public boolean isRestartable(BatchStatus batchStatus) {
        switch (batchStatus) {
            case STOPPED: 
            case FAILED: {
                return true;
            }
        }
        return false;
    }

    protected void verifyApplicationNameOrModuleName() throws IOException {
        if (StringUtils.isEmpty(this.getApplicationName()) && StringUtils.isEmpty(this.getModuleName())) {
            throw new ArgumentRequiredException("--applicationName or --moduleName");
        }
    }

    protected String getJobXMLFile() throws IOException {
        return this.readJSLFromFile(this.getTaskArgs().getStringValue("--jobXMLFile"));
    }

    private String readJSLFromFile(String file) throws IOException {
        if (file != null) {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])), StandardCharsets.UTF_8);
        }
        return null;
    }
}

