/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.session.utils.SessionHashSet;
import com.ibm.wsspi.session.IStoreCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class LRUHashMap
extends HashMap {
    private IStoreCallback _iStoreCallback;
    CacheEntryWrapper mru = null;
    CacheEntryWrapper lru = null;
    int maxSize;
    int currentSize = 0;
    private static final long serialVersionUID = -1137988339144221054L;
    private static final String methodClassName = "LRUHashMap";
    private static final int PUT = 0;
    private static final int ACCESS_OBJECT = 1;
    private static final int GET = 2;
    private static final int REMOVE = 3;
    private static final int REMOVE_GUTS = 4;
    private static final int ENTRY_SET = 5;
    private static final int KEY_SET = 6;
    private static final int UPDATE_CACHE_LIST = 7;
    private static final String[] methodNames = new String[]{"put", "accessObject", "get", "remove", "removeGuts", "entrySet", "keySet", "updateCacheList"};

    public LRUHashMap() {
        this(128);
    }

    public LRUHashMap(int maxCapacity) {
        super(maxCapacity + 20, 1.0f);
        this.maxSize = maxCapacity;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodClassName, "capacity is : " + this.maxSize);
        }
    }

    public void setStoreCallback(IStoreCallback callback) {
        this._iStoreCallback = callback;
    }

    public IStoreCallback getStoreCallback() {
        return this._iStoreCallback;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("key=").append(key);
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], sb.toString());
        }
        if (this.maxSize == 0) {
            return null;
        }
        CacheEntryWrapper oldestEntry = null;
        CacheEntryWrapper currEntry = (CacheEntryWrapper)super.get(key);
        if (currEntry == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Doesn't exist in HashMap");
            }
            ++this.currentSize;
            if (this._iStoreCallback != null) {
                this._iStoreCallback.sessionLiveCountInc(value);
            }
            if (this.currentSize > this.maxSize) {
                if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                    LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Too Many Entries.. Remove the oldest entry: " + this.lru.key);
                }
                oldestEntry = (CacheEntryWrapper)this.removeGuts(this.lru.key);
                if (this._iStoreCallback != null) {
                    this._iStoreCallback.sessionCacheDiscard(oldestEntry.value);
                }
            }
            currEntry = new CacheEntryWrapper();
            currEntry.key = key;
            currEntry.value = value;
            currEntry.next = this.mru;
            if (this.mru != null) {
                this.mru.prev = currEntry;
            } else {
                this.lru = currEntry;
            }
            this.mru = currEntry;
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Adding new entry to the map");
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "Key already in use .. Reuse the entry");
            }
            this.updateCacheList(key);
            currEntry.value = value;
        }
        CacheEntryWrapper replacedEntry = super.put(key, currEntry);
        if (oldestEntry != null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], "Returning object associated with this key: " + oldestEntry.key);
            }
            return oldestEntry.value;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0], null);
        }
        return null;
    }

    public Object accessObject(Object key) {
        CacheEntryWrapper currEntry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[1], "key=" + key);
        }
        if ((currEntry = this.updateCacheList(key)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], "null - Object doesn't exist.");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[1], "Object=" + currEntry.value);
        }
        return currEntry.value;
    }

    @Override
    public Object get(Object key) {
        CacheEntryWrapper currEntry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[2], "key=" + key);
        }
        if ((currEntry = (CacheEntryWrapper)super.get(key)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], "null - Object doesn't exist.");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[2], "found object with key=" + key);
        }
        return currEntry.value;
    }

    @Override
    public synchronized Object remove(Object key) {
        CacheEntryWrapper entry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[3], "Removing the object associated with this key=" + key);
        }
        if ((entry = (CacheEntryWrapper)this.removeGuts(key)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "null - Object doesn't exist.");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[3], "The object being returned was associated with this key=" + key);
        }
        return entry.value;
    }

    private Object removeGuts(Object key) {
        CacheEntryWrapper currEntry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[4], "key=" + key);
        }
        if ((currEntry = (CacheEntryWrapper)super.remove(key)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[4], "key not found in hashmap");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[4], "key found in hashmap");
        }
        --this.currentSize;
        if (this._iStoreCallback != null) {
            this._iStoreCallback.sessionLiveCountDec(currEntry.value);
        }
        CacheEntryWrapper prev = currEntry.prev;
        CacheEntryWrapper next = currEntry.next;
        if (prev == null) {
            this.mru = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.lru = prev;
        } else {
            next.prev = prev;
        }
        currEntry.prev = null;
        currEntry.next = null;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[4], "returning with value: " + currEntry);
        }
        return currEntry;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this._iStoreCallback != null) {
            for (int i = 0; i < this.currentSize; ++i) {
                this._iStoreCallback.sessionLiveCountDec(null);
            }
        }
        this.currentSize = 0;
        this.mru = null;
        this.lru = null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[5]);
        }
        Object[] entries = null;
        Set myEntrySet = super.entrySet();
        if (myEntrySet != null) {
            LRUHashMap lRUHashMap = this;
            synchronized (lRUHashMap) {
                entries = myEntrySet.toArray();
            }
        }
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry me = (Map.Entry)entries[i];
            CacheEntryWrapper cew = (CacheEntryWrapper)me.getValue();
            entries[i] = cew.value;
        }
        SessionHashSet entrySet = new SessionHashSet(entries);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[5], "returning entrySet " + entrySet);
        }
        return entrySet;
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set keySet() {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[6]);
        }
        Object[] keys = null;
        Set myKeySet = super.keySet();
        if (myKeySet != null) {
            LRUHashMap lRUHashMap = this;
            synchronized (lRUHashMap) {
                keys = myKeySet.toArray();
            }
        }
        SessionHashSet keySet = new SessionHashSet(keys);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[6], "returning keySet " + keySet);
        }
        return keySet;
    }

    private synchronized CacheEntryWrapper updateCacheList(Object key) {
        CacheEntryWrapper entry;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[7], "key=" + key);
        }
        if ((entry = (CacheEntryWrapper)super.get(key)) == null) {
            return null;
        }
        CacheEntryWrapper prev = entry.prev;
        CacheEntryWrapper next = entry.next;
        if (prev != null) {
            prev.next = next;
            entry.prev = null;
            entry.next = this.mru;
            this.mru.prev = entry;
            this.mru = entry;
            if (next != null) {
                next.prev = prev;
            } else {
                this.lru = prev;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[7], "Returning object associated with this key=" + key);
        }
        return entry;
    }

    private static class CacheEntryWrapper {
        CacheEntryWrapper prev;
        CacheEntryWrapper next;
        Object key;
        Object value;

        private CacheEntryWrapper() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(" ## CacheEntryWrapper ").append(" key: ").append(this.key);
            return sb.toString();
        }
    }
}

