/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.reflect.Field;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

public class FieldInfo {
    private final TypeInfo container;
    private final Field field;

    FieldInfo(TypeInfo container, Field field) {
        this.container = container;
        this.field = field;
    }

    public String toString() {
        return "field '" + this.field.getName() + "' in " + this.container;
    }

    public TypeInfo getType() {
        return new TypeInfo(this.container, this.field.getGenericType());
    }

    public String getName() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return this.field.getAnnotation(Name.class).value();
        }
        return this.field.getName();
    }

    public Object get(Object instance) {
        try {
            this.field.setAccessible(true);
            return this.field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQlClientException("can't get field " + this, e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new GraphQlClientException("can't set field " + this + " to " + value, e);
        }
    }

    public boolean isNonNull() {
        return this.field.isAnnotationPresent(NonNull.class) || this.getType().isPrimitive();
    }
}

