/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.defer;

import graphql.DeferredExecutionResult;
import graphql.Directives;
import graphql.Internal;
import graphql.execution.MergedField;
import graphql.execution.ValuesResolver;
import graphql.execution.defer.DeferredCall;
import graphql.execution.reactive.SingleSubscriberPublisher;
import graphql.language.Directive;
import graphql.language.Field;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;

@Internal
public class DeferSupport {
    private final AtomicBoolean deferDetected = new AtomicBoolean(false);
    private final Deque<DeferredCall> deferredCalls = new ConcurrentLinkedDeque<DeferredCall>();
    private final SingleSubscriberPublisher<DeferredExecutionResult> publisher = new SingleSubscriberPublisher();
    private final ValuesResolver valuesResolver = new ValuesResolver();

    public boolean checkForDeferDirective(MergedField currentField, Map<String, Object> variables) {
        for (Field field : currentField.getFields()) {
            Directive directive = field.getDirective(Directives.DeferDirective.getName());
            if (directive == null) continue;
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(Directives.DeferDirective.getArguments(), directive.getArguments(), variables);
            return (Boolean)argumentValues.get("if");
        }
        return false;
    }

    private void drainDeferredCalls() {
        if (this.deferredCalls.isEmpty()) {
            this.publisher.noMoreData();
            return;
        }
        DeferredCall deferredCall = this.deferredCalls.pop();
        CompletableFuture<DeferredExecutionResult> future = deferredCall.invoke();
        future.whenComplete((executionResult, exception) -> {
            if (exception != null) {
                this.publisher.offerError((Throwable)exception);
                return;
            }
            this.publisher.offer((DeferredExecutionResult)executionResult);
            this.drainDeferredCalls();
        });
    }

    public void enqueue(DeferredCall deferredCall) {
        this.deferDetected.set(true);
        this.deferredCalls.offer(deferredCall);
    }

    public boolean isDeferDetected() {
        return this.deferDetected.get();
    }

    public Publisher<DeferredExecutionResult> startDeferredCalls() {
        this.drainDeferredCalls();
        return this.publisher;
    }
}

