/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.VisibleForTesting;
import graphql.language.FragmentDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.Set;

public class UniqueFragmentNames
extends AbstractRule {
    private Set<String> fragmentNames = new LinkedHashSet<String>();

    public UniqueFragmentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkFragmentDefinition(FragmentDefinition fragmentDefinition) {
        String name = fragmentDefinition.getName();
        if (name == null) {
            return;
        }
        if (this.fragmentNames.contains(name)) {
            this.addError(ValidationErrorType.DuplicateFragmentName, fragmentDefinition.getSourceLocation(), UniqueFragmentNames.duplicateFragmentName(name));
        } else {
            this.fragmentNames.add(name);
        }
    }

    @VisibleForTesting
    static String duplicateFragmentName(String fragmentName) {
        return String.format("There can be only one fragment named '%s'", fragmentName);
    }
}

