/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.config.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.container.service.config.WebFragmentsInfo;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.web.WebFragment;
import com.ibm.ws.javaee.dd.web.common.AbsoluteOrdering;
import com.ibm.ws.javaee.dd.web.common.Ordering;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class WebFragmentsInfoImpl
implements WebFragmentsInfo {
    static final TraceComponent tc = Tr.register(WebFragmentsInfoImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
    private final int servletSpecLevel;
    private final String servletSchemaLevel;
    private final boolean isMetadataComplete;
    private final AbsoluteOrdering absoluteOrdering;
    private final List<WebFragmentInfo> orderedWebFragmentItems;
    private final List<WebFragmentInfo> excludedWebFragmentItems;
    static final long serialVersionUID = -6525285609588951871L;

    WebFragmentsInfoImpl(Container containerToAdapt, int servletSpecLevel) throws UnableToAdaptException {
        this.servletSpecLevel = servletSpecLevel;
        WebApp webApp = (WebApp)containerToAdapt.adapt(WebApp.class);
        if (webApp != null) {
            this.servletSchemaLevel = webApp.getVersion();
            this.isMetadataComplete = "5.0".equals(this.servletSchemaLevel) || "4.0".equals(this.servletSchemaLevel) || "3.1".equals(this.servletSchemaLevel) || "3.0".equals(this.servletSchemaLevel) || "2.5".equals(this.servletSchemaLevel) ? webApp.isSetMetadataComplete() && webApp.isMetadataComplete() : true;
            this.absoluteOrdering = webApp.getAbsoluteOrdering();
        } else {
            this.servletSchemaLevel = null;
            this.isMetadataComplete = false;
            this.absoluteOrdering = null;
        }
        ArrayList<WebFragmentInfo> useOrderedWebFragmentItems = new ArrayList<WebFragmentInfo>();
        ArrayList<WebFragmentInfo> useExcludedWebFragmentItems = new ArrayList<WebFragmentInfo>();
        WebModuleClassesInfo classesInfo = (WebModuleClassesInfo)containerToAdapt.adapt(WebModuleClassesInfo.class);
        this.sortWebFragments(classesInfo, useOrderedWebFragmentItems, useExcludedWebFragmentItems);
        this.orderedWebFragmentItems = useOrderedWebFragmentItems.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(useOrderedWebFragmentItems);
        this.excludedWebFragmentItems = useExcludedWebFragmentItems.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(useExcludedWebFragmentItems);
    }

    @Override
    @Trivial
    public int getServletSpecLevel() {
        return this.servletSpecLevel;
    }

    @Override
    @Trivial
    public String getServletSchemaLevel() {
        return this.servletSchemaLevel;
    }

    @Override
    @Trivial
    public boolean isModuleMetadataComplete() {
        return this.isMetadataComplete;
    }

    @Override
    public List<WebFragmentInfo> getOrderedFragments() {
        return this.orderedWebFragmentItems;
    }

    @Override
    public List<WebFragmentInfo> getExcludedFragments() {
        return this.excludedWebFragmentItems;
    }

    private List<WebFragmentInfo> sortWebFragments(WebModuleClassesInfo classesInfo, List<WebFragmentInfo> orderedItems, List<WebFragmentInfo> excludedWebFragmentItems) throws UnableToAdaptException {
        List<ContainerInfo> classesContainers = classesInfo.getClassesContainers();
        LinkedHashMap<String, WebFragmentItemImpl> webFragmentItemMap = new LinkedHashMap<String, WebFragmentItemImpl>(classesContainers.size());
        String internalGeneratedWebFragmentNamePrefix = "ibm_liberty_webfragment_";
        int nameSuffix = 0;
        HashSet<String> usedWebFragmentNames = new HashSet<String>();
        for (ContainerInfo containerInfo : classesContainers) {
            Container container = containerInfo.getContainer();
            String libraryURI = containerInfo.getName();
            if (containerInfo.getType() == ContainerInfo.Type.WEB_INF_CLASSES) {
                orderedItems.add(new WebFragmentItemImpl(container, null, libraryURI, null, !this.isMetadataComplete));
                continue;
            }
            if (containerInfo.getType() != ContainerInfo.Type.WEB_INF_LIB) continue;
            WebFragment webFragment = (WebFragment)container.adapt(WebFragment.class);
            boolean isSeed = !this.isMetadataComplete && (webFragment == null || !webFragment.isMetadataComplete());
            String webFragmentName = null;
            if (webFragment != null) {
                webFragmentName = webFragment.getName();
                if (webFragment.getOrdering() != null) {
                    Ordering order = webFragment.getOrdering();
                    if (order.isSetBefore()) {
                        usedWebFragmentNames.addAll(order.getBeforeNames());
                    }
                    if (order.isSetAfter()) {
                        usedWebFragmentNames.addAll(order.getAfterNames());
                    }
                }
            }
            if (webFragmentName != null) {
                usedWebFragmentNames.add(webFragmentName);
                if (webFragmentItemMap.containsKey(webFragmentName) && this.absoluteOrdering == null) {
                    throw new UnableToAdaptException(Tr.formatMessage((TraceComponent)tc, (String)"NO_UNIQUE_WEB_FRAGMENT_NAMES", (Object[])new Object[]{webFragmentName, libraryURI, ((WebFragmentItemImpl)webFragmentItemMap.get((Object)webFragmentName)).libraryURI}));
                }
            }
            if (webFragmentName == null) {
                webFragmentName = internalGeneratedWebFragmentNamePrefix + nameSuffix;
                while (usedWebFragmentNames.contains(webFragmentName)) {
                    webFragmentName = internalGeneratedWebFragmentNamePrefix + ++nameSuffix;
                }
                usedWebFragmentNames.add(webFragmentName);
            }
            webFragmentItemMap.put(webFragmentName, new WebFragmentItemImpl(container, webFragment, libraryURI, webFragmentName, isSeed));
        }
        if (this.servletSpecLevel == 30) {
            if (this.isMetadataComplete) {
                orderedItems.addAll(this.originalOrderWebFragments(webFragmentItemMap));
            } else if (this.absoluteOrdering != null) {
                orderedItems.addAll(this.absoluteOrderWebFragments(webFragmentItemMap, excludedWebFragmentItems));
            } else {
                orderedItems.addAll(this.relativeOrderWebFragments(webFragmentItemMap));
            }
        } else if (this.absoluteOrdering != null) {
            orderedItems.addAll(this.absoluteOrderWebFragments(webFragmentItemMap, excludedWebFragmentItems));
        } else if (this.isMetadataComplete) {
            orderedItems.addAll(this.originalOrderWebFragments(webFragmentItemMap));
        } else {
            orderedItems.addAll(this.relativeOrderWebFragments(webFragmentItemMap));
        }
        return orderedItems;
    }

    private List<WebFragmentInfo> originalOrderWebFragments(Map<String, WebFragmentItemImpl> webFragmentItemMap) {
        ArrayList<WebFragmentInfo> orderedItems = new ArrayList<WebFragmentInfo>(webFragmentItemMap.size());
        for (Map.Entry<String, WebFragmentItemImpl> mapEntry : webFragmentItemMap.entrySet()) {
            orderedItems.add(mapEntry.getValue());
        }
        return orderedItems;
    }

    private List<WebFragmentInfo> absoluteOrderWebFragments(Map<String, WebFragmentItemImpl> webFragmentItemMap, List<WebFragmentInfo> excludedWebFragmentItems) {
        ArrayList<WebFragmentInfo> orderedItems = new ArrayList<WebFragmentInfo>(webFragmentItemMap.size());
        LinkedHashMap<String, WebFragmentItemImpl> candidateWebFragmentItemMap = new LinkedHashMap<String, WebFragmentItemImpl>(webFragmentItemMap);
        for (String webFragmentName : this.absoluteOrdering.getNamesBeforeOthers()) {
            WebFragmentInfo webFragmentItem = (WebFragmentInfo)candidateWebFragmentItemMap.remove(webFragmentName);
            if (webFragmentItem == null) continue;
            orderedItems.add(webFragmentItem);
        }
        int othersBeginIndex = orderedItems.size();
        for (String webFragmentName : this.absoluteOrdering.getNamesAfterOthers()) {
            WebFragmentInfo webFragmentItem = (WebFragmentInfo)candidateWebFragmentItemMap.remove(webFragmentName);
            if (webFragmentItem == null) continue;
            orderedItems.add(webFragmentItem);
        }
        if (this.absoluteOrdering.isSetOthers()) {
            orderedItems.addAll(othersBeginIndex, candidateWebFragmentItemMap.values());
        } else {
            excludedWebFragmentItems.addAll(candidateWebFragmentItemMap.values());
        }
        return orderedItems;
    }

    List<WebFragmentInfo> relativeOrderWebFragments(Map<String, WebFragmentItemImpl> webFragmentItemMap) throws UnableToAdaptException {
        ArrayList<WebFragmentInfo> relativeOrderingList;
        block28: {
            boolean containsRelativeOrderElement;
            boolean isTracing;
            block27: {
                List<RelativeOrderMetaData> relOrderMetaDataList;
                isTracing = TraceComponent.isAnyTracingEnabled();
                AbstractMap relativeOrderMap = new TreeMap();
                containsRelativeOrderElement = false;
                ArrayList<WebFragmentItemImpl> unnamedOthers = null;
                int othersPosition = -1;
                for (Map.Entry<String, WebFragmentItemImpl> warFragmentFile : webFragmentItemMap.entrySet()) {
                    Object currentWebFragment;
                    Ordering ordering;
                    WebFragmentItemImpl webFragmentInfo = warFragmentFile.getValue();
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"webFragmentInfo->[{0}]", (Object[])new Object[]{webFragmentInfo});
                    }
                    Ordering ordering2 = ordering = (currentWebFragment = webFragmentInfo.getWebFragment()) != null ? currentWebFragment.getOrdering() : null;
                    if (ordering != null) {
                        if (isTracing && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"ordering->[{0}]", (Object[])new Object[]{ordering});
                        }
                        RelativeOrderMetaData relativeOrderMetaData = new RelativeOrderMetaData(ordering, currentWebFragment.getName(), (WebFragmentInfo)webFragmentInfo);
                        String name = currentWebFragment.getName();
                        if (relativeOrderMetaData.isDuplicateNames()) {
                            if (isTracing && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("duplicate names found in relative ordering metadata of [" + name + "]"), (Object[])new Object[0]);
                            }
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"duplicate.names.found.in.relative.ordering.metadata.CWWKM0477E", (Object[])new Object[]{"Duplicate names found in relative ordering metadata", name});
                            throw new UnableToAdaptException(msg);
                        }
                        if (isTracing && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"current relativeOrderMetaData[{0}]", (Object[])new Object[]{relativeOrderMetaData});
                        }
                        if (relativeOrderMap.containsKey(name)) {
                            if (isTracing && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("two fragments have the name [" + name + "]"), (Object[])new Object[0]);
                            }
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"two.fragments.have.the.same.name.CWWKM0479E", (Object[])new Object[]{"Two fragments have the same name", name});
                            throw new UnableToAdaptException(msg);
                        }
                        relativeOrderMap.put(name, relativeOrderMetaData);
                        containsRelativeOrderElement = true;
                        continue;
                    }
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no ordering for->[{0}]", (Object[])new Object[]{webFragmentInfo});
                    }
                    if (currentWebFragment != null && currentWebFragment.getName() != null) {
                        RelativeOrderMetaData relativeOrderMetaData = new RelativeOrderMetaData(null, currentWebFragment.getName(), (WebFragmentInfo)webFragmentInfo);
                        if (isTracing && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"no ordering, current relativeOrderMetaData[{0}]", (Object[])new Object[]{relativeOrderMetaData});
                        }
                        relativeOrderMap.put(currentWebFragment.getName(), relativeOrderMetaData);
                        continue;
                    }
                    if (unnamedOthers == null) {
                        unnamedOthers = new ArrayList<WebFragmentItemImpl>();
                    }
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"no ordering, no name [{0}]", (Object[])new Object[]{currentWebFragment});
                    }
                    unnamedOthers.add(webFragmentInfo);
                }
                relativeOrderMap = new LinkedHashMap(relativeOrderMap);
                RelativeOrderMetaData othersROMD = RelativeOrderMetaData.getNewRelativeOthersElement();
                relativeOrderMap.put(othersROMD.getName(), othersROMD);
                relativeOrderingList = new ArrayList<WebFragmentInfo>();
                if (!containsRelativeOrderElement || (relOrderMetaDataList = WebFragmentsInfoImpl.getRelativeOrdering(relativeOrderMap)) == null) break block27;
                int counter = 0;
                for (RelativeOrderMetaData relativeOrderMetaData : relOrderMetaDataList) {
                    if (relativeOrderMetaData.isOthers()) {
                        othersPosition = counter;
                        if (isTracing && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"set others position to-> [ {0} ]", (Object[])new Object[]{othersPosition});
                        }
                    } else {
                        WebFragmentInfo webFragmentInfo = relativeOrderMetaData.getTarget();
                        relativeOrderingList.add(webFragmentInfo);
                        if (isTracing && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"added [{0}] to [{1}]", (Object[])new Object[]{webFragmentInfo, relativeOrderingList});
                        }
                    }
                    relativeOrderMap.remove(relativeOrderMetaData.getName());
                    ++counter;
                }
                if (othersPosition == -1) break block28;
                int tempOthersPosition = othersPosition;
                for (RelativeOrderMetaData relativeOrderMetaData : relativeOrderMap.values()) {
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"adding other [{0}] at position [{1}]", (Object[])new Object[]{relativeOrderMetaData.getTarget(), othersPosition});
                    }
                    WebFragmentInfo warFragmentFile = relativeOrderMetaData.getTarget();
                    relativeOrderingList.add(tempOthersPosition, warFragmentFile);
                    ++tempOthersPosition;
                }
                if (unnamedOthers == null) break block28;
                for (WebFragmentInfo webFragmentInfo : unnamedOthers) {
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"adding unnamed other [{0}] at position [{1}]", (Object[])new Object[]{webFragmentInfo, othersPosition});
                    }
                    relativeOrderingList.add(tempOthersPosition, webFragmentInfo);
                    ++tempOthersPosition;
                }
                break block28;
            }
            if (isTracing && tc.isDebugEnabled()) {
                if (!containsRelativeOrderElement) {
                    Tr.debug((TraceComponent)tc, (String)"no relative ordering elements in the list of fragments", (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)"nothing returned from relative order calculation. return original list", (Object[])new Object[0]);
                }
            }
            for (Map.Entry<String, WebFragmentItemImpl> warFragmentFile : webFragmentItemMap.entrySet()) {
                WebFragmentItemImpl webFragmentItemImpl = warFragmentFile.getValue();
                relativeOrderingList.add(webFragmentItemImpl);
            }
        }
        return relativeOrderingList;
    }

    public static List<RelativeOrderMetaData> getRelativeOrdering(Map<String, RelativeOrderMetaData> relativeOrderMap) throws UnableToAdaptException {
        LinkedList<String> stack;
        RelativeOrderMetaData relativeOrderMetaData;
        boolean isTracing = TraceComponent.isAnyTracingEnabled();
        Set<Map.Entry<String, RelativeOrderMetaData>> relativeOrderSet = relativeOrderMap.entrySet();
        for (Map.Entry<String, RelativeOrderMetaData> relativeOrderEntry : relativeOrderSet) {
            List<String> afterNames;
            List<String> beforeNames;
            if (isTracing && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"adding pointers in each direction for [{0}]", (Object[])new Object[]{relativeOrderEntry});
            }
            if ((beforeNames = (relativeOrderMetaData = relativeOrderEntry.getValue()).getBeforeNameList()) != null) {
                for (String string : beforeNames) {
                    RelativeOrderMetaData beforeRelativeOrderMetaData = relativeOrderMap.get(string);
                    if (beforeRelativeOrderMetaData == null) continue;
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"add after to [{0}] for [{1}]", (Object[])new Object[]{beforeRelativeOrderMetaData, relativeOrderMetaData});
                    }
                    beforeRelativeOrderMetaData.addAfterName(relativeOrderMetaData.getName());
                }
            }
            if ((afterNames = relativeOrderMetaData.getAfterNameList()) == null) continue;
            for (String afterName : afterNames) {
                RelativeOrderMetaData afterRelativeOrderMetaData = relativeOrderMap.get(afterName);
                if (afterRelativeOrderMetaData == null) continue;
                if (isTracing && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"add before to [{0}] for [{1}]", (Object[])new Object[]{afterRelativeOrderMetaData, relativeOrderMetaData});
                }
                afterRelativeOrderMetaData.addBeforeName(relativeOrderMetaData.getName());
            }
        }
        for (Map.Entry<String, RelativeOrderMetaData> relativeOrderEntry : relativeOrderSet) {
            relativeOrderMetaData = relativeOrderEntry.getValue();
            WebFragmentsInfoImpl.propagateOthersMetaData(relativeOrderMetaData, relativeOrderMap);
        }
        LinkedList<String> orderedList = new LinkedList<String>();
        ArrayList<RelativeOrderMetaData> beforeOthers = new ArrayList<RelativeOrderMetaData>();
        ArrayList<RelativeOrderMetaData> unspecified = new ArrayList<RelativeOrderMetaData>();
        ArrayList<RelativeOrderMetaData> afterOthers = new ArrayList<RelativeOrderMetaData>();
        for (Map.Entry<String, RelativeOrderMetaData> relativeOrderEntry : relativeOrderSet) {
            RelativeOrderMetaData relativeOrderMetaData2 = relativeOrderEntry.getValue();
            OthersEnum othersEnum = relativeOrderMetaData2.getOthersEnum();
            if (othersEnum == OthersEnum.AFTER) {
                afterOthers.add(relativeOrderMetaData2);
                continue;
            }
            if (othersEnum == OthersEnum.BEFORE) {
                beforeOthers.add(relativeOrderMetaData2);
                continue;
            }
            if (othersEnum == OthersEnum.UNSPECIFIED) {
                unspecified.add(relativeOrderMetaData2);
                continue;
            }
            if (isTracing && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(relativeOrderMetaData2 + " says its both before and after others"), (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"relative.ordering.metadata.is.before.and.after.others.CWWKM0478E", (Object[])new Object[]{"Relative ordering metadata says its both before and after others", relativeOrderMetaData2});
            throw new UnableToAdaptException(msg);
        }
        if (isTracing && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"afterOthers [{0}], beforeOthers [{1}], unspecified [{2}]", (Object[])new Object[]{afterOthers, beforeOthers, unspecified});
        }
        for (RelativeOrderMetaData relativeOrderMetaData3 : beforeOthers) {
            stack = new LinkedList<String>();
            WebFragmentsInfoImpl.traverseAfter(relativeOrderMetaData3, orderedList, stack, relativeOrderMap, false);
        }
        for (RelativeOrderMetaData relativeOrderMetaData2 : unspecified) {
            stack = new LinkedList();
            WebFragmentsInfoImpl.traverseAfter(relativeOrderMetaData2, orderedList, stack, relativeOrderMap, true);
        }
        for (RelativeOrderMetaData relativeOrderMetaData2 : afterOthers) {
            stack = new LinkedList();
            WebFragmentsInfoImpl.traverseAfter(relativeOrderMetaData2, orderedList, stack, relativeOrderMap, false);
        }
        ArrayList<RelativeOrderMetaData> arrayList = new ArrayList<RelativeOrderMetaData>();
        for (String orderedString : orderedList) {
            arrayList.add(relativeOrderMap.get(orderedString));
        }
        if (isTracing && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("relOrderingList->" + arrayList), (Object[])new Object[0]);
        }
        return arrayList;
    }

    @Trivial
    private static void propagateOthersMetaData(RelativeOrderMetaData relativeOrderMetaData, Map<String, RelativeOrderMetaData> relativeOrderMap) throws UnableToAdaptException {
        boolean isTracing = TraceComponent.isAnyTracingEnabled();
        OthersEnum othersEnum = relativeOrderMetaData.getOthersEnum();
        if (isTracing && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"others for [{0}] is [{1}]", (Object[])new Object[]{relativeOrderMetaData, othersEnum});
        }
        if (othersEnum != OthersEnum.UNSPECIFIED) {
            if (othersEnum == OthersEnum.AFTER) {
                List<String> beforeNameList = relativeOrderMetaData.getBeforeNameList();
                WebFragmentsInfoImpl.setChildOthersMetaData(beforeNameList, othersEnum, relativeOrderMap, relativeOrderMetaData);
            } else {
                List<String> afterNameList = relativeOrderMetaData.getAfterNameList();
                WebFragmentsInfoImpl.setChildOthersMetaData(afterNameList, othersEnum, relativeOrderMap, relativeOrderMetaData);
            }
        }
    }

    private static void setChildOthersMetaData(List<String> nameList, OthersEnum parentOthersEnum, Map<String, RelativeOrderMetaData> relativeOrderMap, RelativeOrderMetaData parentRelativeOrderMetaData) throws UnableToAdaptException {
        boolean isTracing = TraceComponent.isAnyTracingEnabled();
        if (nameList != null) {
            for (String name : nameList) {
                RelativeOrderMetaData relOrderMetadata = relativeOrderMap.get(name);
                if (relOrderMetadata == null) continue;
                if (relOrderMetadata.getOthersEnum() != OthersEnum.UNSPECIFIED && relOrderMetadata.getOthersEnum() != parentOthersEnum) {
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("relation to others is conflicting between [" + parentRelativeOrderMetaData + "," + relOrderMetadata + "]"), (Object[])new Object[0]);
                    }
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"conflicting.relative.order.metadata.CWWKM0480E", (Object[])new Object[]{"Conflicting relative order metadata", parentRelativeOrderMetaData, relOrderMetadata});
                    throw new UnableToAdaptException(msg);
                }
                if (relOrderMetadata.getOthersEnum() == parentOthersEnum) {
                    if (!isTracing || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"already traversed [{0}]", (Object[])new Object[]{relOrderMetadata});
                    continue;
                }
                if (isTracing && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"set others for [{0}] to [{1}]", (Object[])new Object[]{relOrderMetadata, parentOthersEnum});
                }
                relOrderMetadata.setOthersEnum(parentOthersEnum);
                WebFragmentsInfoImpl.propagateOthersMetaData(relOrderMetadata, relativeOrderMap);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void traverseAfter(RelativeOrderMetaData parentRelOrdMetaData, LinkedList<String> orderedList, LinkedList<String> stack, Map<String, RelativeOrderMetaData> relativeOrderMap, boolean isUnspecifiedList) throws UnableToAdaptException {
        boolean isTracing;
        block17: {
            String parentName;
            block16: {
                Iterator<String> strBuild2;
                block15: {
                    block13: {
                        block14: {
                            isTracing = TraceComponent.isAnyTracingEnabled();
                            parentName = parentRelOrdMetaData.getName();
                            if (stack.contains(parentName)) {
                                int listSize = stack.size();
                                StringBuilder strBuild2 = new StringBuilder();
                                strBuild2.append("loop found in list [" + parentName);
                                for (int i = listSize - 1; i >= 0; --i) {
                                    strBuild2.append("," + stack.get(i));
                                }
                                strBuild2.append("]");
                                String errorMsg = strBuild2.toString();
                                if (isTracing && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                                }
                                String msg = Tr.formatMessage((TraceComponent)tc, (String)"loop.found.in.list.CWWKM0481E", (Object[])new Object[]{errorMsg});
                                throw new UnableToAdaptException(msg);
                            }
                            if (isTracing && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("adding [" + parentName + "] to stack [" + stack + "]"), (Object[])new Object[0]);
                            }
                            stack.add(parentName);
                            if (parentRelOrdMetaData.isVisited()) break block13;
                            parentRelOrdMetaData.setVisited(true);
                            List<String> afterNameList = parentRelOrdMetaData.getAfterNameList();
                            if (afterNameList == null || afterNameList.isEmpty()) break block14;
                            strBuild2 = afterNameList.iterator();
                            break block15;
                        }
                        if (!isTracing || !tc.isDebugEnabled()) break block16;
                        Tr.debug((TraceComponent)tc, (String)"after name list is empty for [{0}]", (Object[])new Object[]{parentRelOrdMetaData});
                        break block16;
                    }
                    if (isTracing && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"[{0}] already visited", (Object[])new Object[]{parentRelOrdMetaData});
                    }
                    break block17;
                }
                while (strBuild2.hasNext()) {
                    String afterName = strBuild2.next();
                    RelativeOrderMetaData childRelOrdMetaData = relativeOrderMap.get(afterName);
                    if (childRelOrdMetaData == null) {
                        if (!isTracing || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("unable to locate frag in relative ordering named->" + afterName), (Object[])new Object[0]);
                        continue;
                    }
                    WebFragmentsInfoImpl.traverseAfter(childRelOrdMetaData, orderedList, stack, relativeOrderMap, isUnspecifiedList);
                }
            }
            if (orderedList.contains(parentName)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"ordered.list.already.contains.CWWKM0482E", (Object[])new Object[]{parentName});
                throw new UnableToAdaptException(msg);
            }
            if (isUnspecifiedList && !parentRelOrdMetaData.hasOrderingMetaData() && !parentRelOrdMetaData.isOthers()) {
                if (isTracing && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"[{0}] has no ordering metadata, insert later with unnamed others", (Object[])new Object[]{parentName});
                }
            } else {
                orderedList.add(parentName);
                if (isTracing && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"added [{0}] to orderedList[{1}]", (Object[])new Object[]{parentName, orderedList});
                }
            }
        }
        if (isTracing && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"before stack.removeLast() call: ", (Object[])new Object[]{parentRelOrdMetaData, stack, orderedList});
        }
        stack.removeLast();
    }

    static enum OthersEnum {
        UNSPECIFIED,
        AFTER,
        BEFORE,
        CONFLICT;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RelativeOrderMetaData {
        private boolean visited = false;
        private ArrayList<String> afterNameList;
        private ArrayList<String> beforeNameList;
        private final String name;
        private final WebFragmentInfo target;
        private final boolean isOthers;
        private OthersEnum othersEnum = OthersEnum.UNSPECIFIED;
        private final boolean duplicateNames;
        static final long serialVersionUID = -1069807780114281193L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private static RelativeOrderMetaData getNewRelativeOthersElement() {
            return new RelativeOrderMetaData(null, "com_ibm_ws_webfragmerger_others", null, true);
        }

        private RelativeOrderMetaData(Ordering ordering, String webFragmentName, WebFragmentInfo webFragmentInfo) {
            this(ordering, webFragmentName, webFragmentInfo, false);
        }

        private RelativeOrderMetaData(Ordering ordering, String webFragmentName, WebFragmentInfo webFragmentInfo, boolean isOthers) {
            boolean duplicateNames = false;
            if (ordering != null && ordering.isSetAfter()) {
                this.afterNameList = new ArrayList();
                List afterNames = ordering.getAfterNames();
                for (String afterName : afterNames) {
                    if (this.afterNameList.contains(afterName)) {
                        duplicateNames = true;
                        continue;
                    }
                    this.afterNameList.add(afterName);
                }
                if (ordering.isSetAfterOthers()) {
                    this.othersEnum = OthersEnum.AFTER;
                }
            }
            if (ordering != null && ordering.isSetBefore()) {
                this.beforeNameList = new ArrayList();
                List beforeNames = ordering.getBeforeNames();
                for (String beforeName : beforeNames) {
                    if (this.beforeNameList.contains(beforeName)) {
                        duplicateNames = true;
                        continue;
                    }
                    this.beforeNameList.add(beforeName);
                }
                if (ordering.isSetBeforeOthers()) {
                    this.othersEnum = this.othersEnum == OthersEnum.AFTER || this.othersEnum == OthersEnum.CONFLICT ? OthersEnum.CONFLICT : OthersEnum.BEFORE;
                }
            }
            this.name = webFragmentName;
            this.target = webFragmentInfo;
            this.isOthers = isOthers;
            this.duplicateNames = duplicateNames;
        }

        @Trivial
        public boolean isDuplicateNames() {
            return this.duplicateNames;
        }

        @Trivial
        public List<String> getAfterNameList() {
            return this.afterNameList;
        }

        @Trivial
        public List<String> getBeforeNameList() {
            return this.beforeNameList;
        }

        @Trivial
        public void setVisited(boolean visited) {
            this.visited = visited;
        }

        @Trivial
        public boolean isVisited() {
            return this.visited;
        }

        @Trivial
        public String getName() {
            return this.name;
        }

        @Trivial
        public WebFragmentInfo getTarget() {
            return this.target;
        }

        public void addAfterName(String name) {
            if (this.afterNameList == null) {
                this.afterNameList = new ArrayList();
            }
            if (!this.afterNameList.contains(name)) {
                this.afterNameList.add(name);
            }
        }

        public void addBeforeName(String name) {
            if (this.beforeNameList == null) {
                this.beforeNameList = new ArrayList();
            }
            if (!this.beforeNameList.contains(name)) {
                this.beforeNameList.add(name);
            }
        }

        @Trivial
        public OthersEnum getOthersEnum() {
            return this.othersEnum;
        }

        @Trivial
        public void setOthersEnum(OthersEnum othersEnum) {
            this.othersEnum = othersEnum;
        }

        @Trivial
        public boolean isOthers() {
            return this.isOthers;
        }

        public boolean hasOrderingMetaData() {
            return this.afterNameList != null && !this.afterNameList.isEmpty() || this.beforeNameList != null && !this.beforeNameList.isEmpty();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.config.internal.WebFragmentsInfoImpl$RelativeOrderMetaData", RelativeOrderMetaData.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class WebFragmentItemImpl
    implements WebFragmentInfo {
        private final Container container;
        public final WebFragment webFragment;
        public final String libraryURI;
        public final String name;
        public final boolean isSeedFragment;
        static final long serialVersionUID = 4676198424770443561L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebFragmentItemImpl(Container container, WebFragment webFragment, String libraryURI, String name, boolean isSeed) {
            this.container = container;
            this.webFragment = webFragment;
            this.libraryURI = libraryURI;
            this.name = name;
            this.isSeedFragment = isSeed;
        }

        @Override
        @Trivial
        public WebFragment getWebFragment() {
            return this.webFragment;
        }

        @Override
        @Trivial
        public String getLibraryURI() {
            return this.libraryURI;
        }

        @Override
        @Trivial
        public Container getFragmentContainer() {
            return this.container;
        }

        @Override
        @Trivial
        public boolean isSeedFragment() {
            return this.isSeedFragment;
        }

        @Override
        @Trivial
        public boolean isPartialFragment() {
            return !this.isSeedFragment;
        }

        @Trivial
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WebFragmentItemImpl other = (WebFragmentItemImpl)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Trivial
        public int hashCode() {
            return this.name == null ? 0 : this.name.hashCode();
        }

        @Trivial
        public String toString() {
            return this.name + "(" + this.libraryURI + ")";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.config.internal.WebFragmentsInfoImpl$WebFragmentItemImpl", WebFragmentItemImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        }
    }
}

