/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.impl.DerbyHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import javax.resource.ResourceException;

public class DerbyNetworkClientHelper
extends DerbyHelper {
    private static final Class<?> currClass = DerbyNetworkClientHelper.class;
    private static transient TraceComponent tc = Tr.register(currClass, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String TRACE_FILE = "traceFile";
    private static final String TRACE_FILE_DIR = "traceDirectory";
    private static final String TRACE_FILE_APPEND = "traceFileAppend";
    private transient PrintWriter derbyNSPw;
    private transient String traceFile;
    boolean traceAppend = false;
    String traceDir = null;

    DerbyNetworkClientHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        Properties props = mcf.dsConfig.get().vendorProps;
        this.traceFile = props.getProperty(TRACE_FILE);
        this.traceDir = props.getProperty(TRACE_FILE_DIR);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"traceDir is set to ", (Object[])new Object[]{this.traceDir});
        }
        this.traceDir = this.traceDir != null && !this.traceDir.equals("") ? this.traceDir + File.separator : "";
        Object holder = props.get(TRACE_FILE_APPEND);
        boolean bl = holder instanceof Boolean ? (Boolean)holder : (this.traceAppend = holder instanceof String ? Boolean.valueOf((String)holder) : false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Trace Append is set to ", (Object[])new Object[]{holder});
        }
        if (this.traceFile != null && !this.traceFile.equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Derby network server JDBC trace was configured to go to a file, Thus no integration with WAS trace.  File name is: ", (Object[])new Object[]{this.traceDir + this.traceFile});
            }
            this.derbyNSPw = AccessController.doPrivileged(new PrivilegedAction<PrintWriter>(){

                @Override
                public PrintWriter run() {
                    try {
                        return new PrintWriter(new FileOutputStream(DerbyNetworkClientHelper.this.traceDir + DerbyNetworkClientHelper.this.traceFile, DerbyNetworkClientHelper.this.traceAppend), true);
                    }
                    catch (IOException e) {
                        Tr.error((TraceComponent)tc, (String)"DB2_FILE_OUTSTREAM_ERROR", (Object[])new Object[]{DerbyNetworkClientHelper.this.traceFile});
                        return null;
                    }
                }
            });
        } else {
            this.derbyNSPw = new PrintWriter((Writer)new TraceWriter(derbyTc), true);
        }
    }

    @Override
    void customizeStaleStates() {
        super.customizeStaleStates();
        Collections.addAll(this.staleErrorCodes, -4499);
    }

    @Override
    public boolean doesStatementCacheIsoLevel() {
        return true;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.derbyNSPw == null) {
            this.derbyNSPw = new PrintWriter((Writer)new TraceWriter(derbyTc), true);
        }
        Tr.debug((TraceComponent)derbyTc, (String)"returning", (Object[])new Object[]{this.derbyNSPw});
        return this.derbyNSPw;
    }

    @Override
    public void enableJdbcLogging(WSManagedConnectionFactoryImpl mcf) throws ResourceException {
        PrintWriter pw = this.getPrintWriter();
        if (TraceComponent.isAnyTracingEnabled() && derbyTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)derbyTc, (String)"enabling Derby logging {mcf, pw}: ", (Object[])new Object[]{mcf, pw});
        }
        mcf.reallySetLogWriter(pw);
        mcf.loggingEnabled = true;
    }
}

