/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;
import java.util.Collections;
import javax.resource.ResourceException;
import javax.sql.XADataSource;

public class SybaseHelper
extends DatabaseHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(SybaseHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient com.ibm.ejs.ras.TraceComponent sybaseTc = Tr.register((String)"com.ibm.ws.sybase.logwriter", (String)"WAS.database", null);
    private transient PrintWriter sybasePw = null;

    SybaseHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        mcf.supportsGetTypeMap = false;
    }

    @Override
    void customizeStaleStates() {
        super.customizeStaleStates();
        Collections.addAll(this.staleSQLStates, "JZ0C0", "JZ0C1");
    }

    @Override
    public boolean doConnectionCleanup(Connection conn) throws SQLException {
        boolean standardPropModified = false;
        if (XADataSource.class.isAssignableFrom(this.mcf.vendorImplClass)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): calling setAutoCommit(true) and returning true from this method", (Object[])new Object[0]);
            }
            conn.setAutoCommit(true);
            standardPropModified = true;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"doConnectionCleanup(): doing nothing and returning false from this method", (Object[])new Object[0]);
        }
        conn.clearWarnings();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"clearWarnings: cleanup of warnings done", (Object[])new Object[0]);
        }
        return standardPropModified;
    }

    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
        SQLWarning warn = conn.getWarnings();
        if (warn != null) {
            SQLException sqlex = null;
            String sqlstate = warn.getSQLState();
            if (sqlstate.equals("010UF")) {
                sqlex = new SQLException(warn.getMessage(), sqlstate);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)(sqlstate + warn.getMessage()), (Object[])new Object[0]);
                }
                for (warn = warn.getNextWarning(); warn != null; warn = warn.getNextWarning()) {
                    SQLException sqlex2 = new SQLException(warn.getMessage(), warn.getSQLState());
                    sqlex.setNextException(sqlex2);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)(warn.getSQLState() + warn.getMessage()), (Object[])new Object[0]);
                }
                throw sqlex;
            }
        }
    }

    @Override
    public int getDefaultIsolationLevel() {
        return 4;
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        stmt.setFetchDirection(1000);
        if (stmt.getMaxFieldSize() != 0) {
            stmt.setMaxFieldSize(0);
        }
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.sybasePw == null) {
            this.sybasePw = new PrintWriter((Writer)new TraceWriter(this.sybaseTc), true);
        }
        if (trace && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.sybasePw});
        }
        return this.sybasePw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.sybaseTc;
    }

    @Override
    public long getUpdateCount(WSJdbcStatement stmt) throws SQLException {
        try {
            return super.getUpdateCount(stmt);
        }
        catch (SQLException x) {
            if ("JZ0PA".equals(x.getSQLState())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning stmt.getUpdateCount = -1 to work around Sybase bug", (Object[])new Object[]{x.getMessage()});
                }
                return -1L;
            }
            throw x;
        }
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        block3: {
            this.setDatabaseProductName("Sybase SQL Server");
            try {
                super.gatherAndDisplayMetaDataInfo(conn, mcf);
            }
            catch (SQLException x) {
                if (this.isConnectionError(x)) {
                    throw x;
                }
                com.ibm.websphere.ras.Tr.info((TraceComponent)tc, (String)"META_DATA_EXCEPTION", (Object[])new Object[]{x.getMessage()});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("meta data access caused a non SCE, continuing without displaying metadata: " + x), (Object[])new Object[0]);
            }
        }
    }

    @Override
    boolean isAuthException(SQLException x) {
        return x instanceof SQLInvalidAuthorizationSpecException || "JZ00L".equals(x.getSQLState()) || "JZ001".equals(x.getSQLState()) || "JZ002".equals(x.getSQLState());
    }

    @Override
    public void setReadOnly(WSRdbManagedConnectionImpl managedConn, boolean readOnly, boolean externalCall) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly", (Object[])new Object[]{managedConn, readOnly, externalCall});
        }
        if (!externalCall) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"setReadOnly ignored for internal call", (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"Method setReadOnly() is ignored by WebSphere. Sybase does not honor the setReadOnly method.", (Object[])new Object[0]);
        }
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return this.sybaseTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !this.sybaseTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

