/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap12;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAP12OperationSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAP12Operation soapOperation = (SOAP12Operation)extension;
        if (soapOperation != null) {
            String tagName = DOMUtils.getQualifiedValue((String)"http://schemas.xmlsoap.org/wsdl/soap12/", (String)"operation", (Definition)def);
            pw.print("      <" + tagName);
            Boolean soapActionRequired = soapOperation.getSoapActionRequired();
            String soapActionRequiredString = soapActionRequired == null ? null : soapActionRequired.toString();
            DOMUtils.printAttribute((String)"soapAction", (String)soapOperation.getSoapActionURI(), (PrintWriter)pw);
            DOMUtils.printAttribute((String)"soapActionRequired", (String)soapActionRequiredString, (PrintWriter)pw);
            DOMUtils.printAttribute((String)"style", (String)soapOperation.getStyle(), (PrintWriter)pw);
            Boolean required = soapOperation.getRequired();
            if (required != null) {
                DOMUtils.printQualifiedAttribute((QName)Constants.Q_ATTR_REQUIRED, (String)required.toString(), (Definition)def, (PrintWriter)pw);
            }
            pw.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAP12Operation soapOperation = (SOAP12Operation)extReg.createExtension(parentType, elementType);
        String soapActionURI = DOMUtils.getAttribute((Element)el, (String)"soapAction");
        String soapActionRequiredString = DOMUtils.getAttribute((Element)el, (String)"soapActionRequired");
        String style = DOMUtils.getAttribute((Element)el, (String)"style");
        String requiredStr = DOMUtils.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (soapActionURI != null) {
            soapOperation.setSoapActionURI(soapActionURI);
        }
        if (soapActionRequiredString != null) {
            Boolean soapActionRequired = new Boolean(soapActionRequiredString);
            soapOperation.setSoapActionRequired(soapActionRequired);
        }
        if (style != null) {
            soapOperation.setStyle(style);
        }
        if (requiredStr != null) {
            soapOperation.setRequired(new Boolean(requiredStr));
        }
        return soapOperation;
    }
}

