/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import io.openliberty.grpc.monitor.GrpcServerStatsMXBean;

public class GrpcServerStats
extends Meter
implements GrpcServerStatsMXBean {
    private String appName;
    private String serviceName;
    private Counter receivedMsgCount;
    private Counter sentMsgCount;
    private Counter serverStarted;
    private Counter serverHandled;
    private StatisticsMeter responseTime;

    public GrpcServerStats(String aName, String sName) {
        this.setAppName(aName);
        this.setServiceName(sName);
        this.serverStarted = new Counter();
        this.serverStarted.setDescription("This shows total number of RPCs started on the server");
        this.serverStarted.setUnit("ns");
        this.serverHandled = new Counter();
        this.serverHandled.setDescription("This shows total number of RPCs completed on the server");
        this.serverHandled.setUnit("ns");
        this.receivedMsgCount = new Counter();
        this.receivedMsgCount.setDescription("This shows number of received stream messages");
        this.receivedMsgCount.setUnit("ns");
        this.sentMsgCount = new Counter();
        this.sentMsgCount.setDescription("This shows number of stream messages sent by the service");
        this.sentMsgCount.setUnit("ns");
        this.responseTime = new StatisticsMeter();
        this.responseTime.setDescription("Average RPC Response Time");
        this.responseTime.setUnit("ns");
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    public String getDescription() {
        return "Report gRPC statistics for the specified service and application.";
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void recordCallStarted() {
        this.serverStarted.incrementBy(1L);
    }

    public void recordServerHandled() {
        this.serverHandled.incrementBy(1L);
    }

    public void incrementReceivedMsgCountBy(int i) {
        this.receivedMsgCount.incrementBy((long)i);
    }

    public void incrementSentMsgCountBy(int i) {
        this.sentMsgCount.incrementBy((long)i);
    }

    public void recordLatency(long latencyMs) {
        this.responseTime.addDataPoint(latencyMs);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public long getReceivedMessagesCount() {
        return this.receivedMsgCount.getCurrentValue();
    }

    @Override
    public long getSentMessagesCount() {
        return this.sentMsgCount.getCurrentValue();
    }

    @Override
    public long getRpcStartedCount() {
        return this.serverStarted.getCurrentValue();
    }

    @Override
    public long getRpcCompletedCount() {
        return this.serverHandled.getCurrentValue();
    }

    @Override
    public double getResponseTime() {
        return this.responseTime.getMean();
    }

    public StatisticsMeter getResponseTimeDetails() {
        return this.responseTime;
    }
}

