/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.HashMap;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.discovery.tools.ManagedProperties;
import org.apache.commons.logging.Log;

public class DiscoverNamesInAlternateManagedProperties
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverNamesInAlternateManagedProperties.class);
    HashMap mapping = new HashMap();

    public static void setLog(Log _log) {
        log = _log;
    }

    public void addClassToPropertyNameMapping(String className, String propertyName) {
        this.mapping.put(className, propertyName);
    }

    public ResourceNameIterator findResourceNames(String resourceName) {
        final String mappedName = (String)this.mapping.get(resourceName);
        if (log.isDebugEnabled()) {
            if (mappedName == null) {
                log.debug((Object)("find: resourceName='" + resourceName + "', no mapping"));
            } else {
                log.debug((Object)("find: resourceName='" + resourceName + "', lookup property '" + mappedName + "'"));
            }
        }
        return new ResourceNameIterator(){
            private String resource;
            {
                this.resource = mappedName == null ? null : ManagedProperties.getProperty(mappedName);
            }

            public boolean hasNext() {
                return this.resource != null;
            }

            public String nextResourceName() {
                String element = this.resource;
                this.resource = null;
                return element;
            }
        };
    }
}

