/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.chfw;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.sip.stack.transport.chfw.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.chfw.GenericEndpointImpl;
import com.ibm.wsspi.channelfw.ChainEventListener;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.RetryableChannelException;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public abstract class GenericChain
implements ChainEventListener {
    private static final LogMgr c_logger = Log.get(GenericChain.class);
    protected static final String LOCALHOST = "localhost";
    protected static final String ID = "id";
    private static String SIP_Channel = "SIPChannel_";
    private static String CHAIN = "Chain";
    protected static int s_chains = 0;
    private final StopWait stopWait = new StopWait();
    protected final GenericEndpointImpl owner;
    private String endpointName;
    protected String sipChannelName;
    private String chainName;
    private ChannelFramework cfw;
    protected EndPointMgr endpointMgr;
    private final AtomicInteger chainState;
    private volatile boolean enabled;
    private volatile ActiveConfiguration currentConfig;

    public GenericChain(GenericEndpointImpl owner) {
        this.chainState = new AtomicInteger(ChainState.UNINITIALIZED.val);
        this.enabled = false;
        this.currentConfig = null;
        this.owner = owner;
    }

    protected ActiveConfiguration getCurrentConfig() {
        return this.currentConfig;
    }

    protected void setCurrentConfig(ActiveConfiguration currentConfig) {
        this.currentConfig = currentConfig;
    }

    protected String getEndpointName() {
        return this.endpointName;
    }

    public void init(String endpointId, Object componentId, CHFWBundle cfBundle, String name) {
        String chainNumber = String.valueOf(s_chains++);
        this.cfw = cfBundle.getFramework();
        this.endpointMgr = cfBundle.getEndpointManager();
        this.endpointName = endpointId;
        this.sipChannelName = SIP_Channel + this.getName() + "_" + endpointId + "_" + chainNumber;
        this.chainName = CHAIN + endpointId + "_" + chainNumber;
    }

    public String getChainName() {
        return this.chainName;
    }

    public ChannelFramework getCfw() {
        return this.cfw;
    }

    public void enable() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("enable chain " + this);
        }
        this.enabled = true;
    }

    public void disable() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("disable chain " + this);
        }
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected GenericEndpointImpl getOwner() {
        return this.owner;
    }

    public synchronized void stop() {
        block7: {
            if (c_logger.isEventEnabled()) {
                c_logger.event("stop chain " + this, new Object[0]);
            }
            if (this.currentConfig == null || this.chainState.get() <= ChainState.QUIESCED.val) {
                return;
            }
            try {
                ChainData cd = this.cfw.getChain(this.chainName);
                if (cd != null) {
                    this.cfw.stopChain(cd, this.cfw.getDefaultChainQuiesceTimeout());
                }
            }
            catch (ChannelException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Error stopping chain " + this.chainName, new Object[]{this, e2});
                }
            }
            catch (ChainException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block7;
                c_logger.traceDebug("Error stopping chain " + this.chainName, new Object[]{this, e3});
            }
        }
    }

    protected ChannelData getChannel(String name) {
        return this.cfw.getChannel(name);
    }

    protected ChannelData addChannel(String name, String factoryName, Map<Object, Object> chanProps, ActiveConfiguration newConfig) {
        try {
            return this.cfw.addChannel(name, this.cfw.lookupFactory(factoryName), chanProps);
        }
        catch (ChannelException e2) {
            this.handleStartupError((Exception)((Object)e2), newConfig);
            return null;
        }
    }

    protected synchronized void startChain(ActiveConfiguration newConfig) {
        try {
            int retries = this.getOwner().retries;
            do {
                try {
                    this.cfw.startChain(this.chainName);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("startChannels", "chain started [" + this.chainName + ']');
                    }
                    retries = 0;
                }
                catch (RetryableChannelException e2) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("startChannels", new Object[]{"RetryableChannelException. Retries left [" + (retries - 1) + ']', e2});
                    }
                    if (--retries <= 0) continue;
                    try {
                        Thread.sleep(this.getOwner().retry_delay);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!c_logger.isTraceDebugEnabled()) continue;
                        c_logger.traceDebug("startChannels", "", interruptedException);
                    }
                }
            } while (retries > 0);
        }
        catch (ChannelException e3) {
            this.handleStartupError((Exception)((Object)e3), newConfig);
        }
        catch (ChainException e4) {
            this.handleStartupError((Exception)((Object)e4), newConfig);
        }
        catch (Exception e5) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("start.sipChain.error", this.getName(), e5.toString());
            }
            this.handleStartupError(e5, newConfig);
        }
    }

    protected synchronized void stopChain(String oldConfig) {
        block5: {
            try {
                ChainData cd = this.cfw.getChain(this.chainName);
                if (cd != null) {
                    this.cfw.stopChain(cd, this.cfw.getDefaultChainQuiesceTimeout());
                    this.stopWait.waitForStop(this.cfw.getDefaultChainQuiesceTimeout());
                    this.cfw.destroyChain(cd);
                    this.cfw.removeChain(cd);
                }
            }
            catch (ChannelException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Error stopping chain " + this.chainName, new Object[]{oldConfig, e2});
                }
            }
            catch (ChainException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug("Error stopping chain " + this.chainName, new Object[]{oldConfig, e3});
            }
        }
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    protected void removeChannel(String name) {
        block4: {
            try {
                this.cfw.removeChannel(name);
            }
            catch (ChannelException e2) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Error removing channel " + name, new Object[]{this, e2});
                }
            }
            catch (ChainException e3) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug("Error removing channel " + name, new Object[]{this, e3});
            }
        }
    }

    private void handleStartupError(Exception e2, ActiveConfiguration cfg) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Error starting chain " + this.chainName, this, e2);
        }
        String topic = this.owner.getEventTopic() + "/FAILED";
        this.postEvent(topic, cfg, e2);
    }

    public int getActivePort() {
        ActiveConfiguration cfg = this.currentConfig;
        if (cfg != null) {
            return cfg.getActivePort();
        }
        return -1;
    }

    public String getActiveHost() {
        ActiveConfiguration cfg = this.currentConfig;
        if (cfg != null) {
            return cfg.activeHost;
        }
        return null;
    }

    protected abstract String getName();

    protected abstract void setupEventProps(Map<String, Object> var1);

    protected abstract ActiveConfiguration createActiveConfiguration();

    protected abstract void createChannels(ActiveConfiguration var1);

    protected abstract void rebuildTheChannel(ActiveConfiguration var1, ActiveConfiguration var2);

    public void chainInitialized(ChainData chainData) {
        this.chainState.set(ChainState.INITIALIZED.val);
    }

    @FFDCIgnore(value={ChannelException.class, ChainException.class})
    public synchronized void update() {
        if (c_logger.isEventEnabled()) {
            c_logger.event("update chain " + this, new Object[0]);
        }
        if (!this.isEnabled() || FrameworkState.isStopping()) {
            return;
        }
        ActiveConfiguration oldConfig = this.getCurrentConfig();
        boolean validOldConfig = oldConfig == null ? false : oldConfig.validConfiguration;
        ActiveConfiguration newConfig = this.createActiveConfiguration();
        if (newConfig.configPort < 0 || !newConfig.isReady()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Stopping chain due to configuration " + newConfig);
            }
            this.setCurrentConfig(newConfig);
            this.stopChain(oldConfig.toString());
            return;
        }
        if (validOldConfig && newConfig.unchanged(oldConfig)) {
            int port;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Configuration is unchanged " + newConfig);
            }
            if ((port = newConfig.getActivePort()) == oldConfig.getActivePort() && port != -1) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("Chain is already started " + oldConfig);
                }
                return;
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("Existing config must be started " + newConfig);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("New/changed chain configuration " + newConfig);
        }
        if (validOldConfig) {
            this.rebuildTheChannel(oldConfig, newConfig);
        }
        this.createChannels(newConfig);
        this.setCurrentConfig(newConfig);
        if (newConfig.validConfiguration) {
            this.startChain(newConfig);
        }
    }

    public synchronized void chainStarted(ChainData chainData) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Chain " + this.toString() + " is started");
        }
        this.chainState.set(ChainState.STARTED.val);
        ActiveConfiguration cfg = this.currentConfig;
        int port = cfg.getActivePort();
        if (port > 0) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("New configuration started " + cfg);
            }
            String topic = this.owner.getEventTopic() + "/STARTED";
            this.postEvent(topic, cfg, null);
        }
    }

    public void chainStopped(ChainData chainData) {
        ActiveConfiguration cfg = this.currentConfig;
        this.stopWait.notifyStopped();
        String topic = this.owner.getEventTopic() + "/STOPPED";
        this.postEvent(topic, cfg, null);
    }

    public void chainQuiesced(ChainData chainData) {
        int oldState = this.chainState.getAndSet(ChainState.QUIESCED.val);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("chainQuiesced, chainData = " + chainData + " oldState = " + oldState);
        }
    }

    public void chainDestroyed(ChainData chainData) {
        this.chainState.set(ChainState.DESTROYED.val);
    }

    public void chainUpdated(ChainData chainData) {
    }

    protected void postEvent(String t, ActiveConfiguration c, Exception e2) {
        EventAdmin engine;
        HashMap<String, Object> eventProps = new HashMap<String, Object>(4);
        if (c.activeHost != null) {
            eventProps.put("activeHost", c.activeHost);
        }
        eventProps.put("activePort", c.activePort);
        eventProps.put("configHost", c.configHost);
        eventProps.put("configPort", c.configPort);
        this.setupEventProps(eventProps);
        if (e2 != null) {
            eventProps.put("exception", e2.toString());
        }
        if ((engine = GenericEndpointImpl.getEventAdmin()) != null) {
            Event event = new Event(t, eventProps);
            engine.postEvent(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@=" + System.identityHashCode(this) + ",enabled=" + this.enabled + ",state=" + ChainState.printState(this.chainState.get()) + ",chainName=" + this.chainName + ",config=" + this.currentConfig + "]";
    }

    protected void addChain(String[] chanList, ChainData cd, ActiveConfiguration newConfig) {
        try {
            cd = this.getCfw().addChain(this.getChainName(), FlowType.INBOUND, chanList);
            cd.setEnabled(this.enabled);
            this.getCfw().addChainEventListener((ChainEventListener)this, this.getChainName());
            this.getCfw().initChain(this.chainName);
            newConfig.validConfiguration = true;
        }
        catch (ChannelException e2) {
            this.handleStartupError((Exception)((Object)e2), newConfig);
        }
        catch (ChainException e3) {
            this.handleStartupError((Exception)((Object)e3), newConfig);
        }
        catch (Exception e4) {
            if (c_logger.isErrorEnabled()) {
                c_logger.error("config.sipChain.error", this.getName(), e4.toString());
            }
            this.handleStartupError(e4, newConfig);
        }
    }

    private class StopWait {
        private StopWait() {
        }

        synchronized void waitForStop(long timeout) {
            long start;
            long interval = timeout + 2345L;
            for (long waited = 0L; GenericChain.this.chainState.get() > ChainState.STOPPED.val && waited < interval; waited += System.nanoTime() - start) {
                start = System.nanoTime();
                try {
                    this.wait(interval - waited);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        synchronized void notifyStopped() {
            this.notifyAll();
        }
    }

    static enum ChainState {
        UNINITIALIZED(0, "UNINITIALIZED"),
        DESTROYED(1, "DESTROYED"),
        INITIALIZED(2, "INITIALIZED"),
        STOPPED(3, "STOPPED"),
        QUIESCED(4, "QUIESCED"),
        STARTED(5, "STARTED");

        final int val;
        final String name;

        @Trivial
        private ChainState(int val, String name) {
            this.val = val;
            this.name = "name";
        }

        @Trivial
        public static final String printState(int state) {
            switch (state) {
                case 0: {
                    return "UNINITIALIZED";
                }
                case 1: {
                    return "DESTROYED";
                }
                case 2: {
                    return "INITIALIZED";
                }
                case 3: {
                    return "STOPPED";
                }
                case 4: {
                    return "QUIESCED";
                }
                case 5: {
                    return "STARTED";
                }
            }
            return "UNKNOWN";
        }
    }
}

