/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.server.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channelfw.CFEndPoint;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.jfapchannel.server.AcceptListenerFactory;
import com.ibm.ws.sib.jfapchannel.server.ServerConnectionManager;
import com.ibm.ws.sib.jfapchannel.server.impl.ListenerPortImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.List;

public class ServerConnectionManagerImpl
extends ServerConnectionManager {
    private static final TraceComponent tc = SibTr.register(ServerConnectionManagerImpl.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String busUriPattern = ".*/buses/.*/sib-bus.xml";
    private static final ServerConfigChangeListener busListener;
    private final Hashtable<Integer, ListenerPortImpl> portToListenerMap;
    private static OutboundConnectionTracker connectionTracker;
    private static State state;
    private static AcceptListenerFactory acceptListenerFactory;

    public ServerConnectionManagerImpl() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.portToListenerMap = new Hashtable();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void closeAll(boolean quiesce) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeAll", (Object)("" + quiesce));
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeAll");
        }
    }

    public static void initialise(AcceptListenerFactory _acceptListenerFactory) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initalise");
        }
        acceptListenerFactory = _acceptListenerFactory;
        Framework framework = Framework.getInstance();
        if (framework == null) {
            state = State.INITIALISATION_FAILED;
        } else {
            state = State.INITIALISED;
            connectionTracker = new OutboundConnectionTracker(framework);
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initalise");
        }
    }

    public static void initialiseAcceptListenerFactory(AcceptListenerFactory _acceptListenerFactory) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseAcceptListenerFactory", (Object)_acceptListenerFactory);
        }
        acceptListenerFactory = _acceptListenerFactory;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseAcceptListenerFactory");
        }
    }

    @Override
    public Conversation connect(InetSocketAddress remoteHost, ConversationReceiveListener convRecvListener, String chainName) throws SIResourceException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{remoteHost, convRecvListener, chainName});
        }
        if (state == State.UNINITIALISED) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        if (state == State.INITIALISATION_FAILED) {
            String nlsMsg = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection failed because comms failed to initialise");
            }
            throw new SIResourceException(nlsMsg);
        }
        Conversation retValue = connectionTracker.connect(remoteHost, convRecvListener, chainName, Conversation.ME);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retValue);
        }
        return retValue;
    }

    @Override
    public Conversation connect(CFEndPoint endpoint, ConversationReceiveListener convRecvListener) throws SIResourceException {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{endpoint, convRecvListener});
        }
        if (state == State.UNINITIALISED) {
            throw new SIErrorException(nls.getFormattedMessage("SVRCONNMGR_INTERNAL_SICJ0059", null, "SVRCONNMGR_INTERNAL_SICJ0059"));
        }
        if (state == State.INITIALISATION_FAILED) {
            String nlsMsg = nls.getFormattedMessage("EXCP_CONN_FAIL_NO_CF_SICJ0007", null, null);
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"connection failed because comms failed to initialise");
            }
            throw new SIResourceException(nlsMsg);
        }
        Conversation retValue = connectionTracker.connect((Object)endpoint, convRecvListener, Conversation.ME);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)retValue);
        }
        return retValue;
    }

    protected static AcceptListenerFactory getAcceptListenerFactory() {
        return acceptListenerFactory;
    }

    @Override
    public List getActiveOutboundMEtoMEConversations() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getActiveOutboundMEtoMEConversations");
        }
        List convs = null;
        if (connectionTracker != null) {
            convs = connectionTracker.getAllOutboundConversations();
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getActiveOutboundMEtoMEConversations", (Object)convs);
        }
        return convs;
    }

    static {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.server.impl/src/com/ibm/ws/sib/jfapchannel/impl/ServerConnectionManagerImpl.java, SIB.comms, WASX.SIB, aa1225.01 1.53");
        }
        busListener = new ServerConfigChangeListener();
        connectionTracker = null;
        state = State.UNINITIALISED;
    }

    private static enum State {
        UNINITIALISED,
        INITIALISED,
        INITIALISATION_FAILED;

    }

    private static final class ServerConfigChangeListener {
        private ServerConfigChangeListener() {
        }

        public void configChanged() {
        }
    }
}

