/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.io.Serializable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.transaction.TransactionException;

public final class TransactionIDSerializedForm
implements Serializable {
    private final String cacheManagerName;
    private final String clusterUUID;
    private final long creationTime;
    private final int id;
    private final boolean commit;

    public TransactionIDSerializedForm(String cacheManagerName, String clusterUUID, long creationTime, int id, boolean commit) {
        this.cacheManagerName = cacheManagerName;
        this.clusterUUID = clusterUUID;
        this.creationTime = creationTime;
        this.id = id;
        this.commit = commit;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public int getId() {
        return this.id;
    }

    public boolean isCommit() {
        return this.commit;
    }

    private Object readResolve() {
        CacheManager cacheManager = CacheManager.getCacheManager(this.cacheManagerName);
        if (cacheManager == null) {
            throw new TransactionException("unable to restore transaction ID from " + this.cacheManagerName);
        }
        return cacheManager.getOrCreateTransactionIDFactory().restoreTransactionID(this);
    }
}

