/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.util.Hex;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANS;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;

public final class IORUtil {
    private static void describeCSISecMechList(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        boolean endianFlag = in.read_boolean();
        in._OB_readEndian();
        CompoundSecMechList info = CompoundSecMechListHelper.read((InputStream)in);
        sb.append("CSI Security Mechanism List Components:\n");
        sb.append("    stateful: " + info.stateful + "\n");
        sb.append("    mechanism_list:\n");
        for (CompoundSecMech mech : info.mechanism_list) {
            sb.append("        target_requires: ");
            IORUtil.describeTransportFlags(mech.target_requires, sb);
            sb.append("\n");
            if (mech.transport_mech != null) {
                if (mech.transport_mech.tag == 34) {
                    sb.append("            Null Transport\n");
                } else if (mech.transport_mech.tag == 36) {
                    IORUtil.describeTLS_SEC_TRANS(mech.transport_mech, sb);
                } else if (mech.transport_mech.tag == 35) {
                    IORUtil.describeSECIOP_SEC_TRANS(mech.transport_mech, sb);
                }
            }
            if (mech.as_context_mech != null) {
                sb.append("            as_context_mech:\n");
                sb.append("                supports: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_supports, sb);
                sb.append("\n");
                sb.append("                requires: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_requires, sb);
                sb.append("\n");
                sb.append("                client_authentication_mech: ");
                Hex.formatHexLine((byte[])mech.as_context_mech.client_authentication_mech, (StringBuilder)sb);
                sb.append("\n");
                sb.append("                target_name: ");
                Hex.formatHexLine((byte[])mech.as_context_mech.target_name, (StringBuilder)sb);
                sb.append("\n");
            }
            if (mech.sas_context_mech == null) continue;
            sb.append("            sas_context_mech:\n");
            sb.append("                supports: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_supports, sb);
            sb.append("\n");
            sb.append("                requires: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_requires, sb);
            sb.append("\n");
            sb.append("                privilege_authorities:\n");
            for (ServiceConfiguration auth : mech.sas_context_mech.privilege_authorities) {
                sb.append("                    syntax: " + auth.syntax + "\n");
                sb.append("                    name: ");
                Hex.formatHexLine((byte[])auth.name, (StringBuilder)sb);
                sb.append("\n");
            }
            sb.append("                supported_naming_mechanisms:\n");
            for (byte[] namingMech : mech.sas_context_mech.supported_naming_mechanisms) {
                sb.append("                    ");
                Hex.formatHexLine((byte[])namingMech, (StringBuilder)sb);
                sb.append("\n");
            }
            sb.append("                supported_identity_type: ");
            IORUtil.describeIdentityToken(mech.sas_context_mech.supported_identity_types, sb);
            sb.append("\n");
        }
    }

    private static void describeTransportFlags(int flag, StringBuilder sb) {
        if ((1 & flag) != 0) {
            sb.append("NoProtection ");
        }
        if ((2 & flag) != 0) {
            sb.append("Integrity ");
        }
        if ((4 & flag) != 0) {
            sb.append("Confidentiality ");
        }
        if ((8 & flag) != 0) {
            sb.append("DetectReplay ");
        }
        if ((0x10 & flag) != 0) {
            sb.append("DetectMisordering ");
        }
        if ((0x20 & flag) != 0) {
            sb.append("EstablishTrustInTarget ");
        }
        if ((0x40 & flag) != 0) {
            sb.append("EstablishTrustInClient ");
        }
        if ((0x80 & flag) != 0) {
            sb.append("NoDelegation ");
        }
        if ((0x100 & flag) != 0) {
            sb.append("SimpleDelegation ");
        }
        if ((0x200 & flag) != 0) {
            sb.append("CompositeDelegation ");
        }
        if ((0x400 & flag) != 0) {
            sb.append("IdentityAssertion ");
        }
        if ((0x800 & flag) != 0) {
            sb.append("DelegationByClient ");
        }
    }

    private static void describeIdentityToken(int flag, StringBuilder sb) {
        if (flag == 0) {
            sb.append("Absent");
            return;
        }
        if ((1 & flag) != 0) {
            sb.append("Anonymous ");
        }
        if ((2 & flag) != 0) {
            sb.append("PrincipalName ");
        }
        if ((4 & flag) != 0) {
            sb.append("X509CertChain ");
        }
        if ((8 & flag) != 0) {
            sb.append("DistinguishedName ");
        }
    }

    private static void describeTLS_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        TLS_SEC_TRANS info = TLS_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        TLS_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeSECIOP_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        SECIOP_SEC_TRANS info = SECIOP_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        SECIOP_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            mech_oid: ");
        Hex.formatHexLine((byte[])info.mech_oid, (StringBuilder)sb);
        sb.append("\n");
        sb.append("            target_name: ");
        Hex.formatHexLine((byte[])info.target_name, (StringBuilder)sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeCodeSets(TaggedComponent component, StringBuilder sb) {
        int i;
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        CodeSetComponentInfo info = CodeSetComponentInfoHelper.read((InputStream)in);
        sb.append("Native char codeset: \n");
        CodeSetInfo charInfo = CodeSetInfo.forRegistryId(info.ForCharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"");
            sb.append(charInfo.description);
            sb.append("\"\n");
        } else if (info.ForCharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForCharData.native_code_set);
            sb.append("]\n");
        }
        for (i = 0; i < info.ForCharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                sb.append("Char conversion codesets:\n");
            }
            if ((charInfo = CodeSetInfo.forRegistryId(info.ForCharData.conversion_code_sets[i])) != null) {
                sb.append("  \"");
                sb.append(charInfo.description);
                sb.append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForCharData.conversion_code_sets[i]);
            sb.append("]\n");
        }
        sb.append("Native wchar codeset: \n");
        charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"");
            sb.append(charInfo.description);
            sb.append("\"\n");
        } else if (info.ForWcharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForWcharData.native_code_set);
            sb.append("]\n");
        }
        for (i = 0; i < info.ForWcharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                sb.append("Wchar conversion codesets:\n");
            }
            if ((charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.conversion_code_sets[i])) != null) {
                sb.append("  \"");
                sb.append(charInfo.description);
                sb.append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ");
            sb.append(info.ForWcharData.conversion_code_sets[i]);
            sb.append("]\n");
        }
    }

    private static void describeGenericComponent(TaggedComponent component, String name, StringBuilder sb) {
        sb.append("Component: ");
        sb.append(name);
        sb.append('\n');
        sb.append("Component data: (");
        sb.append(component.component_data.length);
        sb.append(")\n");
        Hex.formatHexPara((byte[])component.component_data, (int)0, (int)component.component_data.length, (StringBuilder)sb);
    }

    public static void describe_component(TaggedComponent component, StringBuilder sb) {
        switch (component.tag) {
            case 0: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                int id = in.read_ulong();
                sb.append("Component: TAG_ORB_TYPE = ");
                sb.append("0x");
                sb.append(Integer.toHexString(id));
                sb.append('\n');
                break;
            }
            case 1: {
                IORUtil.describeCodeSets(component, sb);
                break;
            }
            case 2: {
                IORUtil.describeGenericComponent(component, "TAG_POLICIES", sb);
                break;
            }
            case 3: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                String host = in.read_string();
                int port = in.read_ushort();
                sb.append("Alternate IIOP address:\n");
                sb.append("  host: ");
                sb.append(host);
                sb.append('\n');
                sb.append("  port: ");
                sb.append(port < 0 ? 65535 + port + 1 : port);
                sb.append('\n');
                break;
            }
            case 13: {
                IORUtil.describeGenericComponent(component, "TAG_ASSOCIATION_OPTIONS", sb);
                break;
            }
            case 14: {
                IORUtil.describeGenericComponent(component, "TAG_SEC_NAME", sb);
                break;
            }
            case 15: {
                IORUtil.describeGenericComponent(component, "TAG_SPKM_1_SEC_MECH", sb);
                break;
            }
            case 16: {
                IORUtil.describeGenericComponent(component, "TAG_SPKM_2_SEC_MECH", sb);
                break;
            }
            case 17: {
                IORUtil.describeGenericComponent(component, "TAG_KerberosV5_SEC_MECH", sb);
                break;
            }
            case 18: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Secret_SEC_MECH", sb);
                break;
            }
            case 19: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Hybrid_SEC_MECH", sb);
                break;
            }
            case 33: {
                IORUtil.describeCSISecMechList(component, sb);
                break;
            }
            case 31: {
                IORUtil.describeGenericComponent(component, "TAG_OTS_POLICY", sb);
                break;
            }
            case 32: {
                IORUtil.describeGenericComponent(component, "TAG_INV_POLICY", sb);
                break;
            }
            case 35: {
                IORUtil.describeGenericComponent(component, "TAG_SECIOP_SEC_TRANS", sb);
                break;
            }
            case 34: {
                IORUtil.describeGenericComponent(component, "TAG_NULL_TAG", sb);
                break;
            }
            case 36: {
                IORUtil.describeGenericComponent(component, "TAG_TLS_SEC_TRANS", sb);
                break;
            }
            case 20: {
                IORUtil.describeGenericComponent(component, "TAG_SSL_SEC_TRANS", sb);
                break;
            }
            case 21: {
                IORUtil.describeGenericComponent(component, "TAG_CSI_ECMA_Public_SEC_MECH", sb);
                break;
            }
            case 22: {
                IORUtil.describeGenericComponent(component, "TAG_GENERIC_SEC_MECH", sb);
                break;
            }
            case 25: {
                org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
                in._OB_readEndian();
                String codebase = in.read_string();
                sb.append("Component: TAG_JAVA_CODEBASE = `");
                sb.append(codebase);
                sb.append("'\n");
                break;
            }
            case 5: {
                IORUtil.describeGenericComponent(component, "TAG_COMPLETE_OBJECT_KEY", sb);
                break;
            }
            case 6: {
                IORUtil.describeGenericComponent(component, "TAG_ENDPOINT_ID_POSITION", sb);
                break;
            }
            case 12: {
                IORUtil.describeGenericComponent(component, "TAG_LOCATION_POLICY", sb);
                break;
            }
            case 100: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_STRING_BINDING", sb);
                break;
            }
            case 101: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_BINDING_NAME", sb);
                break;
            }
            case 102: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_NO_PIPES", sb);
                break;
            }
            case 103: {
                IORUtil.describeGenericComponent(component, "TAG_DCE_SEC_MECH", sb);
                break;
            }
            default: {
                String name = "unknown (tag = ";
                name = name + component.tag;
                name = name + ")";
                IORUtil.describeGenericComponent(component, name, sb);
                break;
            }
        }
    }
}

