/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI.IIOP;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.OB.Net;
import org.apache.yoko.orb.OCI.IIOP.InternalError;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.orb.OCI.ProfileInfoHolder;
import org.apache.yoko.orb.OCI.ProfileInfoSeqHolder;
import org.apache.yoko.util.Assert;
import org.omg.CORBA.Any;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IIOP.ProfileBody_1_0;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

public final class Util {
    public static IOR createIOR(String host, int port, String id, ProfileInfo profileInfo) {
        IOR ior = new IOR();
        ior.type_id = id;
        ior.profiles = new TaggedProfile[1];
        ior.profiles[0] = new TaggedProfile();
        ior.profiles[0].tag = 0;
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            ProfileBody_1_0 body = new ProfileBody_1_0();
            body.iiop_version = new Version(1, 0);
            body.host = host;
            body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
            body.object_key = profileInfo.key;
            try (OutputStream out = new OutputStream();){
                out._OB_writeEndian();
                ProfileBody_1_0Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_0)body);
                ior.profiles[0].profile_data = out.copyWrittenBytes();
            }
        }
        ProfileBody_1_1 body = new ProfileBody_1_1();
        body.iiop_version = new Version(profileInfo.major, profileInfo.minor);
        body.host = host;
        body.port = port >= 32768 ? (short)(port - 65535 - 1) : (short)port;
        body.object_key = profileInfo.key;
        body.components = profileInfo.components;
        try (OutputStream out = new OutputStream();){
            out._OB_writeEndian();
            ProfileBody_1_1Helper.write((org.omg.CORBA.portable.OutputStream)out, (ProfileBody_1_1)body);
            ior.profiles[0].profile_data = out.copyWrittenBytes();
        }
        return ior;
    }

    public static IOR createIOR(IOR ior, String id, byte[] key) {
        int profile;
        for (profile = 0; profile < ior.profiles.length && ior.profiles[profile].tag != 0; ++profile) {
        }
        Assert.ensure((profile < ior.profiles.length ? 1 : 0) != 0);
        InputStream in = new InputStream(ior.profiles[profile].profile_data);
        in._OB_readEndian();
        ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
        ProfileInfo profileInfo = new ProfileInfo();
        profileInfo.key = key;
        profileInfo.major = body.iiop_version.major;
        profileInfo.minor = body.iiop_version.minor;
        profileInfo.components = new TaggedComponent[0];
        return Util.createIOR(body.host, body.port, id, profileInfo);
    }

    public static boolean extractProfileInfo(IOR ior, ProfileInfoHolder profileInfo) {
        ProfileInfoSeqHolder profileInfoSeq = new ProfileInfoSeqHolder();
        profileInfoSeq.value = new ProfileInfo[0];
        Util.extractAllProfileInfos(ior, profileInfoSeq, false, null, 0, false, null);
        if (profileInfoSeq.value.length > 0) {
            profileInfo.value = profileInfoSeq.value[0];
            return true;
        }
        return false;
    }

    public static boolean hostMatch(String host1, String host2, boolean matchLoopback) {
        return Net.CompareHosts(host1, host2, matchLoopback);
    }

    public static void extractAllProfileInfos(IOR ior, ProfileInfoSeqHolder profileInfoSeq, boolean performMatch, String host, int port, boolean matchLoopback, Codec codec) {
        short portNo = (short)port;
        ArrayList<ProfileInfo> list = new ArrayList<ProfileInfo>();
        for (int i = 0; i < ior.profiles.length; ++i) {
            TaggedComponent[] components;
            if (ior.profiles[i].tag != 0) continue;
            InputStream in = new InputStream(ior.profiles[i].profile_data);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
            if (body.iiop_version.major > 1 || body.iiop_version.minor > 0) {
                int len = in.read_ulong();
                components = new TaggedComponent[len];
                for (int j = 0; j < len; ++j) {
                    components[j] = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                }
            } else {
                components = new TaggedComponent[]{};
            }
            if (performMatch && !Util.hostAndPortMatch(host, portNo, body.host, body.port, matchLoopback) && !Util.taggedComponentsMatch(components, host, portNo, codec, matchLoopback)) continue;
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.key = body.object_key;
            profileInfo.minor = body.iiop_version.minor;
            profileInfo.major = body.iiop_version.major;
            profileInfo.id = ior.profiles[i].tag;
            profileInfo.index = i;
            profileInfo.components = components;
            list.add(profileInfo);
        }
        if (!list.isEmpty()) {
            ArrayList<ProfileInfo> bigList = new ArrayList<ProfileInfo>(Arrays.asList(profileInfoSeq.value));
            bigList.addAll(list);
            profileInfoSeq.value = bigList.toArray(profileInfoSeq.value);
        }
    }

    private static boolean hostAndPortMatch(String host, short portNo, String bodyHost, short bodyPort, boolean matchLoopback) {
        return portNo == bodyPort && Util.hostMatch(host, bodyHost, matchLoopback);
    }

    private static boolean taggedComponentsMatch(TaggedComponent[] components, String host, short port, Codec codec, boolean matchLoopback) {
        for (TaggedComponent component : components) {
            if (component.tag == 3) {
                InputStream s = new InputStream(component.component_data);
                s._OB_readEndian();
                String altHost = s.read_string();
                short altPort = s.read_ushort();
                if (!Util.hostAndPortMatch(host, port, altHost, altPort, matchLoopback)) continue;
                return true;
            }
            if (component.tag != 33) continue;
            try {
                Any any = codec.decode_value(component.component_data, CompoundSecMechListHelper.type());
                CompoundSecMechList csml = CompoundSecMechListHelper.extract((Any)any);
                for (CompoundSecMech csm : csml.mechanism_list) {
                    TaggedComponent tc = csm.transport_mech;
                    if (tc.tag != 36) continue;
                    Any tstAny = codec.decode_value(tc.component_data, TLS_SEC_TRANSHelper.type());
                    TLS_SEC_TRANS tst = TLS_SEC_TRANSHelper.extract((Any)tstAny);
                    TransportAddress[] transportAddresses = tst.addresses;
                    if (!Util.transportAddressesMatch(transportAddresses, host, port, matchLoopback)) continue;
                    return true;
                }
            }
            catch (FormatMismatch | TypeMismatch throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean transportAddressesMatch(TransportAddress[] addrs, String host, short port, boolean loopbackMatches) {
        for (TransportAddress addr : addrs) {
            short addrPort = addr.port;
            if (!Util.hostAndPortMatch(host, port, addr.host_name, addrPort, loopbackMatches)) continue;
            return true;
        }
        return false;
    }

    public static boolean equivalent(IOR ior1, IOR ior2) {
        InputStream in;
        int p2;
        int p1;
        int cnt1 = 0;
        int cnt2 = 0;
        for (p1 = 0; p1 < ior1.profiles.length; ++p1) {
            if (ior1.profiles[p1].tag != 0) continue;
            ++cnt1;
        }
        for (p2 = 0; p2 < ior2.profiles.length; ++p2) {
            if (ior2.profiles[p2].tag != 0) continue;
            ++cnt2;
        }
        if (cnt1 != cnt2) {
            return false;
        }
        ProfileBody_1_0[] bodies1 = new ProfileBody_1_0[cnt1];
        int b1 = 0;
        for (p1 = 0; p1 < ior1.profiles.length; ++p1) {
            if (ior1.profiles[p1].tag != 0) continue;
            in = new InputStream(ior1.profiles[p1].profile_data);
            in._OB_readEndian();
            bodies1[b1++] = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
        }
        if (b1 != cnt1) {
            throw new InternalError();
        }
        ProfileBody_1_0[] bodies2 = new ProfileBody_1_0[cnt2];
        int b2 = 0;
        for (p2 = 0; p2 < ior2.profiles.length; ++p2) {
            if (ior2.profiles[p2].tag != 0) continue;
            in = new InputStream(ior2.profiles[p2].profile_data);
            in._OB_readEndian();
            bodies2[b2++] = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
        }
        if (b2 != cnt2) {
            throw new InternalError();
        }
        block4: for (b1 = 0; b1 < cnt1; ++b1) {
            for (b2 = 0; b2 < cnt2; ++b2) {
                if (bodies2[b2] == null || !Util.compareBodies(bodies1[b1], bodies2[b2])) continue;
                bodies1[b1] = null;
                bodies2[b2] = null;
                continue block4;
            }
        }
        for (b1 = 0; b1 < cnt1; ++b1) {
            if (bodies1[b1] == null) continue;
            return false;
        }
        for (b2 = 0; b2 < cnt2; ++b2) {
            if (bodies2[b2] == null) continue;
            return false;
        }
        return true;
    }

    static boolean compareBodies(ProfileBody_1_0 body1, ProfileBody_1_0 body2) {
        if (body1.iiop_version.major != body2.iiop_version.major || body1.iiop_version.minor != body2.iiop_version.minor) {
            return false;
        }
        if (body1.port != body2.port) {
            return false;
        }
        if (body1.object_key.length != body2.object_key.length) {
            return false;
        }
        for (int k = 0; k < body1.object_key.length; ++k) {
            if (body1.object_key[k] == body2.object_key[k]) continue;
            return false;
        }
        return Net.CompareHosts(body1.host, body2.host);
    }

    public static int hash(IOR ior, int maximum) {
        int hash = 0;
        for (TaggedProfile profile : ior.profiles) {
            if (profile.tag == 0) continue;
            InputStream in = new InputStream(profile.profile_data);
            in._OB_readEndian();
            ProfileBody_1_0 body = ProfileBody_1_0Helper.read((org.omg.CORBA.portable.InputStream)in);
            hash ^= body.port;
            int j = 0;
            while (j + 1 < body.object_key.length) {
                hash ^= body.object_key[j + 1] * 256 + body.object_key[j];
                j += 2;
            }
        }
        return hash % (maximum + 1);
    }

    public static String encodeHost(String host, String protocol, String info) {
        return "_" + protocol + "[" + info + "]." + host;
    }

    public static boolean isEncodedHost(String host) {
        return host != null & host.startsWith("_");
    }

    public static boolean isEncodedHost(String host, String protocol) {
        return host != null & host.startsWith("_" + protocol);
    }

    public static String decodeHost(String host) {
        if (host == null) {
            return null;
        }
        int index = host.lastIndexOf("].");
        return index < 0 ? host : host.substring(index + 2);
    }

    public static String decodeHostInfo(String host) {
        if (host == null) {
            return null;
        }
        int start = host.indexOf(91);
        int end = host.lastIndexOf("].");
        if (start < 0 || end < 0 || end <= start) {
            return null;
        }
        return host.substring(start + 1, end);
    }

    static InetAddress getInetAddress(final String host) throws UnknownHostException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InetAddress>(){

                @Override
                public InetAddress run() throws Exception {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getException();
            }
            catch (RuntimeException | UnknownHostException e2) {
                throw e2;
            }
            catch (Exception e2) {
                throw new RuntimeException("Unexpected exception", e2);
            }
        }
    }
}

