/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OCI;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.OB.OptionFilter;
import org.apache.yoko.orb.OCI.IIOP.ConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.ExtendedConnectionHelper;
import org.apache.yoko.orb.OCI.IIOP.Plugin_impl;
import org.apache.yoko.orb.OCI.Plugin;
import org.apache.yoko.orb.OCI.PluginInit;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.util.AssertionFailed;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.StringSeqHolder;

public class iiop
implements PluginInit {
    static final Logger logger = Logger.getLogger(iiop.class.getName());
    private String connectionHelper = "org.apache.yoko.orb.OCI.IIOP.DefaultConnectionHelper";
    private String helperArgs = "";

    @Override
    public void version(org.omg.CORBA.ORB orb, String ver) {
    }

    @Override
    public Plugin init(org.omg.CORBA.ORB orb, StringSeqHolder args) {
        ORB oborb = (ORB)orb;
        Properties props = oborb.properties();
        args.value = this.parse_args(args.value, props);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class c = ProviderLocator.loadClass((String)this.connectionHelper, this.getClass(), (ClassLoader)loader);
            Object o = c.newInstance();
            if (o instanceof ConnectionHelper) {
                ConnectionHelper helper = (ConnectionHelper)o;
                helper.init(orb, this.helperArgs);
                return new Plugin_impl(orb, helper);
            }
            if (o instanceof ExtendedConnectionHelper) {
                ExtendedConnectionHelper helper = (ExtendedConnectionHelper)o;
                helper.init(orb, this.helperArgs);
                return new Plugin_impl(orb, helper);
            }
            throw new AssertionFailed("connection helper class " + this.connectionHelper + " does not implement ConnectionHelper or ExtendedConnectionHelper");
        }
        catch (AssertionFailed af) {
            throw af;
        }
        catch (INITIALIZE i) {
            throw i;
        }
        catch (Exception ex) {
            throw new INITIALIZE("unable to load IIOP ConnectionHelper plug-in `" + this.connectionHelper + "': " + ex.getMessage());
        }
    }

    public String[] parse_args(String[] args, Properties props) {
        String value;
        String backlog = null;
        String bind = null;
        String host = null;
        boolean numeric = false;
        String port = null;
        boolean haveArgs = false;
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.startsWith("org.omg.CORBA.")) {
                int sep;
                value = props.getProperty(key);
                if (key.equals("org.omg.CORBA.ORBInitialHost")) {
                    host = value;
                    haveArgs = true;
                    logger.fine("Using ORBInitialHost value of " + host);
                    continue;
                }
                if (key.equals("org.omg.CORBA.ORBInitialPort")) {
                    port = value;
                    haveArgs = true;
                    logger.fine("Using ORBInitialPort value of " + port);
                    continue;
                }
                if (!key.equals("org.omg.CORBA.ORBListenEndpoints") || (sep = value.indexOf(58)) == -1) continue;
                host = value.substring(0, sep);
                port = value.substring(sep + 1);
                haveArgs = true;
                logger.fine("Using ORBListenEndpoints values of " + host + "/" + port);
                continue;
            }
            if (!key.startsWith("yoko.iiop.")) continue;
            value = props.getProperty(key);
            if (key.equals("yoko.iiop.host")) {
                host = value;
                haveArgs = true;
                logger.fine("Using yoko.iiop.host value of " + host);
                continue;
            }
            if (key.equals("yoko.iiop.numeric")) {
                numeric = true;
                haveArgs = true;
                logger.fine("Using yoko.iiop.numeric value");
                continue;
            }
            if (key.equals("yoko.iiop.port")) {
                port = value;
                haveArgs = true;
                logger.fine("Using yoko.iiop.port value of " + port);
                continue;
            }
            throw new INITIALIZE("iiop: unknown property " + key);
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-IIOPbacklog")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for -IIOPbacklog");
                }
                backlog = args[i + 1];
                haveArgs = true;
                i += 2;
                continue;
            }
            if (args[i].equals("-IIOPbind")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for -IIOPbind");
                }
                bind = args[i + 1];
                haveArgs = true;
                i += 2;
                continue;
            }
            if (args[i].equals("-IIOPhost") || args[i].equals("-OAhost")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for " + args[i]);
                }
                host = args[i + 1];
                haveArgs = true;
                i += 2;
                continue;
            }
            if (args[i].equals("-IIOPnumeric") || args[i].equals("-OAnumeric")) {
                numeric = true;
                haveArgs = true;
                ++i;
                continue;
            }
            if (args[i].equals("-IIOPport") || args[i].equals("-OAport")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for " + args[i]);
                }
                port = args[i + 1];
                haveArgs = true;
                i += 2;
                continue;
            }
            if (args[i].equals("-IIOPconnectionHelper")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for " + args[i]);
                }
                this.connectionHelper = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equals("-IIOPconnectionHelperArgs")) {
                if (i + 1 >= args.length) {
                    throw new INITIALIZE("iiop: argument expected for " + args[i]);
                }
                this.helperArgs = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].startsWith("-IIOP")) {
                throw new INITIALIZE("iiop: unknown option `" + args[i] + "'");
            }
            ++i;
        }
        if (haveArgs) {
            String propName = "yoko.orb.poamanager.RootPOAManager.endpoint";
            value = props.getProperty(propName);
            if (value == null) {
                propName = "yoko.orb.oa.endpoint";
                value = props.getProperty(propName);
            }
            String str = "iiop";
            if (backlog != null) {
                str = str + " --backlog ";
                str = str + backlog;
            }
            if (bind != null) {
                str = str + " --bind ";
                str = str + bind;
            }
            if (host != null) {
                str = str + " --host ";
                if (host.indexOf(44) != -1) {
                    str = str + '\"';
                    str = str + host;
                    str = str + '\"';
                } else {
                    str = str + host;
                }
            }
            if (numeric) {
                str = str + " --numeric";
            }
            if (port != null) {
                str = str + " --port ";
                str = str + port;
            }
            if (value == null) {
                logger.fine("Setting endpoint property " + propName + " to " + str);
                props.put(propName, str);
            } else {
                logger.fine("Setting endpoint property " + propName + " to " + value + ", " + str);
                props.put(propName, value + ", " + str);
            }
        }
        OptionFilter filter = new OptionFilter("iiop.parse_args", "-OA");
        filter.add("host", 1);
        filter.add("numeric", 0);
        filter.add("port", 1);
        args = filter.filter(args);
        filter = new OptionFilter("iiop.parse_args", "-IIOP");
        filter.add("backlog", 1);
        filter.add("bind", 1);
        filter.add("host", 1);
        filter.add("numeric", 0);
        filter.add("port", 1);
        return filter.filter(args);
    }
}

