/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.impl;

import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.ConsumerRecord;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;

public class IncomingKafkaMessage<T>
implements Message<T> {
    private final ConsumerRecord<?, T> consumerRecord;
    private final Supplier<CompletionStage<Void>> ack;

    public IncomingKafkaMessage(ConsumerRecord<?, T> consumerRecord, Supplier<CompletionStage<Void>> ack) {
        this.consumerRecord = consumerRecord;
        this.ack = ack;
    }

    public T getPayload() {
        return (T)this.consumerRecord.value();
    }

    public CompletionStage<Void> ack() {
        if (this.ack != null) {
            return this.ack.get();
        }
        return CompletableFuture.completedFuture(null);
    }

    public <C> C unwrap(Class<C> unwrapType) {
        if (unwrapType == null) {
            throw new IllegalArgumentException("The target class must not be `null`");
        }
        if (org.apache.kafka.clients.consumer.ConsumerRecord.class.equals(unwrapType)) {
            return unwrapType.cast(this.consumerRecord.getDelegate());
        }
        try {
            return unwrapType.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot unwrap an instance of " + this.getClass().getName() + " to " + unwrapType.getName(), e);
        }
    }
}

